/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.BlockOwnable;
import net.geforcemods.securitycraft.tileentity.TileEntityMotionLight;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;

public class BlockMotionActivatedLight
extends BlockOwnable {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    private static final VoxelShape SHAPE_NORTH = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)6.0, (double)3.0, (double)13.0, (double)10.0, (double)4.0, (double)14.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)6.0, (double)6.0, (double)13.0, (double)10.0, (double)9.0, (double)14.0), (VoxelShape)VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)7.0, (double)3.0, (double)14.0, (double)9.0, (double)8.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)7.0, (double)4.0, (double)15.0, (double)9.0, (double)7.0, (double)14.0), (IBooleanFunction)IBooleanFunction.ONLY_FIRST)));
    private static final VoxelShape SHAPE_EAST = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)3.0, (double)3.0, (double)6.0, (double)2.0, (double)4.0, (double)10.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)3.0, (double)6.0, (double)6.0, (double)2.0, (double)9.0, (double)10.0), (VoxelShape)VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)2.0, (double)3.0, (double)7.0, (double)0.0, (double)8.0, (double)9.0), (VoxelShape)Block.func_208617_a((double)1.0, (double)4.0, (double)7.0, (double)2.0, (double)7.0, (double)9.0), (IBooleanFunction)IBooleanFunction.ONLY_FIRST)));
    private static final VoxelShape SHAPE_SOUTH = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)6.0, (double)3.0, (double)2.0, (double)10.0, (double)4.0, (double)3.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)6.0, (double)6.0, (double)2.0, (double)10.0, (double)9.0, (double)3.0), (VoxelShape)VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)7.0, (double)3.0, (double)0.0, (double)9.0, (double)8.0, (double)2.0), (VoxelShape)Block.func_208617_a((double)7.0, (double)4.0, (double)1.0, (double)9.0, (double)7.0, (double)2.0), (IBooleanFunction)IBooleanFunction.ONLY_FIRST)));
    private static final VoxelShape SHAPE_WEST = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)13.0, (double)3.0, (double)6.0, (double)14.0, (double)4.0, (double)10.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)13.0, (double)6.0, (double)6.0, (double)14.0, (double)9.0, (double)10.0), (VoxelShape)VoxelShapes.func_197882_b((VoxelShape)Block.func_208617_a((double)14.0, (double)3.0, (double)7.0, (double)16.0, (double)8.0, (double)9.0), (VoxelShape)Block.func_208617_a((double)15.0, (double)4.0, (double)7.0, (double)14.0, (double)7.0, (double)9.0), (IBooleanFunction)IBooleanFunction.ONLY_FIRST)));

    public BlockMotionActivatedLight(Material material) {
        super(SoundType.field_185853_f, Block.Properties.func_200945_a((Material)material).func_200948_a(-1.0f, 6000000.0f));
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)EnumFacing.NORTH)).func_206870_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader world, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                return SHAPE_NORTH;
            }
            case EAST: {
                return SHAPE_EAST;
            }
            case SOUTH: {
                return SHAPE_SOUTH;
            }
            case WEST: {
                return SHAPE_WEST;
            }
        }
        return VoxelShapes.func_197868_b();
    }

    public int getLightValue(IBlockState state, IWorldReader world, BlockPos pos) {
        if (BlockUtils.getBlock((IBlockReader)world, pos) != SCContent.motionActivatedLight) {
            return 0;
        }
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)LIT) != false ? 15 : 0;
    }

    public static void toggleLight(World world, BlockPos pos, double searchRadius, Owner owner, boolean isLit) {
        if (!world.field_72995_K) {
            if (isLit) {
                BlockUtils.setBlockProperty(world, pos, LIT, true);
                if ((IOwnable)world.func_175625_s(pos) != null) {
                    ((IOwnable)world.func_175625_s(pos)).setOwner(owner.getUUID(), owner.getName());
                }
                BlockUtils.updateAndNotify(world, pos, SCContent.motionActivatedLight, 1, false);
            } else {
                BlockUtils.setBlockProperty(world, pos, LIT, false);
                if ((IOwnable)world.func_175625_s(pos) != null) {
                    ((IOwnable)world.func_175625_s(pos)).setOwner(owner.getUUID(), owner.getName());
                }
                BlockUtils.updateAndNotify(world, pos, SCContent.motionActivatedLight, 1, false);
            }
        }
    }

    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_196260_a(IBlockState state, IWorldReaderBase world, BlockPos pos) {
        EnumFacing side = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return side != EnumFacing.UP && side != EnumFacing.DOWN && BlockUtils.isSideSolid(world, pos.func_177972_a(side.func_176734_d()), side);
    }

    public IBlockState func_196258_a(BlockItemUseContext ctx) {
        return this.getStateForPlacement(ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l(), ctx.func_195997_m(), ctx.func_195993_n(), ctx.func_195994_o(), ctx.func_195999_j());
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, EntityPlayer placer) {
        return facing != EnumFacing.UP && facing != EnumFacing.DOWN && BlockUtils.isSideSolid((IWorldReaderBase)world, pos.func_177972_a(facing.func_176734_d()), facing) ? (IBlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)facing) : null;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!this.func_196260_a(state, (IWorldReaderBase)world, pos)) {
            this.func_196255_a(state, world, pos, 1.0f, 0);
            world.func_175698_g(pos);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
        builder.func_206894_a(new IProperty[]{LIT});
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileEntityMotionLight().attacks(EntityLivingBase.class, (Double)ConfigHandler.CommonConfig.CONFIG.motionActivatedLightSearchRadius.get(), 1);
    }
}

