/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class BlockPanicButton
extends BlockButton
implements ITileEntityProvider {
    private static final VoxelShape FLOOR_NS_POWERED = Block.func_208617_a((double)3.0, (double)0.0, (double)5.0, (double)13.0, (double)1.0, (double)11.0);
    private static final VoxelShape FLOOR_NS_UNPOWERED = Block.func_208617_a((double)3.0, (double)0.0, (double)5.0, (double)13.0, (double)2.0, (double)11.0);
    private static final VoxelShape FLOOR_EW_POWERED = Block.func_208617_a((double)5.0, (double)0.0, (double)3.0, (double)11.0, (double)1.0, (double)13.0);
    private static final VoxelShape FLOOR_EW_UNPOWERED = Block.func_208617_a((double)5.0, (double)0.0, (double)3.0, (double)11.0, (double)2.0, (double)13.0);
    private static final VoxelShape WALL_N_POWERED = Block.func_208617_a((double)3.0, (double)5.0, (double)15.0, (double)13.0, (double)11.0, (double)16.0);
    private static final VoxelShape WALL_N_UNPOWERED = Block.func_208617_a((double)3.0, (double)5.0, (double)14.0, (double)13.0, (double)11.0, (double)16.0);
    private static final VoxelShape WALL_S_POWERED = Block.func_208617_a((double)3.0, (double)5.0, (double)1.0, (double)13.0, (double)11.0, (double)0.0);
    private static final VoxelShape WALL_S_UNPOWERED = Block.func_208617_a((double)3.0, (double)5.0, (double)2.0, (double)13.0, (double)11.0, (double)0.0);
    private static final VoxelShape WALL_E_POWERED = Block.func_208617_a((double)1.0, (double)5.0, (double)3.0, (double)0.0, (double)11.0, (double)13.0);
    private static final VoxelShape WALL_E_UNPOWERED = Block.func_208617_a((double)2.0, (double)5.0, (double)3.0, (double)0.0, (double)11.0, (double)13.0);
    private static final VoxelShape WALL_W_POWERED = Block.func_208617_a((double)15.0, (double)5.0, (double)3.0, (double)16.0, (double)11.0, (double)13.0);
    private static final VoxelShape WALL_W_UNPOWERED = Block.func_208617_a((double)14.0, (double)5.0, (double)3.0, (double)16.0, (double)11.0, (double)13.0);
    private static final VoxelShape CEILING_NS_POWERED = Block.func_208617_a((double)3.0, (double)15.0, (double)5.0, (double)13.0, (double)16.0, (double)11.0);
    private static final VoxelShape CEILING_NS_UNPOWERED = Block.func_208617_a((double)3.0, (double)14.0, (double)5.0, (double)13.0, (double)16.0, (double)11.0);
    private static final VoxelShape CEILING_EW_POWERED = Block.func_208617_a((double)5.0, (double)15.0, (double)3.0, (double)11.0, (double)16.0, (double)13.0);
    private static final VoxelShape CEILING_EW_UNPOWERED = Block.func_208617_a((double)5.0, (double)14.0, (double)3.0, (double)11.0, (double)16.0, (double)13.0);

    public BlockPanicButton() {
        super(false, Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d).func_200948_a(-1.0f, 6000000.0f));
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)placer));
        }
    }

    public boolean func_196250_a(IBlockState state, World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        BlockUtils.setBlockProperty(world, pos, field_176584_b, (Boolean)state.func_177229_b((IProperty)field_176584_b) == false, true);
        world.func_175704_b(pos, pos);
        if (state.func_177229_b((IProperty)field_196366_M) == AttachFace.WALL) {
            this.notifyNeighbors(world, pos, (EnumFacing)state.func_177229_b((IProperty)field_185512_D));
        } else if (state.func_177229_b((IProperty)field_196366_M) == AttachFace.CEILING) {
            this.notifyNeighbors(world, pos, EnumFacing.DOWN);
        } else if (state.func_177229_b((IProperty)field_196366_M) == AttachFace.FLOOR) {
            this.notifyNeighbors(world, pos, EnumFacing.UP);
        }
        return true;
    }

    private void notifyNeighbors(World world, BlockPos pos, EnumFacing facing) {
        world.func_195593_d(pos, (Block)this);
        world.func_195593_d(pos.func_177972_a(facing.func_176734_d()), (Block)this);
    }

    public void func_196243_a(IBlockState state, World world, BlockPos pos, IBlockState newState, boolean isMoving) {
        super.func_196243_a(state, world, pos, newState, isMoving);
        world.func_175713_t(pos);
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        super.func_189539_a(state, world, pos, id, param);
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader source, BlockPos pos) {
        switch ((AttachFace)state.func_177229_b((IProperty)field_196366_M)) {
            case FLOOR: {
                switch ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)) {
                    case NORTH: 
                    case SOUTH: {
                        if (((Boolean)state.func_177229_b((IProperty)field_176584_b)).booleanValue()) {
                            return FLOOR_NS_POWERED;
                        }
                        return FLOOR_NS_UNPOWERED;
                    }
                    case EAST: 
                    case WEST: {
                        if (((Boolean)state.func_177229_b((IProperty)field_176584_b)).booleanValue()) {
                            return FLOOR_EW_POWERED;
                        }
                        return FLOOR_EW_UNPOWERED;
                    }
                }
                break;
            }
            case WALL: {
                switch ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)) {
                    case NORTH: {
                        if (((Boolean)state.func_177229_b((IProperty)field_176584_b)).booleanValue()) {
                            return WALL_N_POWERED;
                        }
                        return WALL_N_UNPOWERED;
                    }
                    case SOUTH: {
                        if (((Boolean)state.func_177229_b((IProperty)field_176584_b)).booleanValue()) {
                            return WALL_S_POWERED;
                        }
                        return WALL_S_UNPOWERED;
                    }
                    case EAST: {
                        if (((Boolean)state.func_177229_b((IProperty)field_176584_b)).booleanValue()) {
                            return WALL_E_POWERED;
                        }
                        return WALL_E_UNPOWERED;
                    }
                    case WEST: {
                        if (((Boolean)state.func_177229_b((IProperty)field_176584_b)).booleanValue()) {
                            return WALL_W_POWERED;
                        }
                        return WALL_W_UNPOWERED;
                    }
                }
                break;
            }
            case CEILING: {
                switch ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)) {
                    case NORTH: 
                    case SOUTH: {
                        if (((Boolean)state.func_177229_b((IProperty)field_176584_b)).booleanValue()) {
                            return CEILING_NS_POWERED;
                        }
                        return CEILING_NS_UNPOWERED;
                    }
                    case EAST: 
                    case WEST: {
                        if (((Boolean)state.func_177229_b((IProperty)field_176584_b)).booleanValue()) {
                            return CEILING_EW_POWERED;
                        }
                        return CEILING_EW_UNPOWERED;
                    }
                }
            }
        }
        return VoxelShapes.func_197868_b();
    }

    public VoxelShape func_196268_f(IBlockState state, IBlockReader world, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public TileEntity func_196283_a_(IBlockReader reader) {
        return new TileEntityOwnable();
    }

    protected SoundEvent func_196369_b(boolean turningOn) {
        return turningOn ? SoundEvents.field_187839_fV : SoundEvents.field_187837_fU;
    }
}

