/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.tileentity.TileEntityPortableRadar;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class BlockPortableRadar
extends BlockContainer {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    private static final VoxelShape SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)7.0, (double)11.0);

    public BlockPortableRadar(Material material) {
        super(Block.Properties.func_200945_a((Material)material).func_200948_a(-1.0f, 6000000.0f));
        this.func_180632_j((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)placer));
        }
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader source, BlockPos pos) {
        return SHAPE;
    }

    public static void togglePowerOutput(World world, BlockPos pos, boolean par5) {
        if (par5 && !((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)POWERED)).booleanValue()) {
            BlockUtils.setBlockProperty(world, pos, POWERED, true, true);
            BlockUtils.updateAndNotify(world, pos, BlockUtils.getBlock(world, pos), 1, false);
        } else if (!par5 && ((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)POWERED)).booleanValue()) {
            BlockUtils.setBlockProperty(world, pos, POWERED, false, true);
            BlockUtils.updateAndNotify(world, pos, BlockUtils.getBlock(world, pos), 1, false);
        }
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockReader blockAccess, BlockPos pos, EnumFacing side) {
        if (((Boolean)blockState.func_177229_b((IProperty)POWERED)).booleanValue() && ((CustomizableSCTE)blockAccess.func_175625_s(pos)).hasModule(EnumCustomModules.REDSTONE)) {
            return 15;
        }
        return 0;
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{POWERED});
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileEntityPortableRadar().attacks(EntityPlayer.class, (Double)ConfigHandler.CommonConfig.CONFIG.portableRadarSearchRadius.get(), (Integer)ConfigHandler.CommonConfig.CONFIG.portableRadarDelay.get()).nameable();
    }
}

