/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.tileentity.TileEntityScannerDoor;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class BlockScannerDoor
extends BlockDoor
implements ITileEntityProvider {
    public BlockScannerDoor(Material material) {
        super(Block.Properties.func_200945_a((Material)material).func_200947_a(SoundType.field_185852_e).func_200948_a(-1.0f, 6000000.0f));
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        this.onNeighborChanged(world, pos, fromPos);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)placer));
        }
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public void onNeighborChanged(World world, BlockPos pos, BlockPos neighbor) {
        IBlockState state = world.func_180495_p(pos);
        Block neighborBlock = world.func_180495_p(neighbor).func_177230_c();
        if (state.func_177229_b((IProperty)field_176523_O) == DoubleBlockHalf.UPPER) {
            BlockPos blockBelow = pos.func_177977_b();
            IBlockState stateBelow = world.func_180495_p(blockBelow);
            if (stateBelow.func_177230_c() != this) {
                world.func_175698_g(pos);
            } else if (neighborBlock != this) {
                this.onNeighborChanged(world, blockBelow, neighbor);
            }
        } else {
            boolean drop = false;
            BlockPos blockBelow = pos.func_177984_a();
            IBlockState stateBelow = world.func_180495_p(blockBelow);
            if (stateBelow.func_177230_c() != this) {
                world.func_175698_g(pos);
                drop = true;
            }
            if (!world.func_195595_w(pos.func_177977_b())) {
                world.func_175698_g(pos);
                drop = true;
                if (stateBelow.func_177230_c() == this) {
                    world.func_175698_g(blockBelow);
                }
            }
            if (drop && !world.field_72995_K) {
                this.func_196255_a(state, world, pos, 1.0f, 0);
            }
        }
    }

    public void func_196243_a(IBlockState state, World world, BlockPos pos, IBlockState newState, boolean isMoving) {
        super.func_196243_a(state, world, pos, newState, isMoving);
        world.func_175713_t(pos);
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        super.func_189539_a(state, world, pos, id, param);
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((IItemProvider)SCContent.scannerDoorItem);
    }

    public IItemProvider func_199769_a(IBlockState state, World world, BlockPos pos, int fortune) {
        return state.func_177229_b((IProperty)field_176523_O) == DoubleBlockHalf.UPPER ? Items.field_190931_a : SCContent.scannerDoorItem;
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileEntityScannerDoor().activatedByView();
    }
}

