/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import javax.annotation.Nullable;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.tileentity.TileEntitySecretSign;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Fluids;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class BlockSecretSign
extends BlockContainer
implements IBucketPickupHandler,
ILiquidContainer {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public BlockSecretSign() {
        super(Block.Properties.func_200945_a((Material)Material.field_151575_d).func_200947_a(SoundType.field_185848_a).func_200948_a(-1.0f, 6000000.0f));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)placer));
        }
    }

    public IBlockState func_196271_a(IBlockState state, EnumFacing facing, IBlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReaderBase)world));
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public boolean addDestroyEffects(IBlockState state, World world, BlockPos pos, ParticleManager manager) {
        if (world.func_180495_p(pos).func_177230_c() instanceof BlockSecretSign) {
            manager.func_180533_a(pos, Blocks.field_196662_n.func_176223_P());
            return true;
        }
        return false;
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader source, BlockPos pos) {
        return SHAPE;
    }

    @Nullable
    public VoxelShape func_196268_f(IBlockState blockState, IBlockReader world, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    public boolean func_181623_g() {
        return true;
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileEntitySecretSign();
    }

    public IItemProvider func_199769_a(IBlockState state, World worldIn, BlockPos pos, int fortune) {
        return SCContent.secretSignItem;
    }

    public ItemStack func_185473_a(IBlockReader world, BlockPos pos, IBlockState state) {
        return new ItemStack((IItemProvider)SCContent.secretSignItem);
    }

    public boolean func_196250_a(IBlockState state, World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tileentity;
        if (world.field_72995_K) {
            return true;
        }
        if (player.func_184586_b(hand).func_77973_b() == SCContent.adminTool) {
            SCContent.adminTool.func_195939_a(new ItemUseContext(player, player.func_184586_b(hand), pos, facing, hitX, hitY, hitZ));
        }
        return (tileentity = world.func_175625_s(pos)) instanceof TileEntitySecretSign ? ((TileEntitySecretSign)tileentity).func_174882_b(player) : false;
    }

    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public Fluid func_204508_a(IWorld world, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            return Fluids.field_204546_a;
        }
        return Fluids.field_204541_a;
    }

    public IFluidState func_204507_t(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204510_a(IBlockReader world, BlockPos pos, IBlockState state, Fluid fluid) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) == false && fluid == Fluids.field_204546_a;
    }

    public boolean func_204509_a(IWorld world, BlockPos pos, IBlockState state, IFluidState fluidState) {
        if (!((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue() && fluidState.func_206886_c() == Fluids.field_204546_a) {
            if (!world.func_201670_d()) {
                world.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                world.func_205219_F_().func_205360_a(pos, (Object)fluidState.func_206886_c(), fluidState.func_206886_c().func_205569_a((IWorldReaderBase)world));
            }
            return true;
        }
        return false;
    }
}

