/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks;

import java.util.Iterator;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.entity.EntitySecurityCamera;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.tileentity.TileEntitySecurityCamera;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class BlockSecurityCamera
extends BlockContainer {
    public static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", facing -> facing != EnumFacing.UP);
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    private static final VoxelShape SHAPE_SOUTH = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB((double)0.275f, 0.25, 0.0, (double)0.7f, (double)0.8f, (double)0.85f));
    private static final VoxelShape SHAPE_NORTH = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB((double)0.275f, 0.25, (double)0.15f, (double)0.7f, (double)0.8f, 1.0));
    private static final VoxelShape SHAPE_WEST = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.125, 0.25, (double)0.275f, 1.0, (double)0.8f, (double)0.725f));
    private static final VoxelShape SHAPE = VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(0.0, 0.25, (double)0.275f, (double)0.85f, (double)0.8f, (double)0.725f));
    private static final VoxelShape SHAPE_DOWN = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)7.0, (double)15.0, (double)5.0, (double)9.0, (double)16.0, (double)11.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)6.0, (double)15.0, (double)6.0, (double)7.0, (double)16.0, (double)10.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)5.0, (double)15.0, (double)7.0, (double)6.0, (double)16.0, (double)9.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)9.0, (double)15.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)10.0, (double)15.0, (double)7.0, (double)11.0, (double)16.0, (double)9.0), (VoxelShape)Block.func_208617_a((double)7.0, (double)14.0, (double)7.0, (double)9.0, (double)15.0, (double)9.0))))));

    public BlockSecurityCamera(Material material) {
        super(Block.Properties.func_200945_a((Material)material).func_200948_a(-1.0f, 6000000.0f));
        ((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)EnumFacing.NORTH)).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)placer));
        }
    }

    public VoxelShape func_196268_f(IBlockState blockState, IBlockReader access, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return state.func_177229_b((IProperty)FACING) == EnumFacing.DOWN ? EnumBlockRenderType.MODEL : EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_196243_a(IBlockState state, World world, BlockPos pos, IBlockState newState, boolean isMoving) {
        super.func_196243_a(state, world, pos, newState, isMoving);
        world.func_195593_d(pos.func_177978_c(), world.func_180495_p(pos).func_177230_c());
        world.func_195593_d(pos.func_177968_d(), world.func_180495_p(pos).func_177230_c());
        world.func_195593_d(pos.func_177974_f(), world.func_180495_p(pos).func_177230_c());
        world.func_195593_d(pos.func_177976_e(), world.func_180495_p(pos).func_177230_c());
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader source, BlockPos pos) {
        EnumFacing dir = BlockUtils.getBlockPropertyAsEnum(source, pos, FACING);
        if (dir == EnumFacing.SOUTH) {
            return SHAPE_SOUTH;
        }
        if (dir == EnumFacing.NORTH) {
            return SHAPE_NORTH;
        }
        if (dir == EnumFacing.WEST) {
            return SHAPE_WEST;
        }
        if (dir == EnumFacing.DOWN) {
            return SHAPE_DOWN;
        }
        return SHAPE;
    }

    public IBlockState func_196258_a(BlockItemUseContext ctx) {
        return ctx.func_196000_l() != EnumFacing.UP ? this.getStateForPlacement(ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l(), ctx.func_195997_m(), ctx.func_195993_n(), ctx.func_195994_o(), ctx.func_195999_j()) : null;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, EntityPlayer placer) {
        EnumFacing iFacing;
        IBlockState state = (IBlockState)this.func_176223_P().func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
        if (BlockUtils.isSideSolid((IWorldReaderBase)world, pos.func_177972_a(facing.func_176734_d()), facing)) {
            return (IBlockState)((IBlockState)state.func_206870_a((IProperty)FACING, (Comparable)facing)).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
        }
        Iterator iterator = EnumFacing.Plane.HORIZONTAL.iterator();
        do {
            if (iterator.hasNext()) continue;
            return state;
        } while (!BlockUtils.isSideSolid((IWorldReaderBase)world, pos.func_177972_a((iFacing = (EnumFacing)iterator.next()).func_176734_d()), iFacing));
        return (IBlockState)((IBlockState)state.func_206870_a((IProperty)FACING, (Comparable)facing)).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public void mountCamera(World world, int x, int y, int z, int id, EntityPlayer player) {
        if (!world.field_72995_K && player.func_184187_bx() == null) {
            PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize(SCContent.securityCamera.func_149739_a(), new Object[0]), ClientUtils.localize("messages.securitycraft:securityCamera.mounted", new Object[0]), TextFormatting.GREEN);
        }
        if (player.func_184187_bx() != null && player.func_184187_bx() instanceof EntitySecurityCamera) {
            EntitySecurityCamera dummyEntity = new EntitySecurityCamera(world, (double)x, (double)y, (double)z, id, (EntitySecurityCamera)player.func_184187_bx());
            WorldUtils.addScheduledTask((IWorld)world, () -> world.func_72838_d((Entity)dummyEntity));
            player.func_184220_m((Entity)dummyEntity);
            return;
        }
        EntitySecurityCamera dummyEntity = new EntitySecurityCamera(world, (double)x, (double)y, (double)z, id, player);
        WorldUtils.addScheduledTask((IWorld)world, () -> world.func_72838_d((Entity)dummyEntity));
        player.func_184220_m((Entity)dummyEntity);
        for (Object e : world.field_72996_f) {
            if (!(e instanceof EntityLiving) || ((EntityLiving)e).func_70638_az() != player) continue;
            ((EntityLiving)e).func_70624_b(null);
        }
    }

    public boolean func_196260_a(IBlockState state, IWorldReaderBase world, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        BlockPos placeOnPos = pos.func_177972_a(facing.func_176734_d());
        IBlockState placeOnState = world.func_180495_p(placeOnPos);
        return BlockUtils.isSideSolid(world, pos.func_177972_a(facing.func_176734_d()), facing) && !BlockSecurityCamera.func_193382_c((Block)placeOnState.func_177230_c());
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockReader blockAccess, BlockPos pos, EnumFacing side) {
        if (((Boolean)blockState.func_177229_b((IProperty)POWERED)).booleanValue() && ((CustomizableSCTE)blockAccess.func_175625_s(pos)).hasModule(EnumCustomModules.REDSTONE)) {
            return 15;
        }
        return 0;
    }

    public int func_176211_b(IBlockState blockState, IBlockReader blockAccess, BlockPos pos, EnumFacing side) {
        if (((Boolean)blockState.func_177229_b((IProperty)POWERED)).booleanValue() && ((CustomizableSCTE)blockAccess.func_175625_s(pos)).hasModule(EnumCustomModules.REDSTONE)) {
            return 15;
        }
        return 0;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!this.func_196260_a(world.func_180495_p(pos), (IWorldReaderBase)world, pos) && !this.func_196260_a(state, (IWorldReaderBase)world, pos)) {
            this.func_196255_a(state, world, pos, 1.0f, 0);
            world.func_175698_g(pos);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
        builder.func_206894_a(new IProperty[]{POWERED});
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileEntitySecurityCamera().nameable();
    }
}

