/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.api.IIntersectable;
import net.geforcemods.securitycraft.blocks.mines.BlockExplosive;
import net.geforcemods.securitycraft.entity.EntityBouncingBetty;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockBouncingBetty
extends BlockExplosive
implements IIntersectable {
    public static final BooleanProperty DEACTIVATED = BooleanProperty.func_177716_a((String)"deactivated");
    private static final VoxelShape SHAPE = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)3.0, (double)13.0);

    public BlockBouncingBetty(Material material, float baseHardness) {
        super(SoundType.field_185851_d, material, baseHardness);
        this.func_180632_j((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader source, BlockPos pos) {
        return SHAPE;
    }

    public boolean func_196260_a(IBlockState state, IWorldReaderBase world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_185896_q();
    }

    @Override
    public void onEntityIntersected(World world, BlockPos pos, Entity entity) {
        if (entity instanceof EntityLivingBase && !PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)entity)) {
            this.explode(world, pos);
        }
    }

    public void func_196270_a(IBlockState state, World world, BlockPos pos, EntityPlayer player) {
        if (!player.func_184812_l_()) {
            this.explode(world, pos);
        }
    }

    @Override
    public void activateMine(World world, BlockPos pos) {
        BlockUtils.setBlockProperty(world, pos, DEACTIVATED, false);
    }

    @Override
    public void defuseMine(World world, BlockPos pos) {
        BlockUtils.setBlockProperty(world, pos, DEACTIVATED, true);
    }

    @Override
    public void explode(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        if (BlockUtils.getBlockPropertyAsBoolean(world, pos, DEACTIVATED)) {
            return;
        }
        world.func_175698_g(pos);
        EntityBouncingBetty entitytntprimed = new EntityBouncingBetty(world, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f);
        entitytntprimed.fuse = 15;
        entitytntprimed.field_70181_x = 0.5;
        WorldUtils.addScheduledTask((IWorld)world, () -> world.func_72838_d((Entity)entitytntprimed));
        entitytntprimed.func_184185_a((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("game.tnt.primed")), 1.0f, 1.0f);
    }

    public IItemProvider func_199769_a(IBlockState state, World world, BlockPos pos, int fortune) {
        return this.func_199767_j();
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((IItemProvider)this.func_199767_j());
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{DEACTIVATED});
    }

    @Override
    public boolean isActive(World world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)DEACTIVATED) == false;
    }

    @Override
    public boolean isDefusable() {
        return true;
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileEntityOwnable().intersectsEntities();
    }
}

