/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.tileentity.TileEntityClaymore;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Items;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class BlockClaymore
extends BlockContainer
implements IExplosive {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty DEACTIVATED = BooleanProperty.func_177716_a((String)"deactivated");
    private static final VoxelShape NORTH_OFF = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)4.0, (double)7.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)4.0, (double)4.0, (double)5.0, (double)12.0, (double)5.0, (double)6.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)5.0, (double)4.0, (double)4.0, (double)6.0, (double)5.0, (double)5.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)10.0, (double)4.0, (double)4.0, (double)11.0, (double)5.0, (double)5.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)4.0, (double)4.0, (double)3.0, (double)5.0, (double)5.0, (double)4.0), (VoxelShape)Block.func_208617_a((double)11.0, (double)4.0, (double)3.0, (double)12.0, (double)5.0, (double)4.0))))));
    private static final VoxelShape NORTH_ON = VoxelShapes.func_197872_a((VoxelShape)NORTH_OFF, (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)3.0, (double)4.0, (double)2.0, (double)4.0, (double)5.0, (double)3.0), (VoxelShape)Block.func_208617_a((double)12.0, (double)4.0, (double)2.0, (double)13.0, (double)5.0, (double)3.0)));
    private static final VoxelShape EAST_OFF = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)9.0, (double)0.0, (double)4.0, (double)11.0, (double)4.0, (double)12.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)10.0, (double)4.0, (double)4.0, (double)11.0, (double)5.0, (double)12.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)11.0, (double)4.0, (double)5.0, (double)12.0, (double)5.0, (double)6.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)11.0, (double)4.0, (double)10.0, (double)12.0, (double)5.0, (double)11.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)12.0, (double)4.0, (double)4.0, (double)13.0, (double)5.0, (double)5.0), (VoxelShape)Block.func_208617_a((double)12.0, (double)4.0, (double)11.0, (double)13.0, (double)5.0, (double)12.0))))));
    private static final VoxelShape EAST_ON = VoxelShapes.func_197872_a((VoxelShape)EAST_OFF, (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)13.0, (double)4.0, (double)3.0, (double)14.0, (double)5.0, (double)4.0), (VoxelShape)Block.func_208617_a((double)13.0, (double)4.0, (double)12.0, (double)14.0, (double)5.0, (double)13.0)));
    private static final VoxelShape SOUTH_OFF = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)4.0, (double)0.0, (double)9.0, (double)12.0, (double)4.0, (double)11.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)4.0, (double)4.0, (double)10.0, (double)12.0, (double)5.0, (double)11.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)5.0, (double)4.0, (double)11.0, (double)6.0, (double)5.0, (double)12.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)10.0, (double)4.0, (double)11.0, (double)11.0, (double)5.0, (double)12.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)4.0, (double)4.0, (double)12.0, (double)5.0, (double)5.0, (double)13.0), (VoxelShape)Block.func_208617_a((double)11.0, (double)4.0, (double)12.0, (double)12.0, (double)5.0, (double)13.0))))));
    private static final VoxelShape SOUTH_ON = VoxelShapes.func_197872_a((VoxelShape)SOUTH_OFF, (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)3.0, (double)4.0, (double)13.0, (double)4.0, (double)5.0, (double)14.0), (VoxelShape)Block.func_208617_a((double)12.0, (double)4.0, (double)13.0, (double)13.0, (double)5.0, (double)14.0)));
    private static final VoxelShape WEST_OFF = VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)7.0, (double)0.0, (double)4.0, (double)5.0, (double)4.0, (double)12.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)6.0, (double)4.0, (double)4.0, (double)5.0, (double)5.0, (double)12.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)5.0, (double)4.0, (double)5.0, (double)4.0, (double)5.0, (double)6.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)5.0, (double)4.0, (double)10.0, (double)4.0, (double)5.0, (double)11.0), (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)3.0, (double)5.0, (double)5.0), (VoxelShape)Block.func_208617_a((double)4.0, (double)4.0, (double)11.0, (double)3.0, (double)5.0, (double)12.0))))));
    private static final VoxelShape WEST_ON = VoxelShapes.func_197872_a((VoxelShape)WEST_OFF, (VoxelShape)VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)3.0, (double)4.0, (double)3.0, (double)2.0, (double)5.0, (double)4.0), (VoxelShape)Block.func_208617_a((double)3.0, (double)4.0, (double)12.0, (double)2.0, (double)5.0, (double)13.0)));

    public BlockClaymore(Material material) {
        super(Block.Properties.func_200945_a((Material)material).func_200948_a(1.0f, 6000000.0f));
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)EnumFacing.NORTH)).func_206870_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)placer));
        }
    }

    public float func_176195_g(IBlockState blockState, IBlockReader world, BlockPos pos) {
        return (Boolean)ConfigHandler.CommonConfig.CONFIG.ableToBreakMines.get() == false ? -1.0f : super.func_176195_g(blockState, world, pos);
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public VoxelShape func_196268_f(IBlockState blockState, IBlockReader access, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public boolean func_196260_a(IBlockState state, IWorldReaderBase world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_185896_q();
    }

    public boolean func_196250_a(IBlockState state, World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (!player.field_71071_by.func_70448_g().func_190926_b() && player.field_71071_by.func_70448_g().func_77973_b() == SCContent.wireCutters) {
                world.func_175656_a(pos, (IBlockState)((IBlockState)SCContent.claymore.func_176223_P().func_206870_a((IProperty)FACING, state.func_177229_b((IProperty)FACING))).func_206870_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(true)));
                return true;
            }
            if (!player.field_71071_by.func_70448_g().func_190926_b() && player.field_71071_by.func_70448_g().func_77973_b() == Items.field_151033_d) {
                world.func_175656_a(pos, (IBlockState)((IBlockState)SCContent.claymore.func_176223_P().func_206870_a((IProperty)FACING, state.func_177229_b((IProperty)FACING))).func_206870_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
                return true;
            }
        }
        return false;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest, IFluidState fluid) {
        if (!(player.func_184812_l_() || world.field_72995_K || ((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)DEACTIVATED)).booleanValue())) {
            BlockUtils.destroyBlock(world, pos, false);
            world.func_72876_a((Entity)null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 3.5f, true);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
        if (!world.field_72995_K && BlockUtils.hasBlockProperty(world, pos, DEACTIVATED) && !((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)DEACTIVATED)).booleanValue()) {
            if (pos.equals((Object)new BlockPos(explosion.getPosition()))) {
                return;
            }
            BlockUtils.destroyBlock(world, pos, false);
            world.func_72876_a((Entity)null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 3.5f, true);
        }
    }

    public IBlockState func_196258_a(BlockItemUseContext ctx) {
        return this.getStateForPlacement(ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l(), ctx.func_195997_m(), ctx.func_195993_n(), ctx.func_195994_o(), ctx.func_195999_j());
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, EntityPlayer placer) {
        return (IBlockState)((IBlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)placer.func_174811_aO())).func_206870_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public void activateMine(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            BlockUtils.setBlockProperty(world, pos, DEACTIVATED, false);
        }
    }

    @Override
    public void defuseMine(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            BlockUtils.setBlockProperty(world, pos, DEACTIVATED, true);
        }
    }

    @Override
    public void explode(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            BlockUtils.destroyBlock(world, pos, false);
            world.func_72876_a((Entity)null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 3.5f, true);
        }
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case NORTH: {
                if (((Boolean)state.func_177229_b((IProperty)DEACTIVATED)).booleanValue()) {
                    return NORTH_OFF;
                }
                return NORTH_ON;
            }
            case EAST: {
                if (((Boolean)state.func_177229_b((IProperty)DEACTIVATED)).booleanValue()) {
                    return EAST_OFF;
                }
                return EAST_ON;
            }
            case SOUTH: {
                if (((Boolean)state.func_177229_b((IProperty)DEACTIVATED)).booleanValue()) {
                    return SOUTH_OFF;
                }
                return SOUTH_ON;
            }
            case WEST: {
                if (((Boolean)state.func_177229_b((IProperty)DEACTIVATED)).booleanValue()) {
                    return WEST_OFF;
                }
                return WEST_ON;
            }
        }
        return VoxelShapes.func_197868_b();
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
        builder.func_206894_a(new IProperty[]{DEACTIVATED});
    }

    @Override
    public boolean isActive(World world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)DEACTIVATED) == false;
    }

    @Override
    public boolean isDefusable() {
        return true;
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileEntityClaymore();
    }
}

