/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.blocks.BlockOwnable;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public abstract class BlockExplosive
extends BlockOwnable
implements IExplosive {
    public BlockExplosive(SoundType soundType, Material material, float baseHardness) {
        super(Block.Properties.func_200945_a((Material)material).func_200947_a(soundType).func_200948_a(baseHardness, 6000000.0f));
    }

    public float func_176195_g(IBlockState blockState, IBlockReader world, BlockPos pos) {
        return (Boolean)ConfigHandler.CommonConfig.CONFIG.ableToBreakMines.get() == false ? -1.0f : super.func_176195_g(blockState, world, pos);
    }

    public boolean func_196250_a(IBlockState state, World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (player.field_71071_by.func_70448_g().func_190926_b() && this.explodesWhenInteractedWith() && this.isActive(world, pos)) {
                this.explode(world, pos);
                return false;
            }
            if (PlayerUtils.isHoldingItem(player, SCContent.remoteAccessMine)) {
                return false;
            }
            if (this.isActive(world, pos) && this.isDefusable() && PlayerUtils.isHoldingItem(player, SCContent.wireCutters)) {
                this.defuseMine(world, pos);
                player.field_71071_by.func_70448_g().func_77972_a(1, (EntityLivingBase)player);
                return false;
            }
            if (!this.isActive(world, pos) && PlayerUtils.isHoldingItem(player, Items.field_151033_d)) {
                this.activateMine(world, pos);
                return false;
            }
            if (this.explodesWhenInteractedWith() && this.isActive(world, pos)) {
                this.explode(world, pos);
            }
            return false;
        }
        return false;
    }

    public boolean explodesWhenInteractedWith() {
        return true;
    }

    @Override
    public abstract void explode(World var1, BlockPos var2);

    @Override
    public boolean isDefusable() {
        return true;
    }
}

