/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.api.IIntersectable;
import net.geforcemods.securitycraft.blocks.mines.BlockExplosive;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BlockFullMineBase
extends BlockExplosive
implements IIntersectable,
IOverlayDisplay {
    private final Block blockDisguisedAs;

    public BlockFullMineBase(Material material, Block disguisedBlock, float baseHardness) {
        super(material == Material.field_151595_p ? SoundType.field_185855_h : (material == Material.field_151578_c ? SoundType.field_185849_b : SoundType.field_185851_d), material, baseHardness);
        this.blockDisguisedAs = disguisedBlock;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public VoxelShape func_196268_f(IBlockState blockState, IBlockReader access, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    @Override
    public void onEntityIntersected(World world, BlockPos pos, Entity entity) {
        if (entity instanceof EntityItem) {
            return;
        }
        if (entity instanceof EntityLivingBase && !PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)entity)) {
            this.explode(world, pos);
        }
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
        if (!world.field_72995_K) {
            if (pos.equals((Object)new BlockPos(explosion.getPosition()))) {
                return;
            }
            this.explode(world, pos);
        }
    }

    public void func_176206_d(IWorld world, BlockPos pos, IBlockState state) {
        if (!world.func_201670_d() && world instanceof World) {
            this.explode((World)world, pos);
        }
    }

    @Override
    public void activateMine(World world, BlockPos pos) {
    }

    @Override
    public void defuseMine(World world, BlockPos pos) {
    }

    @Override
    public void explode(World world, BlockPos pos) {
        world.func_175655_b(pos, false);
        if (((Boolean)ConfigHandler.CommonConfig.CONFIG.smallerMineExplosion.get()).booleanValue()) {
            world.func_72876_a((Entity)null, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p(), 2.5f, true);
        } else {
            world.func_72876_a((Entity)null, (double)pos.func_177958_n(), (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p(), 5.0f, true);
        }
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }

    @Override
    public boolean isActive(World world, BlockPos pos) {
        return true;
    }

    @Override
    public boolean explodesWhenInteractedWith() {
        return false;
    }

    @Override
    public boolean isDefusable() {
        return false;
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileEntityOwnable().intersectsEntities();
    }

    @Override
    public ItemStack getDisplayStack(World world, IBlockState state, BlockPos pos) {
        return new ItemStack((IItemProvider)this.blockDisguisedAs);
    }

    @Override
    public boolean shouldShowSCInfo(World world, IBlockState state, BlockPos pos) {
        return false;
    }
}

