/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import java.util.Random;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blocks.mines.BlockFullMineBase;
import net.geforcemods.securitycraft.entity.EntityFallingOwnableBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Particles;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockFullMineFalling
extends BlockFullMineBase {
    public static boolean fallInstantly;

    public BlockFullMineFalling(Material material, Block disguisedBlock, float baseHardness) {
        super(material, disguisedBlock, baseHardness);
    }

    public void func_196259_b(IBlockState state, World world, BlockPos pos, IBlockState oldState) {
        world.func_205220_G_().func_205360_a(pos, (Object)this, this.tickRate(world));
    }

    public IBlockState func_196271_a(IBlockState state, EnumFacing facing, IBlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        world.func_205220_G_().func_205360_a(currentPos, (Object)this, this.func_149738_a((IWorldReaderBase)world));
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public void func_196267_b(IBlockState state, World world, BlockPos pos, Random random) {
        if (!world.field_72995_K && (world.func_175623_d(pos.func_177977_b()) || BlockFullMineFalling.canFallThrough(world.func_180495_p(pos.func_177977_b()))) && pos.func_177956_o() >= 0) {
            if (!fallInstantly && world.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32))) {
                if (!world.field_72995_K && world.func_175625_s(pos) instanceof IOwnable) {
                    world.func_72838_d((Entity)new EntityFallingOwnableBlock(world, (double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, world.func_180495_p(pos), ((IOwnable)world.func_175625_s(pos)).getOwner()));
                }
            } else {
                world.func_175698_g(pos);
                BlockPos blockpos = pos.func_177977_b();
                while ((world.func_175623_d(blockpos) || BlockFullMineFalling.canFallThrough(world.func_180495_p(blockpos))) && blockpos.func_177956_o() > 0) {
                    blockpos = blockpos.func_177977_b();
                }
                if (blockpos.func_177956_o() > 0) {
                    world.func_175656_a(blockpos.func_177984_a(), state);
                }
            }
        }
    }

    public int tickRate(World world) {
        return 2;
    }

    public static boolean canFallThrough(IBlockState state) {
        Block block = state.func_177230_c();
        Material material = state.func_185904_a();
        return block == Blocks.field_150480_ab || material == Material.field_151579_a || material == Material.field_151586_h || material == Material.field_151587_i;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (rand.nextInt(16) == 0 && BlockFullMineFalling.canFallThrough(world.func_180495_p(pos.func_177977_b()))) {
            double particleX = (float)pos.func_177958_n() + rand.nextFloat();
            double particleY = (double)pos.func_177956_o() - 0.05;
            double particleZ = (float)pos.func_177952_p() + rand.nextFloat();
            world.func_195590_a((IParticleData)new BlockParticleData(Particles.field_197628_u, state), false, particleX, particleY, particleZ, 0.0, 0.0, 0.0);
        }
    }
}

