/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import java.util.Random;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blocks.BlockOwnable;
import net.geforcemods.securitycraft.gui.GuiHandler;
import net.geforcemods.securitycraft.misc.BaseInteractionObject;
import net.geforcemods.securitycraft.tileentity.TileEntityIMS;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Particles;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class BlockIMS
extends BlockOwnable {
    public static final IntegerProperty MINES = IntegerProperty.func_177719_a((String)"mines", (int)0, (int)4);
    private static final VoxelShape SHAPE = Block.func_208617_a((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)7.0, (double)11.0);
    private static final VoxelShape SHAPE_1_MINE = VoxelShapes.func_197872_a((VoxelShape)SHAPE, (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)5.0, (double)5.0));
    private static final VoxelShape SHAPE_2_MINES = VoxelShapes.func_197872_a((VoxelShape)SHAPE_1_MINE, (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)11.0, (double)5.0, (double)5.0, (double)16.0));
    private static final VoxelShape SHAPE_3_MINES = VoxelShapes.func_197872_a((VoxelShape)SHAPE_2_MINES, (VoxelShape)Block.func_208617_a((double)11.0, (double)0.0, (double)0.0, (double)16.0, (double)5.0, (double)5.0));
    private static final VoxelShape SHAPE_4_MINES = VoxelShapes.func_197872_a((VoxelShape)SHAPE_3_MINES, (VoxelShape)Block.func_208617_a((double)11.0, (double)0.0, (double)11.0, (double)16.0, (double)5.0, (double)16.0));

    public BlockIMS(Material material) {
        super(SoundType.field_185852_e, Block.Properties.func_200945_a((Material)material).func_200948_a(0.7f, 6000000.0f));
        this.func_180632_j((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)MINES, (Comparable)Integer.valueOf(4)));
    }

    public float func_176195_g(IBlockState blockState, IBlockReader world, BlockPos pos) {
        return (Boolean)ConfigHandler.CommonConfig.CONFIG.ableToBreakMines.get() == false ? -1.0f : super.func_176195_g(blockState, world, pos);
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader source, BlockPos pos) {
        switch ((Integer)state.func_177229_b((IProperty)MINES)) {
            case 4: {
                return SHAPE_4_MINES;
            }
            case 3: {
                return SHAPE_3_MINES;
            }
            case 2: {
                return SHAPE_2_MINES;
            }
            case 1: {
                return SHAPE_1_MINE;
            }
        }
        return SHAPE;
    }

    public boolean func_196250_a(IBlockState state, World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && ((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(player)) {
            ItemStack held = player.func_184586_b(hand);
            int mines = (Integer)state.func_177229_b((IProperty)MINES);
            if (held.func_77973_b() == SCContent.bouncingBetty.func_199767_j() && mines < 4) {
                if (!player.func_184812_l_()) {
                    held.func_190918_g(1);
                }
                world.func_175656_a(pos, (IBlockState)state.func_206870_a((IProperty)MINES, (Comparable)Integer.valueOf(mines + 1)));
                ((TileEntityIMS)world.func_175625_s(pos)).setBombsRemaining(mines + 1);
            } else if (player instanceof EntityPlayerMP) {
                NetworkHooks.openGui((EntityPlayerMP)((EntityPlayerMP)player), (IInteractionObject)new BaseInteractionObject(GuiHandler.IMS), (BlockPos)pos);
            }
            return true;
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random random) {
        if ((Integer)state.func_177229_b((IProperty)MINES) == 0) {
            double x = (double)((float)pos.func_177958_n() + 0.5f) + (double)(random.nextFloat() - 0.5f) * 0.2;
            double y = (double)((float)pos.func_177956_o() + 0.4f) + (double)(random.nextFloat() - 0.5f) * 0.2;
            double z = (double)((float)pos.func_177952_p() + 0.5f) + (double)(random.nextFloat() - 0.5f) * 0.2;
            double magicNumber1 = 0.22f;
            double magicNumber2 = 0.27f;
            world.func_195590_a((IParticleData)Particles.field_197601_L, false, x - magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)Particles.field_197601_L, false, x + magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)Particles.field_197601_L, false, x, y + magicNumber1, z - magicNumber2, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)Particles.field_197601_L, false, x, y + magicNumber1, z + magicNumber2, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)Particles.field_197601_L, false, x, y, z, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)Particles.field_197631_x, false, x - magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
            world.func_195590_a((IParticleData)Particles.field_197631_x, false, x + magicNumber2, y + magicNumber1, z, 0.0, 0.0, 0.0);
        }
    }

    public void getDrops(IBlockState state, NonNullList<ItemStack> drops, World world, BlockPos pos, int fortune) {
        int mines = (Integer)state.func_177229_b((IProperty)MINES);
        if (mines != 0) {
            drops.add((Object)new ItemStack((IItemProvider)SCContent.bouncingBetty, mines));
        }
    }

    public IBlockState func_196258_a(BlockItemUseContext ctx) {
        return this.getStateForPlacement(ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_196000_l(), ctx.func_195997_m(), ctx.func_195993_n(), ctx.func_195994_o(), ctx.func_195999_j());
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, EntityPlayer placer) {
        return (IBlockState)this.func_176223_P().func_206870_a((IProperty)MINES, (Comparable)Integer.valueOf(4));
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{MINES});
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileEntityIMS();
    }
}

