/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blocks.mines.BlockExplosive;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;

public class BlockMine
extends BlockExplosive {
    public static final BooleanProperty DEACTIVATED = BooleanProperty.func_177716_a((String)"deactivated");
    private static final VoxelShape SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0);

    public BlockMine(Material material, float baseHardness) {
        super(SoundType.field_185851_d, material, baseHardness);
        this.func_180632_j((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)DEACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    @Override
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (world.func_180495_p(pos.func_177977_b()).func_185904_a() != Material.field_151579_a) {
            return;
        }
        this.explode(world, pos);
    }

    public boolean func_196260_a(IBlockState state, IWorldReaderBase world, BlockPos pos) {
        return BlockUtils.getBlockMaterial(world, pos.func_177977_b()) != Material.field_151592_s && BlockUtils.getBlockMaterial(world, pos.func_177977_b()) != Material.field_151570_A && BlockUtils.getBlockMaterial(world, pos.func_177977_b()) != Material.field_151579_a && BlockUtils.getBlockMaterial(world, pos.func_177977_b()) != Material.field_151568_F && BlockUtils.getBlockMaterial(world, pos.func_177977_b()) != Material.field_151585_k;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest, IFluidState fluid) {
        if (!player.func_184812_l_() && !world.field_72995_K) {
            if (player != null && player.func_184812_l_() && !((Boolean)ConfigHandler.CommonConfig.CONFIG.mineExplodesWhenInCreative.get()).booleanValue()) {
                return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
            }
            this.explode(world, pos);
            return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader source, BlockPos pos) {
        return SHAPE;
    }

    public void func_196262_a(IBlockState state, World world, BlockPos pos, Entity entity) {
        if (world.field_72995_K) {
            return;
        }
        if (entity instanceof EntityCreeper || entity instanceof EntityOcelot || entity instanceof EntityEnderman || entity instanceof EntityItem) {
            return;
        }
        if (entity instanceof EntityLivingBase && !PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)entity)) {
            this.explode(world, pos);
        }
    }

    @Override
    public void activateMine(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            BlockUtils.setBlockProperty(world, pos, DEACTIVATED, false);
        }
    }

    @Override
    public void defuseMine(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            BlockUtils.setBlockProperty(world, pos, DEACTIVATED, true);
        }
    }

    @Override
    public void explode(World world, BlockPos pos) {
        if (world.field_72995_K) {
            return;
        }
        if (!((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)DEACTIVATED)).booleanValue()) {
            world.func_175655_b(pos, false);
            if (((Boolean)ConfigHandler.CommonConfig.CONFIG.smallerMineExplosion.get()).booleanValue()) {
                world.func_72876_a((Entity)null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 1.0f, true);
            } else {
                world.func_72876_a((Entity)null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 3.0f, true);
            }
        }
    }

    public IItemProvider func_199769_a(IBlockState state, World worldIn, BlockPos pos, int fortune) {
        return SCContent.mine.func_199767_j();
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((IItemProvider)SCContent.mine.func_199767_j());
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{DEACTIVATED});
    }

    @Override
    public boolean isActive(World world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)DEACTIVATED) == false;
    }

    @Override
    public boolean isDefusable() {
        return true;
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileEntityOwnable();
    }
}

