/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.mines;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.tileentity.TileEntityTrackMine;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRail;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class BlockTrackMine
extends BlockRail
implements IExplosive,
ITileEntityProvider {
    public BlockTrackMine() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(0.7f, 6000000.0f).func_200942_a().func_200947_a(SoundType.field_185852_e));
    }

    public float func_176195_g(IBlockState blockState, IBlockReader world, BlockPos pos) {
        return (Boolean)ConfigHandler.CommonConfig.CONFIG.ableToBreakMines.get() == false ? -1.0f : super.func_176195_g(blockState, world, pos);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)placer));
        }
    }

    public void onMinecartPass(IBlockState state, World world, BlockPos pos, EntityMinecart cart) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityTrackMine && ((TileEntityTrackMine)te).isActive()) {
            BlockUtils.destroyBlock(world, pos, false);
            world.func_72876_a((Entity)cart, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (Boolean)ConfigHandler.CommonConfig.CONFIG.smallerMineExplosion.get() != false ? 4.0f : 8.0f, true);
            cart.func_70106_y();
        }
    }

    public void func_196243_a(IBlockState state, World world, BlockPos pos, IBlockState newState, boolean isMoving) {
        super.func_196243_a(state, world, pos, newState, isMoving);
        world.func_175713_t(pos);
    }

    @Override
    public void explode(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityTrackMine && ((TileEntityTrackMine)te).isActive()) {
            BlockUtils.destroyBlock(world, pos, false);
            world.func_72876_a((Entity)null, (double)pos.func_177958_n(), (double)pos.func_177984_a().func_177956_o(), (double)pos.func_177952_p(), (Boolean)ConfigHandler.CommonConfig.CONFIG.smallerMineExplosion.get() != false ? 4.0f : 8.0f, true);
        }
    }

    @Override
    public void activateMine(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityTrackMine && !((TileEntityTrackMine)te).isActive()) {
            ((TileEntityTrackMine)te).activate();
        }
    }

    @Override
    public void defuseMine(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityTrackMine && ((TileEntityTrackMine)te).isActive()) {
            ((TileEntityTrackMine)te).deactivate();
        }
    }

    @Override
    public boolean isActive(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof TileEntityTrackMine && ((TileEntityTrackMine)te).isActive() && ((TileEntityTrackMine)te).isActive();
    }

    @Override
    public boolean isDefusable() {
        return true;
    }

    public TileEntity func_196283_a_(IBlockReader reader) {
        return new TileEntityTrackMine();
    }
}

