/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class BlockReinforcedDoor
extends Block
implements ITileEntityProvider {
    public static final DirectionProperty FACING = BlockHorizontal.field_185512_D;
    public static final BooleanProperty OPEN = BlockStateProperties.field_208193_t;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.field_208142_aq;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.field_208163_P;
    protected static final VoxelShape SOUTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.func_208617_a((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);

    public BlockReinforcedDoor(Material material) {
        super(Block.Properties.func_200945_a((Material)material).func_200948_a(-1.0f, 6000000.0f).func_200947_a(SoundType.field_185852_e));
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)EnumFacing.NORTH)).func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false))).func_206870_a(HINGE, (Comparable)DoorHingeSide.LEFT)).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        boolean flag = (Boolean)state.func_177229_b((IProperty)OPEN) == false;
        boolean flag1 = state.func_177229_b(HINGE) == DoorHingeSide.RIGHT;
        switch (enumfacing) {
            default: {
                return flag ? EAST_AABB : (flag1 ? NORTH_AABB : SOUTH_AABB);
            }
            case SOUTH: {
                return flag ? SOUTH_AABB : (flag1 ? EAST_AABB : WEST_AABB);
            }
            case WEST: {
                return flag ? WEST_AABB : (flag1 ? SOUTH_AABB : NORTH_AABB);
            }
            case NORTH: 
        }
        return flag ? NORTH_AABB : (flag1 ? WEST_AABB : EAST_AABB);
    }

    public IBlockState func_196271_a(IBlockState stateIn, EnumFacing facing, IBlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)stateIn.func_177229_b(HALF);
        if (facing.func_176740_k() == EnumFacing.Axis.Y && doubleblockhalf == DoubleBlockHalf.LOWER == (facing == EnumFacing.UP)) {
            return facingState.func_177230_c() == this && facingState.func_177229_b(HALF) != doubleblockhalf ? (IBlockState)((IBlockState)((IBlockState)stateIn.func_206870_a((IProperty)FACING, facingState.func_177229_b((IProperty)FACING))).func_206870_a((IProperty)OPEN, facingState.func_177229_b((IProperty)OPEN))).func_206870_a(HINGE, facingState.func_177229_b(HINGE)) : Blocks.field_150350_a.func_176223_P();
        }
        return doubleblockhalf == DoubleBlockHalf.LOWER && facing == EnumFacing.DOWN && !stateIn.func_196955_c((IWorldReaderBase)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)state.func_177229_b(HALF);
        boolean flag = doubleblockhalf == DoubleBlockHalf.LOWER;
        BlockPos blockpos = flag ? pos.func_177984_a() : pos.func_177977_b();
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        if (iblockstate.func_177230_c() == this && iblockstate.func_177229_b(HALF) != doubleblockhalf) {
            worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            worldIn.func_180498_a(player, 2001, blockpos, Block.func_196246_j((IBlockState)iblockstate));
            if (!worldIn.field_72995_K && !player.func_184812_l_()) {
                if (flag) {
                    state.func_196949_c(worldIn, pos, 0);
                } else {
                    iblockstate.func_196949_c(worldIn, blockpos, 0);
                }
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public boolean func_196266_a(IBlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return (Boolean)state.func_177229_b((IProperty)OPEN);
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return (Boolean)state.func_177229_b((IProperty)OPEN);
            }
        }
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    private int getCloseSound() {
        return this.field_149764_J == Material.field_151573_f ? 1011 : 1012;
    }

    private int getOpenSound() {
        return this.field_149764_J == Material.field_151573_f ? 1005 : 1006;
    }

    public IBlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        if (blockpos.func_177956_o() < 255 && context.func_195991_k().func_180495_p(blockpos.func_177984_a()).func_196953_a(context)) {
            World world = context.func_195991_k();
            boolean flag = world.func_175640_z(blockpos) || world.func_175640_z(blockpos.func_177984_a());
            return (IBlockState)((IBlockState)((IBlockState)((IBlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f())).func_206870_a(HINGE, (Comparable)this.getHingeSide(context))).func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(flag))).func_206870_a(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    private DoorHingeSide getHingeSide(BlockItemUseContext p_208073_1_) {
        boolean flag1;
        World iblockreader = p_208073_1_.func_195991_k();
        BlockPos blockpos = p_208073_1_.func_195995_a();
        EnumFacing enumfacing = p_208073_1_.func_195992_f();
        BlockPos blockpos1 = blockpos.func_177984_a();
        EnumFacing enumfacing1 = enumfacing.func_176735_f();
        IBlockState iblockstate = iblockreader.func_180495_p(blockpos.func_177972_a(enumfacing1));
        IBlockState iblockstate1 = iblockreader.func_180495_p(blockpos1.func_177972_a(enumfacing1));
        EnumFacing enumfacing2 = enumfacing.func_176746_e();
        IBlockState iblockstate2 = iblockreader.func_180495_p(blockpos.func_177972_a(enumfacing2));
        IBlockState iblockstate3 = iblockreader.func_180495_p(blockpos1.func_177972_a(enumfacing2));
        int i = (iblockstate.func_185898_k() ? -1 : 0) + (iblockstate1.func_185898_k() ? -1 : 0) + (iblockstate2.func_185898_k() ? 1 : 0) + (iblockstate3.func_185898_k() ? 1 : 0);
        boolean flag = iblockstate.func_177230_c() == this && iblockstate.func_177229_b(HALF) == DoubleBlockHalf.LOWER;
        boolean bl = flag1 = iblockstate2.func_177230_c() == this && iblockstate2.func_177229_b(HALF) == DoubleBlockHalf.LOWER;
        if ((!flag || flag1) && i <= 0) {
            if ((!flag1 || flag) && i >= 0) {
                int j = enumfacing.func_82601_c();
                int k = enumfacing.func_82599_e();
                float f = p_208073_1_.func_195997_m();
                float f1 = p_208073_1_.func_195994_o();
                return !(j < 0 && f1 < 0.5f || j > 0 && f1 > 0.5f || k < 0 && f > 0.5f || k > 0 && f < 0.5f) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    public void toggleDoor(World worldIn, BlockPos pos, boolean open) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        if (iblockstate.func_177230_c() == this && (Boolean)iblockstate.func_177229_b((IProperty)OPEN) != open) {
            worldIn.func_180501_a(pos, (IBlockState)iblockstate.func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(open)), 10);
            this.playSound(worldIn, pos, open);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        this.onNeighborChanged(world, pos, fromPos);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)placer));
        }
        world.func_180501_a(pos.func_177984_a(), (IBlockState)state.func_206870_a(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    public void onNeighborChanged(World world, BlockPos pos, BlockPos neighbor) {
        IBlockState state = world.func_180495_p(pos);
        Block neighborBlock = world.func_180495_p(neighbor).func_177230_c();
        Owner previousOwner = null;
        if (world.func_175625_s(pos) instanceof TileEntityOwnable) {
            previousOwner = ((TileEntityOwnable)world.func_175625_s(pos)).getOwner();
        }
        if (state.func_177229_b(HALF) == DoubleBlockHalf.UPPER) {
            BlockPos blockBelow = pos.func_177977_b();
            IBlockState stateBelow = world.func_180495_p(blockBelow);
            if (stateBelow.func_177230_c() != this) {
                world.func_175698_g(pos);
            } else if (neighborBlock != this) {
                this.onNeighborChanged(world, blockBelow, neighbor);
            }
        } else {
            boolean drop = false;
            BlockPos blockAbove = pos.func_177984_a();
            IBlockState stateAbove = world.func_180495_p(blockAbove);
            if (stateAbove.func_177230_c() != this) {
                world.func_175698_g(pos);
                drop = true;
            }
            if (!world.func_195595_w(pos.func_177977_b())) {
                world.func_175698_g(pos);
                drop = true;
                if (stateAbove.func_177230_c() == this) {
                    world.func_175698_g(blockAbove);
                }
            }
            if (drop) {
                if (!world.field_72995_K) {
                    this.func_196255_a(state, world, pos, 1.0f, 0);
                }
            } else {
                boolean hasActiveSCBlock;
                boolean bl = hasActiveSCBlock = BlockUtils.hasActiveSCBlockNextTo(world, pos) || BlockUtils.hasActiveSCBlockNextTo(world, pos.func_177984_a());
                if ((hasActiveSCBlock || neighborBlock.func_149744_f(stateAbove)) && neighborBlock != this && hasActiveSCBlock != (Boolean)stateAbove.func_177229_b((IProperty)OPEN) && hasActiveSCBlock != (Boolean)state.func_177229_b((IProperty)OPEN)) {
                    world.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                    world.func_175704_b(pos, pos);
                    if (state.func_177229_b((IProperty)FACING) == EnumFacing.WEST) {
                        IBlockState secondDoorState = world.func_180495_p(pos.func_177978_c());
                        if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.reinforcedDoor && (Boolean)secondDoorState.func_177229_b((IProperty)OPEN) != hasActiveSCBlock) {
                            world.func_180501_a(pos.func_177978_c(), (IBlockState)secondDoorState.func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                            world.func_175704_b(pos.func_177978_c(), pos.func_177978_c());
                        } else {
                            secondDoorState = world.func_180495_p(pos.func_177968_d());
                            if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.reinforcedDoor && (Boolean)secondDoorState.func_177229_b((IProperty)OPEN) != hasActiveSCBlock) {
                                world.func_180501_a(pos.func_177968_d(), (IBlockState)secondDoorState.func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                                world.func_175704_b(pos.func_177968_d(), pos.func_177968_d());
                            }
                        }
                    } else if (state.func_177229_b((IProperty)FACING) == EnumFacing.NORTH) {
                        IBlockState secondDoorState = world.func_180495_p(pos.func_177974_f());
                        if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.reinforcedDoor && (Boolean)secondDoorState.func_177229_b((IProperty)OPEN) != hasActiveSCBlock) {
                            world.func_180501_a(pos.func_177974_f(), (IBlockState)secondDoorState.func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                            world.func_175704_b(pos.func_177974_f(), pos.func_177974_f());
                        } else {
                            secondDoorState = world.func_180495_p(pos.func_177976_e());
                            if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.reinforcedDoor && (Boolean)secondDoorState.func_177229_b((IProperty)OPEN) != hasActiveSCBlock) {
                                world.func_180501_a(pos.func_177976_e(), (IBlockState)secondDoorState.func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                                world.func_175704_b(pos.func_177976_e(), pos.func_177976_e());
                            }
                        }
                    } else if (state.func_177229_b((IProperty)FACING) == EnumFacing.EAST) {
                        IBlockState secondDoorState = world.func_180495_p(pos.func_177968_d());
                        if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.reinforcedDoor && (Boolean)secondDoorState.func_177229_b((IProperty)OPEN) != hasActiveSCBlock) {
                            world.func_180501_a(pos.func_177968_d(), (IBlockState)secondDoorState.func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                            world.func_175704_b(pos.func_177968_d(), pos.func_177968_d());
                        } else {
                            secondDoorState = world.func_180495_p(pos.func_177978_c());
                            if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.reinforcedDoor && (Boolean)secondDoorState.func_177229_b((IProperty)OPEN) != hasActiveSCBlock) {
                                world.func_180501_a(pos.func_177978_c(), (IBlockState)secondDoorState.func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                                world.func_175704_b(pos.func_177978_c(), pos.func_177978_c());
                            }
                        }
                    } else if (state.func_177229_b((IProperty)FACING) == EnumFacing.SOUTH) {
                        IBlockState secondDoorState = world.func_180495_p(pos.func_177976_e());
                        if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.reinforcedDoor && (Boolean)secondDoorState.func_177229_b((IProperty)OPEN) != hasActiveSCBlock) {
                            world.func_180501_a(pos.func_177976_e(), (IBlockState)secondDoorState.func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                            world.func_175704_b(pos.func_177976_e(), pos.func_177976_e());
                        } else {
                            secondDoorState = world.func_180495_p(pos.func_177974_f());
                            if (secondDoorState != null && secondDoorState.func_177230_c() == SCContent.reinforcedDoor && (Boolean)secondDoorState.func_177229_b((IProperty)OPEN) != hasActiveSCBlock) {
                                world.func_180501_a(pos.func_177974_f(), (IBlockState)secondDoorState.func_206870_a((IProperty)OPEN, (Comparable)Boolean.valueOf(hasActiveSCBlock)), 2);
                                world.func_175704_b(pos.func_177974_f(), pos.func_177974_f());
                            }
                        }
                    }
                    world.func_180498_a((EntityPlayer)null, hasActiveSCBlock ? 1005 : 1011, pos, 0);
                }
            }
        }
        if (previousOwner != null && world.func_175625_s(pos) instanceof TileEntityOwnable && world.func_175625_s(pos.func_177984_a()) instanceof TileEntityOwnable) {
            ((TileEntityOwnable)world.func_175625_s(pos)).getOwner().set(previousOwner);
            ((TileEntityOwnable)world.func_175625_s(pos.func_177984_a())).getOwner().set(previousOwner);
        }
    }

    public boolean func_196260_a(IBlockState state, IWorldReaderBase worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos.func_177977_b());
        if (state.func_177229_b(HALF) == DoubleBlockHalf.LOWER) {
            return iblockstate.func_185896_q();
        }
        return iblockstate.func_177230_c() == this;
    }

    private void playSound(World p_196426_1_, BlockPos p_196426_2_, boolean p_196426_3_) {
        p_196426_1_.func_180498_a((EntityPlayer)null, p_196426_3_ ? this.getOpenSound() : this.getCloseSound(), p_196426_2_, 0);
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return (IBlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return mirrorIn == Mirror.NONE ? state : (IBlockState)state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING))).func_177231_a(HINGE);
    }

    @OnlyIn(value=Dist.CLIENT)
    public long func_209900_a(IBlockState state, BlockPos pos) {
        return MathHelper.func_180187_c((int)pos.func_177958_n(), (int)pos.func_177979_c(state.func_177229_b(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).func_177956_o(), (int)pos.func_177952_p());
    }

    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_196243_a(IBlockState state, World world, BlockPos pos, IBlockState newState, boolean isMoving) {
        super.func_196243_a(state, world, pos, newState, isMoving);
        if (state.func_177230_c() != newState.func_177230_c()) {
            world.func_175713_t(pos);
        }
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int id, int param) {
        super.func_189539_a(state, world, pos, id, param);
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity == null ? false : tileentity.func_145842_c(id, param);
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack((IItemProvider)SCContent.reinforcedDoorItem);
    }

    public IItemProvider func_199769_a(IBlockState state, World worldIn, BlockPos pos, int fortune) {
        return state.func_177229_b(HALF) == DoubleBlockHalf.UPPER ? Items.field_190931_a : SCContent.reinforcedDoorItem;
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileEntityOwnable();
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{HALF, FACING, OPEN, HINGE});
    }
}

