/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import net.geforcemods.securitycraft.api.IIntersectable;
import net.geforcemods.securitycraft.blocks.BlockInventoryScanner;
import net.geforcemods.securitycraft.blocks.BlockKeycardReader;
import net.geforcemods.securitycraft.blocks.BlockKeypad;
import net.geforcemods.securitycraft.blocks.BlockLaserBlock;
import net.geforcemods.securitycraft.blocks.BlockRetinalScanner;
import net.geforcemods.securitycraft.misc.CustomDamageSources;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class BlockReinforcedFenceGate
extends BlockFenceGate
implements ITileEntityProvider,
IIntersectable {
    public BlockReinforcedFenceGate() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(-1.0f, 6000000.0f).func_200947_a(SoundType.field_185852_e));
    }

    public boolean func_196250_a(IBlockState state, World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void func_196243_a(IBlockState state, World world, BlockPos pos, IBlockState newState, boolean isMoving) {
        super.func_196243_a(state, world, pos, newState, isMoving);
        world.func_175713_t(pos);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)placer));
        }
    }

    @Override
    public void onEntityIntersected(World world, BlockPos pos, Entity entity) {
        if (BlockUtils.getBlockPropertyAsBoolean(world, pos, field_176466_a)) {
            return;
        }
        if (entity instanceof EntityItem) {
            return;
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (((TileEntityOwnable)world.func_175625_s(pos)).getOwner().isOwner(player)) {
                return;
            }
        } else if (entity instanceof EntityCreeper) {
            EntityCreeper creeper = (EntityCreeper)entity;
            EntityLightningBolt lightning = new EntityLightningBolt(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), true);
            creeper.func_70077_a(lightning);
            return;
        }
        entity.func_70097_a((DamageSource)CustomDamageSources.electricity, 6.0f);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!world.field_72995_K) {
            boolean isPoweredSCBlock;
            boolean bl = isPoweredSCBlock = this.isSCBlock(block) && world.func_175640_z(pos);
            if (isPoweredSCBlock || block.func_176223_P().func_185897_m()) {
                if (isPoweredSCBlock && !((Boolean)state.func_177229_b((IProperty)field_176466_a)).booleanValue() && !((Boolean)state.func_177229_b((IProperty)field_176465_b)).booleanValue()) {
                    world.func_180501_a(pos, (IBlockState)((IBlockState)state.func_206870_a((IProperty)field_176466_a, (Comparable)Boolean.valueOf(true))).func_206870_a((IProperty)field_176465_b, (Comparable)Boolean.valueOf(true)), 2);
                    world.func_180498_a((EntityPlayer)null, 1008, pos, 0);
                } else if (!isPoweredSCBlock && ((Boolean)state.func_177229_b((IProperty)field_176466_a)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)field_176465_b)).booleanValue()) {
                    world.func_180501_a(pos, (IBlockState)((IBlockState)state.func_206870_a((IProperty)field_176466_a, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)field_176465_b, (Comparable)Boolean.valueOf(false)), 2);
                    world.func_180498_a((EntityPlayer)null, 1014, pos, 0);
                } else if (isPoweredSCBlock != (Boolean)state.func_177229_b((IProperty)field_176465_b)) {
                    world.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)field_176465_b, (Comparable)Boolean.valueOf(isPoweredSCBlock)), 2);
                }
            }
        }
    }

    private boolean isSCBlock(Block block) {
        return block instanceof BlockLaserBlock || block instanceof BlockRetinalScanner || block instanceof BlockKeypad || block instanceof BlockKeycardReader || block instanceof BlockInventoryScanner;
    }

    public boolean func_189539_a(IBlockState state, World world, BlockPos pos, int par5, int par6) {
        super.func_189539_a(state, world, pos, par5, par6);
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity != null ? tileentity.func_145842_c(par5, par6) : false;
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader world) {
        return new TileEntityOwnable().intersectsEntities();
    }
}

