/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Map;
import net.geforcemods.securitycraft.blocks.reinforced.BlockReinforcedBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.block.BlockSixWay;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockReinforcedPane
extends BlockReinforcedBase
implements IBucketPickupHandler,
ILiquidContainer {
    public static final BooleanProperty NORTH = BlockSixWay.field_196488_a;
    public static final BooleanProperty EAST = BlockSixWay.field_196490_b;
    public static final BooleanProperty SOUTH = BlockSixWay.field_196492_c;
    public static final BooleanProperty WEST = BlockSixWay.field_196495_y;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final Map<EnumFacing, BooleanProperty> FACING_TO_PROPERTY_MAP = (Map)BlockSixWay.field_196491_B.entrySet().stream().filter(p_199775_0_ -> ((EnumFacing)p_199775_0_.getKey()).func_176740_k().func_176722_c()).collect(Util.func_199749_a());
    protected final VoxelShape[] field_196410_A = this.func_196408_a(1.0f, 1.0f, 16.0f, 0.0f, 16.0f);
    protected final VoxelShape[] field_196412_B = this.func_196408_a(1.0f, 1.0f, 16.0f, 0.0f, 16.0f);

    public BlockReinforcedPane(SoundType soundType, Material mat, Block vB, String registryPath) {
        super(soundType, mat, vB, registryPath, 0);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected VoxelShape[] func_196408_a(float p_196408_1_, float p_196408_2_, float p_196408_3_, float p_196408_4_, float p_196408_5_) {
        float f = 8.0f - p_196408_1_;
        float f1 = 8.0f + p_196408_1_;
        float f2 = 8.0f - p_196408_2_;
        float f3 = 8.0f + p_196408_2_;
        VoxelShape voxelshape = Block.func_208617_a((double)f, (double)0.0, (double)f, (double)f1, (double)p_196408_3_, (double)f1);
        VoxelShape voxelshape1 = Block.func_208617_a((double)f2, (double)p_196408_4_, (double)0.0, (double)f3, (double)p_196408_5_, (double)f3);
        VoxelShape voxelshape2 = Block.func_208617_a((double)f2, (double)p_196408_4_, (double)f2, (double)f3, (double)p_196408_5_, (double)16.0);
        VoxelShape voxelshape3 = Block.func_208617_a((double)0.0, (double)p_196408_4_, (double)f2, (double)f3, (double)p_196408_5_, (double)f3);
        VoxelShape voxelshape4 = Block.func_208617_a((double)f2, (double)p_196408_4_, (double)f2, (double)16.0, (double)p_196408_5_, (double)f3);
        VoxelShape voxelshape5 = VoxelShapes.func_197872_a((VoxelShape)voxelshape1, (VoxelShape)voxelshape4);
        VoxelShape voxelshape6 = VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape3);
        VoxelShape[] avoxelshape = new VoxelShape[]{VoxelShapes.func_197880_a(), voxelshape2, voxelshape3, voxelshape6, voxelshape1, VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape1), VoxelShapes.func_197872_a((VoxelShape)voxelshape3, (VoxelShape)voxelshape1), VoxelShapes.func_197872_a((VoxelShape)voxelshape6, (VoxelShape)voxelshape1), voxelshape4, VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape4), VoxelShapes.func_197872_a((VoxelShape)voxelshape3, (VoxelShape)voxelshape4), VoxelShapes.func_197872_a((VoxelShape)voxelshape6, (VoxelShape)voxelshape4), voxelshape5, VoxelShapes.func_197872_a((VoxelShape)voxelshape2, (VoxelShape)voxelshape5), VoxelShapes.func_197872_a((VoxelShape)voxelshape3, (VoxelShape)voxelshape5), VoxelShapes.func_197872_a((VoxelShape)voxelshape6, (VoxelShape)voxelshape5)};
        for (int i = 0; i < 16; ++i) {
            avoxelshape[i] = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)avoxelshape[i]);
        }
        return avoxelshape;
    }

    public Fluid func_204508_a(IWorld world, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            return Fluids.field_204546_a;
        }
        return Fluids.field_204541_a;
    }

    public IFluidState func_204507_t(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204510_a(IBlockReader world, BlockPos pos, IBlockState state, Fluid fluid) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) == false && fluid == Fluids.field_204546_a;
    }

    public boolean func_204509_a(IWorld world, BlockPos pos, IBlockState state, IFluidState fluidState) {
        if (!((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue() && fluidState.func_206886_c() == Fluids.field_204546_a) {
            if (!world.func_201670_d()) {
                world.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                world.func_205219_F_().func_205360_a(pos, (Object)fluidState.func_206886_c(), fluidState.func_206886_c().func_205569_a((IWorldReaderBase)world));
            }
            return true;
        }
        return false;
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader world, BlockPos pos) {
        return this.field_196412_B[this.getIndex(state)];
    }

    public VoxelShape func_196268_f(IBlockState state, IBlockReader world, BlockPos pos) {
        return this.field_196410_A[this.getIndex(state)];
    }

    private static int getMask(EnumFacing facing) {
        return 1 << facing.func_176736_b();
    }

    protected int getIndex(IBlockState p_196406_1_) {
        int i = 0;
        if (((Boolean)p_196406_1_.func_177229_b((IProperty)NORTH)).booleanValue()) {
            i |= BlockReinforcedPane.getMask(EnumFacing.NORTH);
        }
        if (((Boolean)p_196406_1_.func_177229_b((IProperty)EAST)).booleanValue()) {
            i |= BlockReinforcedPane.getMask(EnumFacing.EAST);
        }
        if (((Boolean)p_196406_1_.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            i |= BlockReinforcedPane.getMask(EnumFacing.SOUTH);
        }
        if (((Boolean)p_196406_1_.func_177229_b((IProperty)WEST)).booleanValue()) {
            i |= BlockReinforcedPane.getMask(EnumFacing.WEST);
        }
        return i;
    }

    public boolean func_196266_a(IBlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return (IBlockState)((IBlockState)((IBlockState)((IBlockState)state.func_206870_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH))).func_206870_a((IProperty)EAST, state.func_177229_b((IProperty)WEST))).func_206870_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH))).func_206870_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (IBlockState)((IBlockState)((IBlockState)((IBlockState)state.func_206870_a((IProperty)NORTH, state.func_177229_b((IProperty)EAST))).func_206870_a((IProperty)EAST, state.func_177229_b((IProperty)SOUTH))).func_206870_a((IProperty)SOUTH, state.func_177229_b((IProperty)WEST))).func_206870_a((IProperty)WEST, state.func_177229_b((IProperty)NORTH));
            }
            case CLOCKWISE_90: {
                return (IBlockState)((IBlockState)((IBlockState)((IBlockState)state.func_206870_a((IProperty)NORTH, state.func_177229_b((IProperty)WEST))).func_206870_a((IProperty)EAST, state.func_177229_b((IProperty)NORTH))).func_206870_a((IProperty)SOUTH, state.func_177229_b((IProperty)EAST))).func_206870_a((IProperty)WEST, state.func_177229_b((IProperty)SOUTH));
            }
        }
        return state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        switch (mirror) {
            case LEFT_RIGHT: {
                return (IBlockState)((IBlockState)state.func_206870_a((IProperty)NORTH, state.func_177229_b((IProperty)SOUTH))).func_206870_a((IProperty)SOUTH, state.func_177229_b((IProperty)NORTH));
            }
            case FRONT_BACK: {
                return (IBlockState)((IBlockState)state.func_206870_a((IProperty)EAST, state.func_177229_b((IProperty)WEST))).func_206870_a((IProperty)WEST, state.func_177229_b((IProperty)EAST));
            }
        }
        return super.func_185471_a(state, mirror);
    }

    public IBlockState func_196258_a(BlockItemUseContext ctx) {
        World iblockreader = ctx.func_195991_k();
        BlockPos blockpos = ctx.func_195995_a();
        IFluidState ifluidstate = ctx.func_195991_k().func_204610_c(ctx.func_195995_a());
        return (IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)this.func_176223_P().func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canPaneConnectTo((IBlockReader)iblockreader, blockpos, EnumFacing.NORTH)))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canPaneConnectTo((IBlockReader)iblockreader, blockpos, EnumFacing.SOUTH)))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canPaneConnectTo((IBlockReader)iblockreader, blockpos, EnumFacing.WEST)))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canPaneConnectTo((IBlockReader)iblockreader, blockpos, EnumFacing.EAST)))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public IBlockState func_196271_a(IBlockState state, EnumFacing facing, IBlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReaderBase)world));
        }
        return facing.func_176740_k().func_176722_c() ? (IBlockState)state.func_206870_a((IProperty)FACING_TO_PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(this.canPaneConnectTo((IBlockReader)world, currentPos, facing))) : super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(IBlockState state, IBlockState adjacentBlockState, EnumFacing side) {
        if (adjacentBlockState.func_177230_c() == this) {
            if (!side.func_176740_k().func_176722_c()) {
                return true;
            }
            if (((Boolean)state.func_177229_b((IProperty)FACING_TO_PROPERTY_MAP.get(side))).booleanValue() && ((Boolean)adjacentBlockState.func_177229_b((IProperty)FACING_TO_PROPERTY_MAP.get(side.func_176734_d()))).booleanValue()) {
                return true;
            }
        }
        return super.func_200122_a(state, adjacentBlockState, side);
    }

    public final boolean attachesTo(IBlockState p_196417_1_, BlockFaceShape p_196417_2_) {
        Block block = p_196417_1_.func_177230_c();
        return !BlockReinforcedPane.shouldSkipAttachment(block) && p_196417_2_ == BlockFaceShape.SOLID || p_196417_2_ == BlockFaceShape.MIDDLE_POLE_THIN;
    }

    public static boolean shouldSkipAttachment(Block p_196418_0_) {
        return p_196418_0_ instanceof BlockShulkerBox || p_196418_0_ instanceof BlockLeaves || p_196418_0_ == Blocks.field_150461_bJ || p_196418_0_ == Blocks.field_150383_bp || p_196418_0_ == Blocks.field_150426_aN || p_196418_0_ == Blocks.field_150432_aD || p_196418_0_ == Blocks.field_180398_cJ || p_196418_0_ == Blocks.field_150331_J || p_196418_0_ == Blocks.field_150320_F || p_196418_0_ == Blocks.field_150332_K || p_196418_0_ == Blocks.field_150440_ba || p_196418_0_ == Blocks.field_150423_aK || p_196418_0_ == Blocks.field_196625_cS || p_196418_0_ == Blocks.field_196628_cT || p_196418_0_ == Blocks.field_180401_cv;
    }

    protected boolean func_149700_E() {
        return true;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{NORTH, EAST, WEST, SOUTH, WATERLOGGED});
    }

    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face != EnumFacing.UP && face != EnumFacing.DOWN ? BlockFaceShape.MIDDLE_POLE_THIN : BlockFaceShape.CENTER_SMALL;
    }

    public boolean canBeConnectedTo(IBlockState state, IBlockReader world, BlockPos pos, EnumFacing facing) {
        IBlockState other = world.func_180495_p(pos.func_177972_a(facing));
        return this.attachesTo(other, other.func_193401_d(world, pos.func_177972_a(facing), facing.func_176734_d()));
    }

    private boolean canPaneConnectTo(IBlockReader world, BlockPos pos, EnumFacing facing) {
        BlockPos offset = pos.func_177972_a(facing);
        IBlockState other = world.func_180495_p(offset);
        return other.canBeConnectedTo(world, offset, facing.func_176734_d()) || this.func_176223_P().canBeConnectedTo(world, pos, facing);
    }

    @Override
    public IBlockState getConvertedState(IBlockState vanillaState) {
        return (IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)this.func_176223_P().func_206870_a((IProperty)NORTH, vanillaState.func_177229_b((IProperty)BlockPane.field_196409_a))).func_206870_a((IProperty)EAST, vanillaState.func_177229_b((IProperty)BlockPane.field_196411_b))).func_206870_a((IProperty)WEST, vanillaState.func_177229_b((IProperty)BlockPane.field_196414_y))).func_206870_a((IProperty)SOUTH, vanillaState.func_177229_b((IProperty)BlockPane.field_196413_c))).func_206870_a((IProperty)WATERLOGGED, vanillaState.func_177229_b((IProperty)BlockPane.field_204514_u));
    }
}

