/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.List;
import net.geforcemods.securitycraft.blocks.reinforced.IReinforcedBlock;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.misc.OwnershipEvent;
import net.geforcemods.securitycraft.tileentity.TileEntityReinforcedPressurePlate;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPressurePlate;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class BlockReinforcedPressurePlate
extends BlockPressurePlate
implements IReinforcedBlock {
    public BlockReinforcedPressurePlate() {
        super(BlockPressurePlate.Sensitivity.MOBS, Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200942_a().func_200948_a(-1.0f, 6000000.0f));
    }

    public void func_196262_a(IBlockState state, World world, BlockPos pos, Entity entity) {
        TileEntity tileEntity;
        int redstoneStrength = this.func_176576_e(state);
        if (!world.field_72995_K && redstoneStrength == 0 && entity instanceof EntityPlayer && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityReinforcedPressurePlate && this.isAllowedToPress(world, pos, (TileEntityReinforcedPressurePlate)tileEntity, (EntityPlayer)entity)) {
            this.func_180666_a(world, pos, state, redstoneStrength);
        }
    }

    protected int func_180669_e(World world, BlockPos pos) {
        TileEntity tileEntity;
        AxisAlignedBB aabb = field_185511_c.func_186670_a(pos);
        List list = world.func_72839_b(null, aabb);
        if (!list.isEmpty() && (tileEntity = world.func_175625_s(pos)) instanceof TileEntityReinforcedPressurePlate) {
            for (Entity entity : list) {
                if (!(entity instanceof EntityPlayer) || !this.isAllowedToPress(world, pos, (TileEntityReinforcedPressurePlate)tileEntity, (EntityPlayer)entity)) continue;
                return 15;
            }
        }
        return 0;
    }

    public boolean isAllowedToPress(World world, BlockPos pos, TileEntityReinforcedPressurePlate te, EntityPlayer entity) {
        return te.getOwner().isOwner(entity) || ModuleUtils.getPlayersFromModule(world, pos, EnumCustomModules.WHITELIST).contains(entity.func_200200_C_().func_150261_e().toLowerCase());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (placer instanceof EntityPlayer) {
            MinecraftForge.EVENT_BUS.post((Event)new OwnershipEvent(world, pos, (EntityPlayer)placer));
        }
    }

    @Override
    public Block getVanillaBlock() {
        return Blocks.field_150456_au;
    }

    @Override
    public IBlockState getConvertedState(IBlockState vanillaState) {
        return this.func_176223_P();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(IBlockState state, IBlockReader world) {
        return new TileEntityReinforcedPressurePlate();
    }
}

