/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Random;
import javax.annotation.Nullable;
import net.geforcemods.securitycraft.blocks.reinforced.BlockReinforcedBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;

public class BlockReinforcedSlab
extends BlockReinforcedBase
implements IBucketPickupHandler,
ILiquidContainer {
    public static final EnumProperty<SlabType> TYPE = BlockStateProperties.field_208145_at;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape BOTTOM_SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape TOP_SHAPE = Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public BlockReinforcedSlab(SoundType soundType, Material mat, Block vB, String registryPath) {
        super(soundType, mat, vB, registryPath);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a(TYPE, (Comparable)SlabType.BOTTOM)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public int func_200011_d(IBlockState state, IBlockReader world, BlockPos pos) {
        return world.func_201572_C();
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{TYPE, WATERLOGGED});
    }

    protected boolean func_149700_E() {
        return false;
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader world, BlockPos pos) {
        SlabType slabtype = (SlabType)state.func_177229_b(TYPE);
        switch (slabtype) {
            case DOUBLE: {
                return VoxelShapes.func_197868_b();
            }
            case TOP: {
                return TOP_SHAPE;
            }
        }
        return BOTTOM_SHAPE;
    }

    public boolean func_185481_k(IBlockState state) {
        return state.func_177229_b(TYPE) == SlabType.DOUBLE || state.func_177229_b(TYPE) == SlabType.TOP;
    }

    public BlockFaceShape func_193383_a(IBlockReader world, IBlockState state, BlockPos pos, EnumFacing face) {
        SlabType slabType = (SlabType)state.func_177229_b(TYPE);
        if (slabType == SlabType.DOUBLE) {
            return BlockFaceShape.SOLID;
        }
        if (face == EnumFacing.UP && slabType == SlabType.TOP) {
            return BlockFaceShape.SOLID;
        }
        return face == EnumFacing.DOWN && slabType == SlabType.BOTTOM ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    @Nullable
    public IBlockState func_196258_a(BlockItemUseContext ctx) {
        IBlockState state = ctx.func_195991_k().func_180495_p(ctx.func_195995_a());
        if (state.func_177230_c() == this) {
            return (IBlockState)((IBlockState)state.func_206870_a(TYPE, (Comparable)SlabType.DOUBLE)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        IFluidState fluidState = ctx.func_195991_k().func_204610_c(ctx.func_195995_a());
        IBlockState newState = (IBlockState)((IBlockState)this.func_176223_P().func_206870_a(TYPE, (Comparable)SlabType.BOTTOM)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.func_206886_c() == Fluids.field_204546_a));
        EnumFacing enumfacing = ctx.func_196000_l();
        return !(enumfacing == EnumFacing.DOWN || enumfacing != EnumFacing.UP && (double)ctx.func_195993_n() > 0.5) ? newState : (IBlockState)newState.func_206870_a(TYPE, (Comparable)SlabType.TOP);
    }

    public int func_196264_a(IBlockState state, Random random) {
        return state.func_177229_b(TYPE) == SlabType.DOUBLE ? 2 : 1;
    }

    public boolean func_149686_d(IBlockState state) {
        return state.func_177229_b(TYPE) == SlabType.DOUBLE;
    }

    public boolean func_196253_a(IBlockState state, BlockItemUseContext ctx) {
        ItemStack stack = ctx.func_195996_i();
        SlabType slabType = (SlabType)state.func_177229_b(TYPE);
        if (slabType != SlabType.DOUBLE && stack.func_77973_b() == this.func_199767_j()) {
            if (ctx.func_196012_c()) {
                boolean hitTop = (double)ctx.func_195993_n() > 0.5;
                EnumFacing facing = ctx.func_196000_l();
                if (slabType == SlabType.BOTTOM) {
                    return facing == EnumFacing.UP || hitTop && facing.func_176740_k().func_176722_c();
                }
                return facing == EnumFacing.DOWN || !hitTop && facing.func_176740_k().func_176722_c();
            }
            return true;
        }
        return false;
    }

    public Fluid func_204508_a(IWorld world, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            return Fluids.field_204546_a;
        }
        return Fluids.field_204541_a;
    }

    public IFluidState func_204507_t(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204510_a(IBlockReader world, BlockPos pos, IBlockState state, Fluid fluid) {
        return state.func_177229_b(TYPE) != SlabType.DOUBLE && (Boolean)state.func_177229_b((IProperty)WATERLOGGED) == false && fluid == Fluids.field_204546_a;
    }

    public boolean func_204509_a(IWorld world, BlockPos pos, IBlockState state, IFluidState fluidState) {
        if (state.func_177229_b(TYPE) != SlabType.DOUBLE && !((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue() && fluidState.func_206886_c() == Fluids.field_204546_a) {
            if (!world.func_201670_d()) {
                world.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                world.func_205219_F_().func_205360_a(pos, (Object)fluidState.func_206886_c(), fluidState.func_206886_c().func_205569_a((IWorldReaderBase)world));
            }
            return true;
        }
        return false;
    }

    public IBlockState func_196271_a(IBlockState state, EnumFacing facing, IBlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReaderBase)world));
        }
        return super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    public boolean func_196266_a(IBlockState state, IBlockReader world, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return state.func_177229_b(TYPE) == SlabType.BOTTOM;
            }
            case WATER: {
                return world.func_204610_c(pos).func_206884_a(FluidTags.field_206959_a);
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }

    @Override
    public IBlockState getConvertedState(IBlockState vanillaState) {
        return (IBlockState)((IBlockState)this.func_176223_P().func_206870_a(TYPE, vanillaState.func_177229_b((IProperty)BlockSlab.field_196505_a))).func_206870_a((IProperty)WATERLOGGED, vanillaState.func_177229_b((IProperty)BlockSlab.field_204512_b));
    }
}

