/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.Random;
import java.util.stream.IntStream;
import net.geforcemods.securitycraft.blocks.reinforced.BlockReinforcedBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockReinforcedStairs
extends BlockReinforcedBase
implements IBucketPickupHandler,
ILiquidContainer {
    public static final DirectionProperty FACING = BlockHorizontal.field_185512_D;
    public static final EnumProperty<Half> HALF = BlockStateProperties.field_208164_Q;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.field_208146_au;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final VoxelShape AABB_SLAB_TOP = Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape AABB_SLAB_BOTTOM = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape field_196512_A = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0);
    protected static final VoxelShape field_196513_B = Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0);
    protected static final VoxelShape field_196514_C = Block.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
    protected static final VoxelShape field_196515_D = Block.func_208617_a((double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape field_196516_E = Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
    protected static final VoxelShape field_196517_F = Block.func_208617_a((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape field_196518_G = Block.func_208617_a((double)8.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape field_196519_H = Block.func_208617_a((double)8.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape[] field_196520_I = BlockReinforcedStairs.func_199779_a(AABB_SLAB_TOP, field_196512_A, field_196516_E, field_196513_B, field_196517_F);
    protected static final VoxelShape[] field_196521_J = BlockReinforcedStairs.func_199779_a(AABB_SLAB_BOTTOM, field_196514_C, field_196518_G, field_196515_D, field_196519_H);
    private static final int[] field_196522_K = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};
    private final Block modelBlock;
    private final IBlockState modelState;

    public BlockReinforcedStairs(SoundType soundType, Material mat, Block vB, String registryPath) {
        super(soundType, mat, vB, registryPath, 0);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)EnumFacing.NORTH)).func_206870_a(HALF, (Comparable)Half.BOTTOM)).func_206870_a(SHAPE, (Comparable)StairsShape.STRAIGHT)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.modelBlock = vB == Blocks.field_150348_b ? vB : this.getVanillaBlock();
        this.modelState = this.modelBlock.func_176223_P();
    }

    private static VoxelShape[] func_199779_a(VoxelShape p_199779_0_, VoxelShape p_199779_1_, VoxelShape p_199779_2_, VoxelShape p_199779_3_, VoxelShape p_199779_4_) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(p_199780_5_ -> BlockReinforcedStairs.func_199781_a(p_199780_5_, p_199779_0_, p_199779_1_, p_199779_2_, p_199779_3_, p_199779_4_)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape func_199781_a(int p_199781_0_, VoxelShape p_199781_1_, VoxelShape p_199781_2_, VoxelShape p_199781_3_, VoxelShape p_199781_4_, VoxelShape p_199781_5_) {
        VoxelShape voxelshape = p_199781_1_;
        if ((p_199781_0_ & 1) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)p_199781_1_, (VoxelShape)p_199781_2_);
        }
        if ((p_199781_0_ & 2) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)p_199781_3_);
        }
        if ((p_199781_0_ & 4) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)p_199781_4_);
        }
        if ((p_199781_0_ & 8) != 0) {
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)p_199781_5_);
        }
        return voxelshape;
    }

    public int func_200011_d(IBlockState state, IBlockReader world, BlockPos pos) {
        return world.func_201572_C();
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader world, BlockPos pos) {
        return (state.func_177229_b(HALF) == Half.TOP ? field_196520_I : field_196521_J)[field_196522_K[this.func_196511_x(state)]];
    }

    private int func_196511_x(IBlockState p_196511_1_) {
        return ((StairsShape)p_196511_1_.func_177229_b(SHAPE)).ordinal() * 4 + ((EnumFacing)p_196511_1_.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public BlockFaceShape func_193383_a(IBlockReader world, IBlockState state, BlockPos pos, EnumFacing face) {
        if (face.func_176740_k() == EnumFacing.Axis.Y) {
            return face == EnumFacing.UP == (state.func_177229_b(HALF) == Half.TOP) ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
        }
        StairsShape stairsshape = (StairsShape)state.func_177229_b(SHAPE);
        if (stairsshape != StairsShape.OUTER_LEFT && stairsshape != StairsShape.OUTER_RIGHT) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
            switch (stairsshape) {
                case STRAIGHT: {
                    return enumfacing == face ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
                }
                case INNER_LEFT: {
                    return enumfacing != face && enumfacing != face.func_176746_e() ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
                }
                case INNER_RIGHT: {
                    return enumfacing != face && enumfacing != face.func_176735_f() ? BlockFaceShape.UNDEFINED : BlockFaceShape.SOLID;
                }
            }
            return BlockFaceShape.UNDEFINED;
        }
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public Block getVanillaBlock() {
        return this.modelBlock == Blocks.field_150348_b ? Blocks.field_150350_a : super.getVanillaBlock();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        this.modelBlock.func_180655_c(stateIn, worldIn, pos, rand);
    }

    public void func_196270_a(IBlockState state, World worldIn, BlockPos pos, EntityPlayer player) {
        this.modelState.func_196942_a(worldIn, pos, player);
    }

    public void func_176206_d(IWorld worldIn, BlockPos pos, IBlockState state) {
        this.modelBlock.func_176206_d(worldIn, pos, state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int func_185484_c(IBlockState state, IWorldReader source, BlockPos pos) {
        return this.modelState.func_185889_a(source, pos);
    }

    public float func_149638_a() {
        return this.modelBlock.func_149638_a();
    }

    public BlockRenderLayer func_180664_k() {
        return this.modelBlock.func_180664_k();
    }

    public int func_149738_a(IWorldReaderBase world) {
        return this.modelBlock.func_149738_a(world);
    }

    public boolean func_149703_v() {
        return this.modelBlock.func_149703_v();
    }

    public boolean func_200293_a(IBlockState state) {
        return this.modelBlock.func_200293_a(state);
    }

    public void func_196259_b(IBlockState state, World world, BlockPos pos, IBlockState oldState) {
        if (state.func_177230_c() != state.func_177230_c()) {
            this.modelState.func_189546_a(world, pos, Blocks.field_150350_a, pos);
            this.modelBlock.func_196259_b(this.modelState, world, pos, oldState);
        }
    }

    public void func_196243_a(IBlockState state, World world, BlockPos pos, IBlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            this.modelState.func_196947_b(world, pos, newState, isMoving);
        }
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entity) {
        this.modelBlock.func_176199_a(worldIn, pos, entity);
    }

    public void func_196267_b(IBlockState state, World world, BlockPos pos, Random random) {
        this.modelBlock.func_196267_b(state, world, pos, random);
    }

    public boolean func_196250_a(IBlockState state, World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return this.modelState.func_196943_a(world, pos, player, hand, EnumFacing.DOWN, 0.0f, 0.0f, 0.0f);
    }

    public void func_180652_a(World world, BlockPos pos, Explosion explosion) {
        this.modelBlock.func_180652_a(world, pos, explosion);
    }

    public boolean func_185481_k(IBlockState state) {
        return state.func_177229_b(HALF) == Half.TOP;
    }

    public IBlockState func_196258_a(BlockItemUseContext ctx) {
        EnumFacing enumfacing = ctx.func_196000_l();
        IFluidState ifluidstate = ctx.func_195991_k().func_204610_c(ctx.func_195995_a());
        IBlockState iblockstate = (IBlockState)((IBlockState)((IBlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)ctx.func_195992_f())).func_206870_a(HALF, (Comparable)(!(enumfacing == EnumFacing.DOWN || enumfacing != EnumFacing.UP && (double)ctx.func_195993_n() > 0.5) ? Half.BOTTOM : Half.TOP))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
        return (IBlockState)iblockstate.func_206870_a(SHAPE, (Comparable)BlockReinforcedStairs.func_208064_n(iblockstate, (IBlockReader)ctx.func_195991_k(), ctx.func_195995_a()));
    }

    public IBlockState func_196271_a(IBlockState state, EnumFacing facing, IBlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReaderBase)world));
        }
        return facing.func_176740_k().func_176722_c() ? (IBlockState)state.func_206870_a(SHAPE, (Comparable)BlockReinforcedStairs.func_208064_n(state, (IBlockReader)world, currentPos)) : super.func_196271_a(state, facing, facingState, world, currentPos, facingPos);
    }

    private static StairsShape func_208064_n(IBlockState state, IBlockReader world, BlockPos pos) {
        EnumFacing enumfacing2;
        EnumFacing enumfacing1;
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        IBlockState iblockstate = world.func_180495_p(pos.func_177972_a(enumfacing));
        if (BlockReinforcedStairs.isBlockStairs(iblockstate) && state.func_177229_b(HALF) == iblockstate.func_177229_b(HALF) && (enumfacing1 = (EnumFacing)iblockstate.func_177229_b((IProperty)FACING)).func_176740_k() != ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k() && BlockReinforcedStairs.isDifferentStairs(state, world, pos, enumfacing1.func_176734_d())) {
            if (enumfacing1 == enumfacing.func_176735_f()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        IBlockState iblockstate1 = world.func_180495_p(pos.func_177972_a(enumfacing.func_176734_d()));
        if (BlockReinforcedStairs.isBlockStairs(iblockstate1) && state.func_177229_b(HALF) == iblockstate1.func_177229_b(HALF) && (enumfacing2 = (EnumFacing)iblockstate1.func_177229_b((IProperty)FACING)).func_176740_k() != ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k() && BlockReinforcedStairs.isDifferentStairs(state, world, pos, enumfacing2)) {
            if (enumfacing2 == enumfacing.func_176735_f()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean isDifferentStairs(IBlockState state, IBlockReader world, BlockPos pos, EnumFacing face) {
        IBlockState iblockstate = world.func_180495_p(pos.func_177972_a(face));
        return !BlockReinforcedStairs.isBlockStairs(iblockstate) || iblockstate.func_177229_b((IProperty)FACING) != state.func_177229_b((IProperty)FACING) || iblockstate.func_177229_b(HALF) != state.func_177229_b(HALF);
    }

    public static boolean isBlockStairs(IBlockState state) {
        return state.func_177230_c() instanceof BlockReinforcedStairs;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return (IBlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        StairsShape stairsshape = (StairsShape)state.func_177229_b(SHAPE);
        switch (mirror) {
            case LEFT_RIGHT: {
                if (enumfacing.func_176740_k() != EnumFacing.Axis.Z) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (IBlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case INNER_RIGHT: {
                        return (IBlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case OUTER_LEFT: {
                        return (IBlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (IBlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                }
                return state.func_185907_a(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (enumfacing.func_176740_k() != EnumFacing.Axis.X) break;
                switch (stairsshape) {
                    case STRAIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180);
                    }
                    case INNER_LEFT: {
                        return (IBlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return (IBlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case OUTER_LEFT: {
                        return (IBlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (IBlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                }
                break;
            }
            case NONE: {
                return super.func_185471_a(state, mirror);
            }
        }
        return super.func_185471_a(state, mirror);
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING, HALF, SHAPE, WATERLOGGED});
    }

    public Fluid func_204508_a(IWorld world, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            world.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            return Fluids.field_204546_a;
        }
        return Fluids.field_204541_a;
    }

    public IFluidState func_204507_t(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204510_a(IBlockReader world, BlockPos pos, IBlockState state, Fluid fluid) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) == false && fluid == Fluids.field_204546_a;
    }

    public boolean func_204509_a(IWorld world, BlockPos pos, IBlockState state, IFluidState fluidState) {
        if (!((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue() && fluidState.func_206886_c() == Fluids.field_204546_a) {
            if (!world.func_201670_d()) {
                world.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                world.func_205219_F_().func_205360_a(pos, (Object)fluidState.func_206886_c(), fluidState.func_206886_c().func_205569_a((IWorldReaderBase)world));
            }
            return true;
        }
        return false;
    }

    public boolean func_196266_a(IBlockState state, IBlockReader world, BlockPos pos, PathType type) {
        return false;
    }

    @Override
    public IBlockState getConvertedState(IBlockState vanillaState) {
        return (IBlockState)((IBlockState)((IBlockState)((IBlockState)this.func_176223_P().func_206870_a((IProperty)FACING, vanillaState.func_177229_b((IProperty)BlockStairs.field_176309_a))).func_206870_a(HALF, vanillaState.func_177229_b((IProperty)BlockStairs.field_176308_b))).func_206870_a(SHAPE, vanillaState.func_177229_b((IProperty)BlockStairs.field_176310_M))).func_206870_a((IProperty)WATERLOGGED, vanillaState.func_177229_b((IProperty)BlockStairs.field_204513_t));
    }
}

