/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.compat.top;

import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IBlockDisplayOverride;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.INameable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.blocks.BlockKeypad;
import net.geforcemods.securitycraft.compat.IOverlayDisplay;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.tileentity.TileEntityKeycardReader;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;

public class TOPDataProvider
implements Function<ITheOneProbe, Void> {
    private final String formatting = TextFormatting.BLUE.toString() + TextFormatting.ITALIC.toString();

    @Override
    @Nullable
    public Void apply(ITheOneProbe theOneProbe) {
        theOneProbe.registerBlockDisplayOverride(new IBlockDisplayOverride(){

            public boolean overrideStandardInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
                if (blockState.func_177230_c() instanceof BlockKeypad) {
                    ItemStack disguisedAs = BlockKeypad.getDisguisedStack((IBlockReader)world, data.getPos());
                    probeInfo.horizontal().item(disguisedAs).vertical().itemLabel(disguisedAs).text(TOPDataProvider.this.formatting + ((ModContainer)ModList.get().getModContainerById(disguisedAs.func_77973_b().getRegistryName().func_110624_b()).get()).getModInfo().getDisplayName());
                    return true;
                }
                return false;
            }
        });
        theOneProbe.registerProvider(new IProbeInfoProvider(){

            public String getID() {
                return "securitycraft:securitycraft";
            }

            public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
                Block block = blockState.func_177230_c();
                if (block instanceof IOverlayDisplay && !((IOverlayDisplay)block).shouldShowSCInfo(world, blockState, data.getPos())) {
                    return;
                }
                TileEntity te = world.func_175625_s(data.getPos());
                if (te instanceof IOwnable) {
                    probeInfo.vertical().text(TextFormatting.GRAY + ClientUtils.localize("waila.securitycraft:owner", new Object[0]) + " " + ((IOwnable)te).getOwner().getName());
                }
                if (te instanceof CustomizableSCTE && ((CustomizableSCTE)te).getOwner().isOwner(player) && !((CustomizableSCTE)te).getModules().isEmpty()) {
                    probeInfo.text(TextFormatting.GRAY + ClientUtils.localize("waila.securitycraft:equipped", new Object[0]));
                    for (EnumCustomModules module : ((CustomizableSCTE)te).getModules()) {
                        probeInfo.text(TextFormatting.GRAY + "- " + module.getName());
                    }
                }
                if (te instanceof IPasswordProtected && !(te instanceof TileEntityKeycardReader) && ((IOwnable)te).getOwner().isOwner(player)) {
                    String password = ((IPasswordProtected)te).getPassword();
                    probeInfo.text(TextFormatting.GRAY + ClientUtils.localize("waila.securitycraft:password", new Object[0]) + " " + (password != null && !password.isEmpty() ? password : ClientUtils.localize("waila.securitycraft:password.notSet", new Object[0])));
                }
                if (te instanceof INameable && ((INameable)te).canBeNamed()) {
                    String name = ((INameable)te).getCustomSCName().toString();
                    probeInfo.text(TextFormatting.GRAY + ClientUtils.localize("waila.securitycraft:customName", new Object[0]) + " " + (((INameable)te).hasCustomSCName() ? name : ClientUtils.localize("waila.securitycraft:customName.notSet", new Object[0])));
                }
            }
        });
        return null;
    }
}

