/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.blocks.BlockSecurityCamera;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.misc.KeyBindings;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.network.client.SetPlayerPositionAndRotation;
import net.geforcemods.securitycraft.network.server.GivePotionEffect;
import net.geforcemods.securitycraft.network.server.SetCameraPowered;
import net.geforcemods.securitycraft.network.server.SetCameraRotation;
import net.geforcemods.securitycraft.tileentity.TileEntitySecurityCamera;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class EntitySecurityCamera
extends Entity {
    private final double CAMERA_SPEED;
    public int blockPosX;
    public int blockPosY;
    public int blockPosZ;
    private double cameraUseX;
    private double cameraUseY;
    private double cameraUseZ;
    private float cameraUseYaw;
    private float cameraUsePitch;
    private int id;
    private int screenshotCooldown;
    private int redstoneCooldown;
    private int toggleNightVisionCooldown;
    private int toggleLightCooldown;
    private boolean shouldProvideNightVision;
    private float zoomAmount;
    private String playerViewingName;

    public EntitySecurityCamera(World world) {
        super(SCContent.eTypeSecurityCamera, world);
        this.CAMERA_SPEED = (Double)ConfigHandler.CommonConfig.CONFIG.cameraSpeed.get();
        this.screenshotCooldown = 0;
        this.redstoneCooldown = 0;
        this.toggleNightVisionCooldown = 0;
        this.toggleLightCooldown = 0;
        this.shouldProvideNightVision = false;
        this.zoomAmount = 1.0f;
        this.playerViewingName = null;
        this.field_70145_X = true;
        this.field_70131_O = 1.0E-4f;
        this.field_70130_N = 1.0E-4f;
    }

    public EntitySecurityCamera(World world, double x, double y, double z, int id, EntityPlayer player) {
        this(world);
        this.blockPosX = (int)x;
        this.blockPosY = (int)y;
        this.blockPosZ = (int)z;
        this.cameraUseX = player.field_70165_t;
        this.cameraUseY = player.field_70163_u;
        this.cameraUseZ = player.field_70161_v;
        this.cameraUseYaw = player.field_70177_z;
        this.cameraUsePitch = player.field_70125_A;
        this.id = id;
        this.playerViewingName = player.func_200200_C_().func_150254_d();
        this.func_70107_b(x + 0.5, y, z + 0.5);
        TileEntity te = world.func_175625_s(this.func_180425_c());
        if (te instanceof TileEntitySecurityCamera) {
            this.setInitialPitchYaw((TileEntitySecurityCamera)te);
        }
    }

    public EntitySecurityCamera(World world, double x, double y, double z, int id, EntitySecurityCamera camera) {
        this(world);
        this.blockPosX = (int)x;
        this.blockPosY = (int)y;
        this.blockPosZ = (int)z;
        this.cameraUseX = camera.cameraUseX;
        this.cameraUseY = camera.cameraUseY;
        this.cameraUseZ = camera.cameraUseZ;
        this.cameraUseYaw = camera.cameraUseYaw;
        this.cameraUsePitch = camera.cameraUsePitch;
        this.id = id;
        this.playerViewingName = camera.playerViewingName;
        this.func_70107_b(x + 0.5, y, z + 0.5);
        TileEntity te = world.func_175625_s(this.func_180425_c());
        if (te instanceof TileEntitySecurityCamera) {
            this.setInitialPitchYaw((TileEntitySecurityCamera)te);
        }
    }

    private void setInitialPitchYaw(TileEntitySecurityCamera te) {
        if (te != null && te.hasModule(EnumCustomModules.SMART) && te.lastPitch != Float.MAX_VALUE && te.lastYaw != Float.MAX_VALUE) {
            this.field_70125_A = te.lastPitch;
            this.field_70177_z = te.lastYaw;
        } else {
            this.field_70125_A = 30.0f;
            EnumFacing facing = BlockUtils.getBlockPropertyAsEnum(this.field_70170_p, BlockUtils.toPos((int)Math.floor(this.field_70165_t), (int)this.field_70163_u, (int)Math.floor(this.field_70161_v)), BlockSecurityCamera.FACING);
            if (facing == EnumFacing.NORTH) {
                this.field_70177_z = 180.0f;
            } else if (facing == EnumFacing.WEST) {
                this.field_70177_z = 90.0f;
            } else if (facing == EnumFacing.SOUTH) {
                this.field_70177_z = 0.0f;
            } else if (facing == EnumFacing.EAST) {
                this.field_70177_z = 270.0f;
            } else if (facing == EnumFacing.DOWN) {
                this.field_70125_A = 75.0f;
            }
        }
    }

    public double func_70042_X() {
        return (double)this.field_70131_O * -7500.0;
    }

    protected boolean func_142008_O() {
        return false;
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return false;
    }

    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K && this.func_184207_aI()) {
            EntityPlayer lowestEntity = (EntityPlayer)this.func_184188_bt().get(0);
            if (this.screenshotCooldown > 0) {
                --this.screenshotCooldown;
            }
            if (this.redstoneCooldown > 0) {
                --this.redstoneCooldown;
            }
            if (this.toggleNightVisionCooldown > 0) {
                --this.toggleNightVisionCooldown;
            }
            if (this.toggleLightCooldown > 0) {
                --this.toggleLightCooldown;
            }
            if (lowestEntity.field_70177_z != this.field_70177_z) {
                lowestEntity.func_70080_a(lowestEntity.field_70165_t, lowestEntity.field_70163_u, lowestEntity.field_70161_v, this.field_70177_z, this.field_70125_A);
                lowestEntity.field_70177_z = this.field_70177_z;
            }
            if (lowestEntity.field_70125_A != this.field_70125_A) {
                lowestEntity.func_70080_a(lowestEntity.field_70165_t, lowestEntity.field_70163_u, lowestEntity.field_70161_v, this.field_70177_z, this.field_70125_A);
            }
            this.checkKeysPressed();
            boolean isMiddleDown = (Boolean)ObfuscationReflectionHelper.getPrivateValue(MouseHelper.class, (Object)Minecraft.func_71410_x().field_71417_B, (int)2);
            if (isMiddleDown && this.screenshotCooldown == 0) {
                this.screenshotCooldown = 30;
                ClientUtils.takeScreenshot();
                Minecraft.func_71410_x().field_71441_e.func_184156_a(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(SCSounds.CAMERASNAP.location), SoundCategory.BLOCKS, 1.0f, 1.0f, true);
            }
            if (this.func_184188_bt().size() != 0 && this.shouldProvideNightVision) {
                SecurityCraft.channel.sendToServer((Object)new GivePotionEffect(Potion.func_188409_a((Potion)((Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation("night_vision")))), 3, -1));
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_184188_bt().size() == 0 | BlockUtils.getBlock(this.field_70170_p, this.blockPosX, this.blockPosY, this.blockPosZ) != SCContent.securityCamera) {
            this.func_70106_y();
            return;
        }
    }

    private void checkKeysPressed() {
        if (Minecraft.func_71410_x().field_71474_y.field_74311_E.func_151468_f()) {
            this.func_184210_p();
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74351_w.func_151470_d()) {
            this.moveViewUp();
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74368_y.func_151470_d()) {
            this.moveViewDown();
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74370_x.func_151470_d()) {
            this.moveViewLeft();
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74366_z.func_151470_d()) {
            this.moveViewRight();
        }
        if (KeyBindings.cameraEmitRedstone.func_151468_f() && this.redstoneCooldown == 0) {
            this.setRedstonePower();
            this.redstoneCooldown = 30;
        }
        if (KeyBindings.cameraActivateNightVision.func_151468_f() && this.toggleNightVisionCooldown == 0) {
            this.enableNightVision();
        }
        if (KeyBindings.cameraZoomIn.func_151468_f()) {
            this.zoomCameraView(-1);
        }
        if (KeyBindings.cameraZoomOut.func_151468_f()) {
            this.zoomCameraView(1);
        }
    }

    public void moveViewUp() {
        if (this.isCameraDown()) {
            if (this.field_70125_A > 40.0f) {
                this.field_70125_A = (float)((double)this.field_70125_A - this.CAMERA_SPEED);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            }
        } else if (this.field_70125_A > -25.0f) {
            this.field_70125_A = (float)((double)this.field_70125_A - this.CAMERA_SPEED);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
        this.updateServerRotation();
    }

    public void moveViewDown() {
        if (this.isCameraDown()) {
            if (this.field_70125_A < 100.0f) {
                this.field_70125_A = (float)((double)this.field_70125_A + this.CAMERA_SPEED);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            }
        } else if (this.field_70125_A < 60.0f) {
            this.field_70125_A = (float)((double)this.field_70125_A + this.CAMERA_SPEED);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
        this.updateServerRotation();
    }

    public void moveViewLeft() {
        if (BlockUtils.hasBlockProperty(this.field_70170_p, BlockUtils.toPos((int)Math.floor(this.field_70165_t), (int)this.field_70163_u, (int)Math.floor(this.field_70161_v)), BlockSecurityCamera.FACING)) {
            EnumFacing facing = BlockUtils.getBlockPropertyAsEnum(this.field_70170_p, BlockUtils.toPos((int)Math.floor(this.field_70165_t), (int)this.field_70163_u, (int)Math.floor(this.field_70161_v)), BlockSecurityCamera.FACING);
            if (facing == EnumFacing.EAST) {
                if ((double)this.field_70177_z - this.CAMERA_SPEED > -180.0) {
                    this.field_70177_z = (float)((double)this.field_70177_z - this.CAMERA_SPEED);
                    this.func_70101_b(this.field_70177_z, this.field_70125_A);
                }
            } else if (facing == EnumFacing.WEST) {
                if ((double)this.field_70177_z - this.CAMERA_SPEED > 0.0) {
                    this.field_70177_z = (float)((double)this.field_70177_z - this.CAMERA_SPEED);
                    this.func_70101_b(this.field_70177_z, this.field_70125_A);
                }
            } else if (facing == EnumFacing.NORTH) {
                if ((double)this.field_70177_z - this.CAMERA_SPEED > 90.0 && (double)this.field_70177_z - this.CAMERA_SPEED < 185.0 || (double)this.field_70177_z - this.CAMERA_SPEED > -190.0 && (double)this.field_70177_z - this.CAMERA_SPEED < -90.0) {
                    this.field_70177_z = (float)((double)this.field_70177_z - this.CAMERA_SPEED);
                    this.func_70101_b(this.field_70177_z, this.field_70125_A);
                }
            } else if (facing == EnumFacing.SOUTH) {
                if ((double)this.field_70177_z - this.CAMERA_SPEED > -90.0) {
                    this.field_70177_z = (float)((double)this.field_70177_z - this.CAMERA_SPEED);
                    this.func_70101_b(this.field_70177_z, this.field_70125_A);
                }
            } else if (facing == EnumFacing.DOWN) {
                this.field_70177_z = (float)((double)this.field_70177_z - this.CAMERA_SPEED);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            }
            this.updateServerRotation();
        }
    }

    public void moveViewRight() {
        if (BlockUtils.hasBlockProperty(this.field_70170_p, BlockUtils.toPos((int)Math.floor(this.field_70165_t), (int)this.field_70163_u, (int)Math.floor(this.field_70161_v)), BlockSecurityCamera.FACING)) {
            EnumFacing facing = BlockUtils.getBlockPropertyAsEnum(this.field_70170_p, BlockUtils.toPos((int)Math.floor(this.field_70165_t), (int)this.field_70163_u, (int)Math.floor(this.field_70161_v)), BlockSecurityCamera.FACING);
            if (facing == EnumFacing.EAST) {
                if ((double)this.field_70177_z + this.CAMERA_SPEED < 0.0) {
                    this.field_70177_z = (float)((double)this.field_70177_z + this.CAMERA_SPEED);
                    this.func_70101_b(this.field_70177_z, this.field_70125_A);
                }
            } else if (facing == EnumFacing.WEST) {
                if ((double)this.field_70177_z + this.CAMERA_SPEED < 180.0) {
                    this.field_70177_z = (float)((double)this.field_70177_z + this.CAMERA_SPEED);
                    this.func_70101_b(this.field_70177_z, this.field_70125_A);
                }
            } else if (facing == EnumFacing.NORTH) {
                if ((double)this.field_70177_z + this.CAMERA_SPEED > 85.0 && (double)this.field_70177_z + this.CAMERA_SPEED < 185.0 || (double)this.field_70177_z + this.CAMERA_SPEED < -95.0 && (double)this.field_70177_z + this.CAMERA_SPEED > -180.0) {
                    this.field_70177_z = (float)((double)this.field_70177_z + this.CAMERA_SPEED);
                    this.func_70101_b(this.field_70177_z, this.field_70125_A);
                }
            } else if (facing == EnumFacing.SOUTH) {
                if ((double)this.field_70177_z + this.CAMERA_SPEED < 90.0) {
                    this.field_70177_z = (float)((double)this.field_70177_z + this.CAMERA_SPEED);
                    this.func_70101_b(this.field_70177_z, this.field_70125_A);
                }
            } else if (facing == EnumFacing.DOWN) {
                this.field_70177_z = (float)((double)this.field_70177_z + this.CAMERA_SPEED);
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
            }
            this.updateServerRotation();
        }
    }

    public void zoomCameraView(int zoom) {
        if (zoom > 0) {
            if (this.zoomAmount == -0.5f) {
                this.zoomAmount = 1.0f;
            } else if (this.zoomAmount == 1.0f) {
                this.zoomAmount = 2.0f;
            }
        } else if (zoom < 0) {
            if (this.zoomAmount == 2.0f) {
                this.zoomAmount = 1.0f;
            } else if (this.zoomAmount == 1.0f) {
                this.zoomAmount = -0.5f;
            }
        }
        Minecraft.func_71410_x().field_71441_e.func_184156_a(new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v), (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(SCSounds.CAMERAZOOMIN.location), SoundCategory.BLOCKS, 1.0f, 1.0f, true);
    }

    public void setRedstonePower() {
        BlockPos pos = BlockUtils.toPos((int)Math.floor(this.field_70165_t), (int)this.field_70163_u, (int)Math.floor(this.field_70161_v));
        if (((CustomizableSCTE)this.field_70170_p.func_175625_s(pos)).hasModule(EnumCustomModules.REDSTONE)) {
            SecurityCraft.channel.sendToServer((Object)new SetCameraPowered(pos, !BlockUtils.getBlockPropertyAsBoolean(this.field_70170_p, pos, BlockSecurityCamera.POWERED)));
        }
    }

    public void enableNightVision() {
        this.toggleNightVisionCooldown = 30;
        this.shouldProvideNightVision = !this.shouldProvideNightVision;
    }

    public String getCameraInfo() {
        String nowViewing = TextFormatting.UNDERLINE + "Now viewing camera #" + this.id + "\n\n";
        String pos = TextFormatting.YELLOW + "Pos: " + TextFormatting.RESET + "X: " + (int)Math.floor(this.field_70165_t) + " Y: " + (int)this.field_70163_u + " Z: " + (int)Math.floor(this.field_70161_v) + "\n";
        String riderName = ((Entity)this.func_184188_bt().get(0)).func_200200_C_().func_150254_d();
        String viewingFrom = this.func_184188_bt().size() != 0 && SecurityCraft.instance.hasUsePosition(riderName) ? TextFormatting.YELLOW + "Viewing from: " + TextFormatting.RESET + " X: " + (int)Math.floor((Double)SecurityCraft.instance.getUsePosition(riderName)[0]) + " Y: " + (int)Math.floor((Double)SecurityCraft.instance.getUsePosition(riderName)[1]) + " Z: " + (int)Math.floor((Double)SecurityCraft.instance.getUsePosition(riderName)[2]) : "";
        return nowViewing + pos + viewingFrom;
    }

    public float getZoomAmount() {
        return this.zoomAmount;
    }

    private void updateServerRotation() {
        SecurityCraft.channel.sendToServer((Object)new SetCameraRotation(this.field_70177_z, this.field_70125_A));
    }

    private boolean isCameraDown() {
        return this.field_70170_p.func_175625_s(this.func_180425_c()) instanceof TileEntitySecurityCamera && ((TileEntitySecurityCamera)this.field_70170_p.func_175625_s((BlockPos)this.func_180425_c())).down;
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.playerViewingName != null && PlayerUtils.isPlayerOnline(this.playerViewingName)) {
            EntityPlayer player = PlayerUtils.getPlayerFromName(this.playerViewingName);
            player.func_70634_a(this.cameraUseX, this.cameraUseY, this.cameraUseZ);
            SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (EntityPlayerMP)player), (Object)new SetPlayerPositionAndRotation(this.cameraUseX, this.cameraUseY, this.cameraUseZ, this.cameraUseYaw, this.cameraUsePitch));
        }
    }

    protected void func_70088_a() {
    }

    public void func_70014_b(NBTTagCompound tag) {
        tag.func_74768_a("CameraID", this.id);
        if (this.playerViewingName != null) {
            tag.func_74778_a("playerName", this.playerViewingName);
        }
        if (this.cameraUseX != 0.0) {
            tag.func_74780_a("cameraUseX", this.cameraUseX);
        }
        if (this.cameraUseY != 0.0) {
            tag.func_74780_a("cameraUseY", this.cameraUseY);
        }
        if (this.cameraUseZ != 0.0) {
            tag.func_74780_a("cameraUseZ", this.cameraUseZ);
        }
        if ((double)this.cameraUseYaw != 0.0) {
            tag.func_74780_a("cameraUseYaw", (double)this.cameraUseYaw);
        }
        if ((double)this.cameraUsePitch != 0.0) {
            tag.func_74780_a("cameraUsePitch", (double)this.cameraUsePitch);
        }
    }

    public void func_70037_a(NBTTagCompound tag) {
        this.id = tag.func_74762_e("CameraID");
        if (tag.func_74764_b("playerName")) {
            this.playerViewingName = tag.func_74779_i("playerName");
        }
        if (tag.func_74764_b("cameraUseX")) {
            this.cameraUseX = tag.func_74769_h("cameraUseX");
        }
        if (tag.func_74764_b("cameraUseY")) {
            this.cameraUseY = tag.func_74769_h("cameraUseY");
        }
        if (tag.func_74764_b("cameraUseZ")) {
            this.cameraUseZ = tag.func_74769_h("cameraUseZ");
        }
        if (tag.func_74764_b("cameraUseYaw")) {
            this.cameraUseYaw = tag.func_74760_g("cameraUseYaw");
        }
        if (tag.func_74764_b("cameraUsePitch")) {
            this.cameraUsePitch = tag.func_74760_g("cameraUsePitch");
        }
    }
}

