/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.entity;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.entity.EntityBullet;
import net.geforcemods.securitycraft.entity.ai.EntityAIAttackRangedIfEnabled;
import net.geforcemods.securitycraft.entity.ai.EntityAITargetNearestPlayerOrMob;
import net.geforcemods.securitycraft.items.ItemModule;
import net.geforcemods.securitycraft.network.client.InitSentryAnimation;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.PacketDistributor;

public class EntitySentry
extends EntityCreature
implements IRangedAttackMob {
    private static final DataParameter<Owner> OWNER = EntityDataManager.func_187226_a(EntitySentry.class, Owner.SERIALIZER);
    private static final DataParameter<NBTTagCompound> MODULE = EntityDataManager.func_187226_a(EntitySentry.class, (DataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<NBTTagCompound> WHITELIST = EntityDataManager.func_187226_a(EntitySentry.class, (DataSerializer)DataSerializers.field_192734_n);
    private static final DataParameter<Integer> MODE = EntityDataManager.func_187226_a(EntitySentry.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Float> HEAD_ROTATION = EntityDataManager.func_187226_a(EntitySentry.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final float MAX_TARGET_DISTANCE = 20.0f;
    private float headYTranslation = 0.9f;
    private final float animationStepSize = 0.025f;
    public boolean animateUpwards = true;
    public boolean animate = false;
    private long previousTargetId = Long.MIN_VALUE;
    private static Random notRandom = new NotRandom();

    public EntitySentry(World world) {
        super(SCContent.eTypeSentry, world);
        this.func_70105_a(1.0f, 1.0f);
    }

    public void setupSentry(EntityPlayer owner) {
        this.field_70180_af.func_187227_b(OWNER, (Object)new Owner(owner.func_200200_C_().func_150254_d(), EntityPlayer.func_146094_a((GameProfile)owner.func_146103_bH()).toString()));
        this.field_70180_af.func_187227_b(MODULE, (Object)new NBTTagCompound());
        this.field_70180_af.func_187227_b(WHITELIST, (Object)new NBTTagCompound());
        this.field_70180_af.func_187227_b(MODE, (Object)EnumSentryMode.CAMOUFLAGE.ordinal());
        this.field_70180_af.func_187227_b(HEAD_ROTATION, (Object)Float.valueOf(0.0f));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER, (Object)new Owner());
        this.field_70180_af.func_187214_a(MODULE, (Object)new NBTTagCompound());
        this.field_70180_af.func_187214_a(WHITELIST, (Object)new NBTTagCompound());
        this.field_70180_af.func_187214_a(MODE, (Object)EnumSentryMode.CAMOUFLAGE.ordinal());
        this.field_70180_af.func_187214_a(HEAD_ROTATION, (Object)Float.valueOf(0.0f));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackRangedIfEnabled(this, 0.0, 5, 10.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetNearestPlayerOrMob(this));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.animate) {
            if (this.animateUpwards && this.headYTranslation > 0.0f) {
                this.headYTranslation -= 0.025f;
                if (this.headYTranslation <= 0.0f) {
                    this.animateUpwards = false;
                    this.animate = false;
                }
            } else if (!this.animateUpwards && this.headYTranslation < 0.9f) {
                this.headYTranslation += 0.025f;
                if (this.headYTranslation >= 0.9f) {
                    this.animateUpwards = true;
                    this.animate = false;
                }
            }
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.getOwner().isOwner(player) && hand == EnumHand.MAIN_HAND) {
            player.func_71053_j();
            if (player.func_70093_af()) {
                this.func_70106_y();
            } else if (player.func_184614_ca().func_77973_b() == SCContent.disguiseModule) {
                ItemStack module = this.getDisguiseModule();
                if (!module.func_190926_b()) {
                    Block.func_180635_a((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (ItemStack)module);
                }
                this.setDisguiseModule(player.func_184614_ca());
                if (!player.func_184812_l_()) {
                    player.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                }
            } else if (player.func_184614_ca().func_77973_b() == SCContent.whitelistModule) {
                ItemStack module = this.getWhitelistModule();
                if (!module.func_190926_b()) {
                    Block.func_180635_a((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (ItemStack)module);
                }
                this.setWhitelistModule(player.func_184614_ca());
                if (!player.func_184812_l_()) {
                    player.func_184201_a(EntityEquipmentSlot.MAINHAND, ItemStack.field_190927_a);
                }
            } else if (player.func_184614_ca().func_77973_b() == SCContent.universalBlockModifier) {
                this.field_70170_p.func_175698_g(this.func_180425_c());
                Block.func_180635_a((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (ItemStack)this.getDisguiseModule());
                Block.func_180635_a((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (ItemStack)this.getWhitelistModule());
                this.field_70180_af.func_187227_b(MODULE, (Object)new NBTTagCompound());
                this.field_70180_af.func_187227_b(WHITELIST, (Object)new NBTTagCompound());
            } else {
                this.toggleMode(player);
            }
            player.func_184609_a(EnumHand.MAIN_HAND);
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void func_70106_y() {
        super.func_70106_y();
        Block.func_180635_a((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (ItemStack)new ItemStack((IItemProvider)SCContent.sentry));
        Block.func_180635_a((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (ItemStack)this.getDisguiseModule());
        Block.func_180635_a((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (ItemStack)this.getWhitelistModule());
        this.field_70170_p.func_175656_a(this.func_180425_c(), Blocks.field_150350_a.func_176223_P());
    }

    public void func_174812_G() {
        this.func_70106_y();
    }

    public void toggleMode(EntityPlayer player) {
        int mode = (Integer)this.field_70180_af.func_187225_a(MODE) + 1;
        if (mode == 3) {
            mode = 0;
        }
        this.field_70180_af.func_187227_b(MODE, (Object)mode);
        if (player.field_70170_p.field_72995_K) {
            if (mode == 0) {
                this.animateUpwards = true;
                this.animate = true;
            } else if (mode == 1) {
                this.animateUpwards = false;
                this.animate = true;
            }
            PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize(SCContent.sentry.func_77658_a(), new Object[0]), ClientUtils.localize("messages.securitycraft:sentry.mode" + (mode + 1), new Object[0]), TextFormatting.DARK_RED);
        }
    }

    public void func_70624_b(EntityLivingBase target) {
        if (this.getMode() != EnumSentryMode.AGGRESSIVE && (target == null && this.previousTargetId != Long.MIN_VALUE || target != null && this.previousTargetId != (long)target.func_145782_y())) {
            this.animateUpwards = this.getMode() == EnumSentryMode.CAMOUFLAGE && target != null;
            this.animate = true;
            SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new InitSentryAnimation(this.func_180425_c(), this.animate, this.animateUpwards));
        }
        this.previousTargetId = target == null ? Long.MIN_VALUE : (long)target.func_145782_y();
        super.func_70624_b(target);
    }

    public float func_70047_e() {
        return 1.5f;
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        if (target instanceof EntityPlayer && (((EntityPlayer)target).func_175149_v() || ((EntityPlayer)target).func_184812_l_())) {
            return;
        }
        if (this.func_70068_e((Entity)target) > 400.0) {
            return;
        }
        EntityBullet throwableEntity = new EntityBullet(this.field_70170_p, (EntityLivingBase)this);
        double y = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f;
        double x = target.field_70165_t - this.field_70165_t;
        double d2 = y - throwableEntity.field_70163_u;
        double z = target.field_70161_v - this.field_70161_v;
        float f = MathHelper.func_76133_a((double)(x * x + z * z)) * 0.2f;
        this.field_70180_af.func_187227_b(HEAD_ROTATION, (Object)Float.valueOf((float)(MathHelper.func_181159_b((double)x, (double)(-z)) * 57.29577951308232)));
        throwableEntity.func_70186_c(x, d2 + (double)f, z, 1.6f, 0.0f);
        this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 1.0f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.field_70170_p.func_72838_d((Entity)throwableEntity);
    }

    public void func_70014_b(NBTTagCompound tag) {
        tag.func_74782_a("TileEntityData", (INBTBase)this.getOwnerTag());
        tag.func_74782_a("InstalledModule", (INBTBase)this.getDisguiseModule().func_77955_b(new NBTTagCompound()));
        tag.func_74782_a("InstalledWhitelist", (INBTBase)this.getWhitelistModule().func_77955_b(new NBTTagCompound()));
        tag.func_74768_a("SentryMode", ((Integer)this.field_70180_af.func_187225_a(MODE)).intValue());
        tag.func_74776_a("HeadRotation", ((Float)this.field_70180_af.func_187225_a(HEAD_ROTATION)).floatValue());
        super.func_70014_b(tag);
    }

    private NBTTagCompound getOwnerTag() {
        NBTTagCompound tag = new NBTTagCompound();
        Owner owner = (Owner)this.field_70180_af.func_187225_a(OWNER);
        tag.func_74778_a("owner", owner.getName());
        tag.func_74778_a("ownerUUID", owner.getUUID());
        return tag;
    }

    public void func_70037_a(NBTTagCompound tag) {
        NBTTagCompound teTag = tag.func_74775_l("TileEntityData");
        String name = teTag.func_74779_i("owner");
        String uuid = teTag.func_74779_i("ownerUUID");
        this.field_70180_af.func_187227_b(OWNER, (Object)new Owner(name, uuid));
        this.field_70180_af.func_187227_b(MODULE, (Object)((NBTTagCompound)tag.func_74781_a("InstalledModule")));
        this.field_70180_af.func_187227_b(WHITELIST, (Object)((NBTTagCompound)tag.func_74781_a("InstalledWhitelist")));
        this.field_70180_af.func_187227_b(MODE, (Object)tag.func_74762_e("SentryMode"));
        this.field_70180_af.func_187227_b(HEAD_ROTATION, (Object)Float.valueOf(tag.func_74760_g("HeadRotation")));
        super.func_70037_a(tag);
    }

    public Owner getOwner() {
        return (Owner)this.field_70180_af.func_187225_a(OWNER);
    }

    public void setDisguiseModule(ItemStack module) {
        ArrayList<ItemStack> blocks = ((ItemModule)module.func_77973_b()).getAddons(module.func_77978_p());
        if (blocks.size() > 0) {
            ItemStack disguiseStack = (ItemStack)blocks.get(0);
            IBlockState state = Block.func_149634_a((Item)disguiseStack.func_77973_b()).func_176223_P();
            this.field_70170_p.func_175656_a(this.func_180425_c(), state.func_185917_h() ? state : Blocks.field_150350_a.func_176223_P());
        }
        this.field_70180_af.func_187227_b(MODULE, (Object)module.func_77955_b(new NBTTagCompound()));
    }

    public void setWhitelistModule(ItemStack module) {
        this.field_70180_af.func_187227_b(WHITELIST, (Object)module.func_77955_b(new NBTTagCompound()));
    }

    public ItemStack getDisguiseModule() {
        NBTTagCompound tag = (NBTTagCompound)this.field_70180_af.func_187225_a(MODULE);
        if (tag == null || tag.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        return ItemStack.func_199557_a((NBTTagCompound)tag);
    }

    public ItemStack getWhitelistModule() {
        NBTTagCompound tag = (NBTTagCompound)this.field_70180_af.func_187225_a(WHITELIST);
        if (tag == null || tag.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        return ItemStack.func_199557_a((NBTTagCompound)tag);
    }

    public EnumSentryMode getMode() {
        int mode = (Integer)this.field_70180_af.func_187225_a(MODE);
        return mode < 0 || mode > 2 ? EnumSentryMode.CAMOUFLAGE : EnumSentryMode.values()[mode];
    }

    public float getHeadYTranslation() {
        return this.headYTranslation;
    }

    public boolean isTargetingWhitelistedPlayer(EntityLivingBase potentialTarget) {
        List<String> players = ModuleUtils.getPlayersFromModule(this.getWhitelistModule());
        for (String s : players) {
            if (potentialTarget != PlayerUtils.getPlayerFromName(s)) continue;
            return true;
        }
        return false;
    }

    public boolean func_70652_k(Entity entity) {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public boolean func_70075_an() {
        return false;
    }

    public boolean func_190631_cK() {
        return false;
    }

    public boolean func_205020_a(IWorld world, boolean aBoolean) {
        return false;
    }

    public void func_70664_aZ() {
    }

    public boolean func_70781_l() {
        return false;
    }

    protected void func_70623_bb() {
    }

    public boolean func_70692_ba() {
        return false;
    }

    public void func_70100_b_(EntityPlayer entity) {
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
    }

    protected void func_82167_n(Entity entity) {
    }

    protected void func_85033_bc() {
    }

    public boolean func_180427_aV() {
        return true;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70104_M() {
        return false;
    }

    public EnumPushReaction func_184192_z() {
        return EnumPushReaction.IGNORE;
    }

    public void func_110159_bB() {
    }

    public void func_184724_a(boolean swingingArms) {
    }

    public Random func_70681_au() {
        return notRandom;
    }

    public static enum EnumSentryMode {
        AGGRESSIVE,
        CAMOUFLAGE,
        IDLE;

    }

    private static class NotRandom
    extends Random {
        private NotRandom() {
        }

        @Override
        public int nextInt(int bound) {
            return 0;
        }
    }
}

