/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.fluids;

import java.util.Random;
import javax.annotation.Nullable;
import net.geforcemods.securitycraft.SCContent;
import net.minecraft.block.BlockFlowingFluid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class FakeLavaFluid
extends FlowingFluid {
    public Fluid func_210197_e() {
        return SCContent.flowingFakeLava;
    }

    public Fluid func_210198_f() {
        return SCContent.fakeLava;
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.SOLID;
    }

    public Item func_204524_b() {
        return SCContent.fLavaBucket;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_204522_a(World world, BlockPos pos, IFluidState state, Random random) {
        BlockPos blockpos = pos.func_177984_a();
        if (world.func_180495_p(blockpos).func_196958_f() && !world.func_180495_p(blockpos).func_200015_d((IBlockReader)world, blockpos)) {
            if (random.nextInt(100) == 0) {
                double x = (float)pos.func_177958_n() + random.nextFloat();
                double y = pos.func_177956_o() + 1;
                double z = (float)pos.func_177952_p() + random.nextFloat();
                world.func_195594_a((IParticleData)Particles.field_197595_F, x, y, z, 0.0, 0.0, 0.0);
                world.func_184134_a(x, y, z, SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
            }
            if (random.nextInt(200) == 0) {
                world.func_184134_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187656_cX, SoundCategory.BLOCKS, 0.2f + random.nextFloat() * 0.2f, 0.9f + random.nextFloat() * 0.15f, false);
            }
        }
    }

    public void func_207186_b(World world, BlockPos pos, IFluidState state, Random random) {
        block7: {
            if (!world.func_82736_K().func_82766_b("doFireTick")) break block7;
            int i = random.nextInt(3);
            if (i > 0) {
                BlockPos blockpos = pos;
                for (int j = 0; j < i; ++j) {
                    if (!world.func_195588_v(blockpos = blockpos.func_177982_a(random.nextInt(3) - 1, 1, random.nextInt(3) - 1))) {
                        return;
                    }
                    IBlockState iblockstate = world.func_180495_p(blockpos);
                    if (iblockstate.func_196958_f()) {
                        if (!this.isSurroundingBlockFlammable((IWorldReaderBase)world, blockpos)) continue;
                        world.func_175656_a(blockpos, Blocks.field_150480_ab.func_176223_P());
                        return;
                    }
                    if (!iblockstate.func_185904_a().func_76230_c()) continue;
                    return;
                }
            } else {
                for (int k = 0; k < 3; ++k) {
                    BlockPos blockpos1 = pos.func_177982_a(random.nextInt(3) - 1, 0, random.nextInt(3) - 1);
                    if (!world.func_195588_v(blockpos1)) {
                        return;
                    }
                    if (!world.func_175623_d(blockpos1.func_177984_a()) || !this.getCanBlockBurn((IWorldReaderBase)world, blockpos1)) continue;
                    world.func_175656_a(blockpos1.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
                }
            }
        }
    }

    private boolean isSurroundingBlockFlammable(IWorldReaderBase world, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!this.getCanBlockBurn(world, pos.func_177972_a(enumfacing))) continue;
            return true;
        }
        return false;
    }

    private boolean getCanBlockBurn(IWorldReaderBase world, BlockPos pos) {
        return pos.func_177956_o() >= 0 && pos.func_177956_o() < 256 && !world.func_175667_e(pos) ? false : world.func_180495_p(pos).func_185904_a().func_76217_h();
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public IParticleData func_204521_c() {
        return Particles.field_197617_j;
    }

    protected void func_205580_a(IWorld world, BlockPos pos, IBlockState state) {
        this.triggerEffects(world, pos);
    }

    public int func_185698_b(IWorldReaderBase world) {
        return world.func_201675_m().func_177500_n() ? 4 : 2;
    }

    public IBlockState func_204527_a(IFluidState state) {
        return (IBlockState)SCContent.fakeLavaBlock.func_176223_P().func_206870_a((IProperty)BlockFlowingFluid.field_176367_b, (Comparable)Integer.valueOf(FakeLavaFluid.func_207205_e((IFluidState)state)));
    }

    public boolean func_207187_a(Fluid fluid) {
        return fluid == SCContent.fakeLava || fluid == SCContent.flowingFakeLava;
    }

    public int func_204528_b(IWorldReaderBase world) {
        return world.func_201675_m().func_177500_n() ? 1 : 2;
    }

    public boolean func_211757_a(IFluidState state, Fluid fluid, EnumFacing direction) {
        return state.func_206885_f() >= 0.44444445f && fluid.func_207185_a(FluidTags.field_206959_a);
    }

    public int func_205569_a(IWorldReaderBase world) {
        return world.func_201675_m().func_177495_o() ? 10 : 30;
    }

    public int func_205578_a(World world, IFluidState p_205578_2_, IFluidState p_205578_3_) {
        int i = this.func_205569_a((IWorldReaderBase)world);
        if (!(p_205578_2_.func_206888_e() || p_205578_3_.func_206888_e() || ((Boolean)p_205578_2_.func_177229_b((IProperty)field_207209_a)).booleanValue() || ((Boolean)p_205578_3_.func_177229_b((IProperty)field_207209_a)).booleanValue() || !(p_205578_3_.func_206885_f() > p_205578_2_.func_206885_f()) || world.func_201674_k().nextInt(4) == 0)) {
            i *= 4;
        }
        return i;
    }

    protected void triggerEffects(IWorld p_205581_1_, BlockPos p_205581_2_) {
        double x = p_205581_2_.func_177958_n();
        double y = p_205581_2_.func_177956_o();
        double z = p_205581_2_.func_177952_p();
        p_205581_1_.func_184133_a((EntityPlayer)null, p_205581_2_, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 2.6f + (p_205581_1_.func_201674_k().nextFloat() - p_205581_1_.func_201674_k().nextFloat()) * 0.8f);
        for (int i = 0; i < 8; ++i) {
            p_205581_1_.func_195594_a((IParticleData)Particles.field_197594_E, x + Math.random(), y + 1.2, z + Math.random(), 0.0, 0.0, 0.0);
        }
    }

    protected boolean func_205579_d() {
        return false;
    }

    protected void func_205574_a(IWorld world, BlockPos pos, IBlockState blockState, EnumFacing direction, IFluidState fluidState) {
        if (direction == EnumFacing.DOWN) {
            IFluidState ifluidstate = world.func_204610_c(pos);
            if (this.func_207185_a(FluidTags.field_206960_b) && ifluidstate.func_206884_a(FluidTags.field_206959_a)) {
                if (blockState.func_177230_c() instanceof BlockFlowingFluid) {
                    world.func_180501_a(pos, Blocks.field_150348_b.func_176223_P(), 3);
                }
                this.triggerEffects(world, pos);
                return;
            }
        }
        super.func_205574_a(world, pos, blockState, direction, fluidState);
    }

    protected boolean func_207196_h() {
        return true;
    }

    protected float func_210195_d() {
        return 100.0f;
    }

    public static class Source
    extends FakeLavaFluid {
        public int func_207192_d(IFluidState state) {
            return 8;
        }

        public boolean func_207193_c(IFluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends FakeLavaFluid {
        protected void func_207184_a(StateContainer.Builder<Fluid, IFluidState> builder) {
            super.func_207184_a(builder);
            builder.func_206894_a(new IProperty[]{field_207210_b});
        }

        public int func_207192_d(IFluidState state) {
            return (Integer)state.func_177229_b((IProperty)field_207210_b);
        }

        public boolean func_207193_c(IFluidState state) {
            return false;
        }
    }
}

