/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.gui;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.containers.ContainerCustomizeBlock;
import net.geforcemods.securitycraft.gui.components.GuiButtonClick;
import net.geforcemods.securitycraft.gui.components.GuiPictureButton;
import net.geforcemods.securitycraft.gui.components.NamedSlider;
import net.geforcemods.securitycraft.network.server.ToggleOption;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.config.HoverChecker;

@OnlyIn(value=Dist.CLIENT)
public class GuiCustomizeBlock
extends GuiContainer {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("securitycraft:textures/gui/container/customize1.png"), new ResourceLocation("securitycraft:textures/gui/container/customize2.png"), new ResourceLocation("securitycraft:textures/gui/container/customize3.png")};
    private static final List<Rectangle2d> EXTRA_AREAS = new ArrayList<Rectangle2d>();
    private CustomizableSCTE tileEntity;
    private GuiPictureButton[] descriptionButtons = new GuiPictureButton[5];
    private GuiButton[] optionButtons = new GuiButton[5];
    private HoverChecker[] hoverCheckers = new HoverChecker[10];
    private final String blockName;

    public GuiCustomizeBlock(InventoryPlayer inventory, CustomizableSCTE te) {
        super((Container)new ContainerCustomizeBlock(inventory, te));
        this.tileEntity = te;
        this.blockName = BlockUtils.getBlock((World)Minecraft.func_71410_x().field_71441_e, this.tileEntity.func_174877_v()).func_149739_a().substring(5);
    }

    public void func_73866_w_() {
        int i;
        super.func_73866_w_();
        for (i = 0; i < this.tileEntity.getNumberOfCustomizableOptions(); ++i) {
            this.descriptionButtons[i] = new GuiPictureButton(i, this.field_147003_i + 130, this.field_147009_r + 10 + i * 25, 20, 20, this.field_146296_j, new ItemStack((IItemProvider)this.tileEntity.acceptedModules()[i].getItem()));
            this.func_189646_b(this.descriptionButtons[i]);
            this.hoverCheckers[i] = new HoverChecker((GuiButton)this.descriptionButtons[i], 20);
        }
        if (this.tileEntity.customOptions() != null) {
            for (i = 0; i < this.tileEntity.customOptions().length; ++i) {
                Option<?> option = this.tileEntity.customOptions()[i];
                if (option instanceof Option.OptionDouble && ((Option.OptionDouble)option).isSlider()) {
                    this.optionButtons[i] = new NamedSlider((ClientUtils.localize("option" + this.blockName + "." + option.getName(), new Object[0]) + " ").replace("#", option.toString()), this.blockName, i, this.field_147003_i + 178, this.field_147009_r + 10 + i * 25, 120, 20, "", "", (Double)((Option.OptionDouble)option).getMin(), (Double)((Option.OptionDouble)option).getMax(), ((Option.OptionDouble)option).getValue(), true, true, (Option.OptionDouble)option);
                    this.optionButtons[i].packedFGColor = 0xE0E0E0;
                } else {
                    this.optionButtons[i] = new GuiButtonClick(i, this.field_147003_i + 178, this.field_147009_r + 10 + i * 25, 120, 20, this.getOptionButtonTitle(option), this::actionPerformed);
                    this.optionButtons[i].packedFGColor = option.toString().equals(option.getDefaultValue().toString()) ? 0xFFFFA0 : 0xE0E0E0;
                }
                this.func_189646_b(this.optionButtons[i]);
                this.hoverCheckers[i + this.tileEntity.getNumberOfCustomizableOptions()] = new HoverChecker(this.optionButtons[i], 20);
            }
        }
        for (GuiButton button : this.optionButtons) {
            if (button == null) continue;
            EXTRA_AREAS.add(new Rectangle2d(button.field_146128_h, button.field_146129_i, button.func_146117_b(), button.field_146121_g));
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.getSlotUnderMouse() != null && !this.getSlotUnderMouse().func_75211_c().func_190926_b()) {
            this.func_146285_a(this.getSlotUnderMouse().func_75211_c(), mouseX, mouseY);
        }
        for (int i = 0; i < this.hoverCheckers.length; ++i) {
            if (this.hoverCheckers[i] == null || !this.hoverCheckers[i].checkHover(mouseX, mouseY)) continue;
            if (i < this.tileEntity.getNumberOfCustomizableOptions()) {
                this.drawHoveringText(this.field_146297_k.field_71466_p.func_78271_c(this.getModuleDescription(i), 150), mouseX, mouseY, this.field_146297_k.field_71466_p);
                continue;
            }
            this.drawHoveringText(this.field_146297_k.field_71466_p.func_78271_c(this.getOptionDescription(i), 150), mouseX, mouseY, this.field_146297_k.field_71466_p);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = this.tileEntity.hasCustomSCName() ? this.tileEntity.func_200200_C_().func_150254_d() : ClientUtils.localize(this.tileEntity.func_200200_C_().func_150254_d(), new Object[0]);
        this.field_146289_q.func_211126_b(s, (float)(this.field_146999_f / 2 - this.field_146289_q.func_78256_a(s) / 2), 6.0f, 0x404040);
        this.field_146289_q.func_211126_b(ClientUtils.localize("container.inventory", new Object[0]), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURES[this.tileEntity.getNumberOfCustomizableOptions() - 1]);
        int startX = (this.field_146294_l - this.field_146999_f) / 2;
        int startY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void actionPerformed(GuiButton button) {
        if (!(button instanceof GuiPictureButton)) {
            Option<?> tempOption = this.tileEntity.customOptions()[button.field_146127_k];
            tempOption.toggle();
            button.packedFGColor = tempOption.toString().equals(tempOption.getDefaultValue().toString()) ? 0xFFFFA0 : 0xE0E0E0;
            button.field_146126_j = this.getOptionButtonTitle(tempOption);
            SecurityCraft.channel.sendToServer((Object)new ToggleOption(this.tileEntity.func_174877_v().func_177958_n(), this.tileEntity.func_174877_v().func_177956_o(), this.tileEntity.func_174877_v().func_177952_p(), button.field_146127_k));
        }
    }

    private String getModuleDescription(int buttonID) {
        String moduleDescription = "module" + this.blockName + "." + this.descriptionButtons[buttonID].getItemStack().func_77658_a().substring(5).replace("securitycraft.", "") + ".description";
        return ClientUtils.localize(this.descriptionButtons[buttonID].getItemStack().func_77658_a(), new Object[0]) + ":" + TextFormatting.RESET + "\n\n" + ClientUtils.localize(moduleDescription, new Object[0]);
    }

    private String getOptionDescription(int buttonID) {
        String optionDescription = "option" + this.blockName + "." + this.tileEntity.customOptions()[buttonID - this.tileEntity.getNumberOfCustomizableOptions()].getName() + ".description";
        return ClientUtils.localize(optionDescription, new Object[0]);
    }

    private String getOptionButtonTitle(Option<?> option) {
        return (ClientUtils.localize("option" + this.blockName + "." + option.getName(), new Object[0]) + " ").replace("#", option.toString());
    }

    public List<Rectangle2d> getGuiExtraAreas() {
        return EXTRA_AREAS;
    }
}

