/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.gui;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.containers.ContainerGeneric;
import net.geforcemods.securitycraft.gui.components.GuiButtonClick;
import net.geforcemods.securitycraft.tileentity.TileEntityIMS;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiIMS
extends GuiContainer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/blank.png");
    private TileEntityIMS tileEntity;
    private GuiButton targetButton;
    private int targetingOptionIndex = 0;

    public GuiIMS(TileEntityIMS te) {
        super((Container)new ContainerGeneric());
        this.tileEntity = te;
        this.targetingOptionIndex = this.tileEntity.getTargetingOption().modeIndex;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.targetButton = new GuiButtonClick(0, this.field_146294_l / 2 - 38, this.field_146295_m / 2 - 58, 120, 20, this.tileEntity.getTargetingOption() == TileEntityIMS.EnumIMSTargetingMode.PLAYERS_AND_MOBS ? ClientUtils.localize("gui.securitycraft:ims.hostileAndPlayers", new Object[0]) : ClientUtils.localize("tooltip.securitycraft:module.players", new Object[0]), this::actionPerformed);
        this.func_189646_b(this.targetButton);
        this.updateButtonText();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_211126_b(ClientUtils.localize(SCContent.ims.func_149739_a(), new Object[0]), (float)(this.field_146999_f / 2 - this.field_146289_q.func_78256_a(ClientUtils.localize(SCContent.ims.func_149739_a(), new Object[0])) / 2), 6.0f, 0x404040);
        this.field_146289_q.func_211126_b(ClientUtils.localize("gui.securitycraft:ims.target", new Object[0]), (float)(this.field_146999_f / 2 - 78), 30.0f, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int startX = (this.field_146294_l - this.field_146999_f) / 2;
        int startY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void actionPerformed(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                ++this.targetingOptionIndex;
                if (this.targetingOptionIndex > 1) {
                    this.targetingOptionIndex = 0;
                }
                this.tileEntity.setTargetingOption(TileEntityIMS.EnumIMSTargetingMode.values()[this.targetingOptionIndex]);
                ClientUtils.syncTileEntity(this.tileEntity);
                this.updateButtonText();
            }
        }
    }

    private void updateButtonText() {
        if (TileEntityIMS.EnumIMSTargetingMode.values()[this.targetingOptionIndex] == TileEntityIMS.EnumIMSTargetingMode.PLAYERS) {
            this.targetButton.field_146126_j = ClientUtils.localize("tooltip.securitycraft:module.playerCustomization.players", new Object[0]);
        } else if (TileEntityIMS.EnumIMSTargetingMode.values()[this.targetingOptionIndex] == TileEntityIMS.EnumIMSTargetingMode.PLAYERS_AND_MOBS) {
            this.targetButton.field_146126_j = ClientUtils.localize("gui.securitycraft:ims.hostileAndPlayers", new Object[0]);
        }
    }
}

