/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.gui;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.containers.ContainerInventoryScanner;
import net.geforcemods.securitycraft.gui.components.GuiButtonClick;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.network.server.SetScanType;
import net.geforcemods.securitycraft.tileentity.TileEntityInventoryScanner;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiInventoryScanner
extends GuiContainer {
    private static final ResourceLocation regularInventory = new ResourceLocation("securitycraft:textures/gui/container/inventory_scanner_gui.png");
    private static final ResourceLocation exhancedInventory = new ResourceLocation("securitycraft:textures/gui/container/inventory_scanner_enhanced_gui.png");
    private TileEntityInventoryScanner tileEntity;
    private EntityPlayer playerObj;
    private boolean hasStorageModule = false;

    public GuiInventoryScanner(IInventory inventory, TileEntityInventoryScanner te, EntityPlayer player) {
        super((Container)new ContainerInventoryScanner(inventory, te));
        this.tileEntity = te;
        this.playerObj = player;
        this.hasStorageModule = te.hasModule(EnumCustomModules.STORAGE);
        this.field_146999_f = this.hasStorageModule ? 236 : 176;
        this.field_147000_g = 196;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146297_k.field_195559_v.func_197967_a(true);
        if (this.tileEntity.getOwner().isOwner(this.playerObj)) {
            this.func_189646_b((GuiButton)new GuiButtonClick(0, this.field_146294_l / 2 - 83 - (this.hasStorageModule ? 28 : 0), this.field_146295_m / 2 - 63, 166, 20, this.tileEntity.getScanType().contains("check") ? ClientUtils.localize("gui.securitycraft:invScan.checkInv", new Object[0]) : ClientUtils.localize("gui.securitycraft:invScan.emitRedstone", new Object[0]), this::actionPerformed));
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179140_f();
        if (!this.field_146292_n.isEmpty()) {
            this.field_146289_q.func_211126_b(ClientUtils.localize("gui.securitycraft:invScan.explanation.1", new Object[0]), (float)(this.field_146294_l / 2 - 83 - (this.hasStorageModule ? 28 : 0)), (float)(this.field_146295_m / 2 - 38), 0x404040);
            this.field_146289_q.func_211126_b(ClientUtils.localize("gui.securitycraft:invScan.explanation.2", new Object[0]), (float)(this.field_146294_l / 2 - 83 - (this.hasStorageModule ? 28 : 0)), (float)(this.field_146295_m / 2 - 28), 0x404040);
            if (((GuiButton)this.field_146292_n.get((int)0)).field_146126_j.equals(ClientUtils.localize("gui.securitycraft:invScan.checkInv", new Object[0]))) {
                this.field_146289_q.func_211126_b(ClientUtils.localize("gui.securitycraft:invScan.explanation.checkInv.3", new Object[0]), (float)(this.field_146294_l / 2 - 83 - (this.hasStorageModule ? 28 : 0)), (float)(this.field_146295_m / 2 - 18), 0x404040);
                this.field_146289_q.func_211126_b(ClientUtils.localize("gui.securitycraft:invScan.explanation.checkInv.4", new Object[0]), (float)(this.field_146294_l / 2 - 83 - (this.hasStorageModule ? 28 : 0)), (float)(this.field_146295_m / 2 - 8), 0x404040);
            } else {
                this.field_146289_q.func_211126_b(ClientUtils.localize("gui.securitycraft:invScan.explanation.emitRedstone.3", new Object[0]), (float)(this.field_146294_l / 2 - 83 - (this.hasStorageModule ? 28 : 0)), (float)(this.field_146295_m / 2 - 18), 0x404040);
                this.field_146289_q.func_211126_b(ClientUtils.localize("gui.securitycraft:invScan.explanation.emitRedstone.4", new Object[0]), (float)(this.field_146294_l / 2 - 83 - (this.hasStorageModule ? 28 : 0)), (float)(this.field_146295_m / 2 - 8), 0x404040);
            }
        } else if (this.tileEntity.getScanType() != null && this.tileEntity.getScanType() != "") {
            this.field_146289_q.func_211126_b(ClientUtils.localize("gui.securitycraft:invScan.setTo", new Object[0]), (float)(this.field_146294_l / 2 - 83), (float)(this.field_146295_m / 2 - 61), 0x404040);
            this.field_146289_q.func_211126_b(this.tileEntity.getScanType().equals("check") ? ClientUtils.localize("gui.securitycraft:invScan.checkInv", new Object[0]) : ClientUtils.localize("gui.securitycraft:invScan.emitRedstone", new Object[0]), (float)(this.field_146294_l / 2 - 83), (float)(this.field_146295_m / 2 - 51), 0x404040);
        }
        if (this.getSlotUnderMouse() != null && !this.getSlotUnderMouse().func_75211_c().func_190926_b()) {
            this.func_146285_a(this.getSlotUnderMouse().func_75211_c(), mouseX, mouseY);
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.field_146297_k.field_195559_v.func_197967_a(false);
    }

    protected void actionPerformed(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                if (button.field_146126_j.equals(ClientUtils.localize("gui.securitycraft:invScan.checkInv", new Object[0]))) {
                    button.field_146126_j = ClientUtils.localize("gui.securitycraft:invScan.emitRedstone", new Object[0]);
                } else if (button.field_146126_j.equals(ClientUtils.localize("gui.securitycraft:invScan.emitRedstone", new Object[0]))) {
                    button.field_146126_j = ClientUtils.localize("gui.securitycraft:invScan.checkInv", new Object[0]);
                }
                this.saveType(button.field_146126_j.equals(ClientUtils.localize("gui.securitycraft:invScan.checkInv", new Object[0])) ? "check" : "redstone");
            }
        }
    }

    private void saveType(String type) {
        this.tileEntity.setScanType(type);
        SecurityCraft.channel.sendToServer((Object)new SetScanType(this.tileEntity.func_174877_v().func_177958_n(), this.tileEntity.func_174877_v().func_177956_o(), this.tileEntity.func_174877_v().func_177952_p(), type));
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_211126_b("Prohibited Items", 8.0f, 6.0f, 0x404040);
        this.field_146289_q.func_211126_b(this.tileEntity.getOwner().isOwner(this.playerObj) ? TextFormatting.UNDERLINE + ClientUtils.localize("gui.securitycraft:invScan.mode.admin", new Object[0]) : TextFormatting.UNDERLINE + ClientUtils.localize("gui.securitycraft:invScan.mode.view", new Object[0]), 112.0f, 6.0f, 0x404040);
        if (this.hasStorageModule && this.tileEntity.getOwner().isOwner(this.playerObj)) {
            this.field_146289_q.func_211126_b("Storage", 183.0f, 6.0f, 0x404040);
        }
        this.field_146289_q.func_211126_b(ClientUtils.localize("container.inventory", new Object[0]), 8.0f, (float)(this.field_147000_g - 93), 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.hasStorageModule) {
            this.field_146297_k.func_110434_K().func_110577_a(exhancedInventory);
        } else {
            this.field_146297_k.func_110434_K().func_110577_a(regularInventory);
        }
        int startX = (this.field_146294_l - this.field_146999_f) / 2;
        int startY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g + 30);
    }
}

