/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.gui;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.TileEntitySCTE;
import net.geforcemods.securitycraft.gui.components.StackHoverChecker;
import net.geforcemods.securitycraft.gui.components.StringHoverChecker;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.GuiUtils;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.crafting.VanillaRecipeTypes;
import net.minecraftforge.fml.client.config.HoverChecker;

@OnlyIn(value=Dist.CLIENT)
public class GuiSCManual
extends GuiScreen {
    private ResourceLocation infoBookTexture = new ResourceLocation("securitycraft:textures/gui/info_book_texture.png");
    private ResourceLocation infoBookTextureSpecial = new ResourceLocation("securitycraft:textures/gui/info_book_texture_special.png");
    private ResourceLocation infoBookTitlePage = new ResourceLocation("securitycraft:textures/gui/info_book_title_page.png");
    private ResourceLocation infoBookIcons = new ResourceLocation("securitycraft:textures/gui/info_book_icons.png");
    private static ResourceLocation bookGuiTextures = new ResourceLocation("textures/gui/book.png");
    private List<HoverChecker> hoverCheckers = new ArrayList<HoverChecker>();
    private static int lastPage = -1;
    private int currentPage = lastPage;
    private NonNullList<Ingredient> recipe;
    private int startX = -1;
    private boolean update = false;
    private List<String> subpages = new ArrayList<String>();
    private int currentSubpage = 0;
    private final int subpageLength = 1285;

    public void func_73866_w_() {
        int startY = 2;
        if ((this.field_146294_l - 256) / 2 != this.startX && this.startX != -1) {
            this.update = true;
        }
        this.startX = (this.field_146294_l - 256) / 2;
        this.field_146297_k.field_195559_v.func_197967_a(true);
        this.func_189646_b(new ChangePageButton(1, this.startX + 210, startY + 158, true, this::actionPerformed));
        this.func_189646_b(new ChangePageButton(2, this.startX + 16, startY + 158, false, this::actionPerformed));
        this.func_189646_b(new ChangePageButton(3, this.startX + 190, startY + 97, true, this::actionPerformed));
        this.func_189646_b(new ChangePageButton(4, this.startX + 165, startY + 97, false, this::actionPerformed));
        this.updateRecipeAndIcons();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.update) {
            this.updateRecipeAndIcons();
            this.update = false;
        }
        if (this.currentPage == -1) {
            this.field_146297_k.func_110434_K().func_110577_a(this.infoBookTitlePage);
        } else if (this.recipe != null || SecurityCraft.instance.manualPages.get(this.currentPage).isRecipeDisabled()) {
            this.field_146297_k.func_110434_K().func_110577_a(this.infoBookTexture);
        } else {
            this.field_146297_k.func_110434_K().func_110577_a(this.infoBookTextureSpecial);
        }
        this.func_73729_b(this.startX, 5, 0, 0, 256, 250);
        if (this.currentPage > -1) {
            if (SecurityCraft.instance.manualPages.get(this.currentPage).getHelpInfo().equals("help.securitycraft:reinforced.info")) {
                this.field_146289_q.func_211126_b(ClientUtils.localize("gui.securitycraft:scManual.reinforced", new Object[0]), (float)(this.startX + 39), 27.0f, 0);
            } else {
                this.field_146289_q.func_211126_b(ClientUtils.localize(SecurityCraft.instance.manualPages.get(this.currentPage).getItem().func_77658_a(), new Object[0]), (float)(this.startX + 39), 27.0f, 0);
            }
            this.field_146289_q.func_78279_b(this.subpages.get(this.currentSubpage), this.startX + 18, 45, 225, 0);
            String designedBy = SecurityCraft.instance.manualPages.get(this.currentPage).getDesignedBy();
            if (designedBy != null && !designedBy.isEmpty()) {
                this.field_146289_q.func_78279_b(ClientUtils.localize("gui.securitycraft:scManual.designedBy", designedBy), this.startX + 18, 180, 75, 0);
            }
        } else {
            this.field_146289_q.func_211126_b(ClientUtils.localize("gui.securitycraft:scManual.intro.1", new Object[0]), (float)(this.startX + 39), 27.0f, 0);
            this.field_146289_q.func_211126_b(ClientUtils.localize("gui.securitycraft:scManual.intro.2", new Object[0]), (float)(this.startX + 60), 159.0f, 0);
            if (I18n.func_188566_a((String)"gui.securitycraft:scManual.author")) {
                this.field_146289_q.func_211126_b(ClientUtils.localize("gui.securitycraft:scManual.author", new Object[0]), (float)(this.startX + 65), 170.0f, 0);
            }
        }
        for (int i = 0; i < this.field_146292_n.size(); ++i) {
            ((GuiButton)this.field_146292_n.get(i)).func_194828_a(mouseX, mouseY, partialTicks);
        }
        if (this.currentPage > -1) {
            Block itemBlock;
            Item item = SecurityCraft.instance.manualPages.get(this.currentPage).getItem();
            GuiUtils.drawItemStackToGui(this.field_146297_k, item, this.startX + 19, 22, !(SecurityCraft.instance.manualPages.get(this.currentPage).getItem() instanceof ItemBlock));
            this.field_146297_k.func_110434_K().func_110577_a(this.infoBookIcons);
            TileEntity te = item instanceof ItemBlock && ((ItemBlock)item).func_179223_d() instanceof ITileEntityProvider ? ((ITileEntityProvider)((ItemBlock)item).func_179223_d()).func_196283_a_((IBlockReader)Minecraft.func_71410_x().field_71441_e) : null;
            Block block = itemBlock = item instanceof ItemBlock ? ((ItemBlock)item).func_179223_d() : null;
            if (itemBlock != null) {
                if (itemBlock instanceof IExplosive) {
                    this.func_73729_b(this.startX + 107, 117, 54, 1, 18, 18);
                }
                if (te != null) {
                    if (te instanceof IOwnable) {
                        this.func_73729_b(this.startX + 29, 118, 1, 1, 16, 16);
                    }
                    if (te instanceof IPasswordProtected) {
                        this.func_73729_b(this.startX + 55, 118, 18, 1, 17, 16);
                    }
                    if (te instanceof TileEntitySCTE && ((TileEntitySCTE)te).isActivatedByView()) {
                        this.func_73729_b(this.startX + 81, 118, 36, 1, 17, 16);
                    }
                    if (te instanceof CustomizableSCTE) {
                        this.func_73729_b(this.startX + 213, 118, 72, 1, 16, 16);
                    }
                }
            }
            if (this.recipe != null) {
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3 && i * 3 + j < this.recipe.size(); ++j) {
                        ItemStack[] matchingStacks = ((Ingredient)this.recipe.get(i * 3 + j)).func_193365_a();
                        if (matchingStacks.length == 0 || matchingStacks[0].func_190926_b()) continue;
                        GuiUtils.drawItemStackToGui(this.field_146297_k, matchingStacks[0].func_77973_b(), this.startX + 100 + j * 20, 144 + i * 20, !(matchingStacks[0].func_77973_b() instanceof ItemBlock));
                    }
                }
            }
            for (HoverChecker chc : this.hoverCheckers) {
                if (chc == null || !chc.checkHover(mouseX, mouseY)) continue;
                if (chc instanceof StackHoverChecker && !((StackHoverChecker)chc).getStack().func_190926_b()) {
                    this.func_146285_a(((StackHoverChecker)chc).getStack(), mouseX, mouseY);
                    continue;
                }
                if (!(chc instanceof StringHoverChecker) || ((StringHoverChecker)chc).getName() == null) continue;
                this.func_146279_a(((StringHoverChecker)chc).getName(), mouseX, mouseY);
            }
        }
    }

    public void func_146281_b() {
        super.func_146281_b();
        lastPage = this.currentPage;
        this.field_146297_k.field_195559_v.func_197967_a(false);
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (keyCode == 263) {
            this.previousSubpage();
        } else if (keyCode == 262) {
            this.nextSubpage();
        }
        return super.charTyped(typedChar, keyCode);
    }

    protected void actionPerformed(GuiButton button) {
        if (button.field_146127_k == 1) {
            this.nextPage();
        } else if (button.field_146127_k == 2) {
            this.previousPage();
        } else if (button.field_146127_k == 3) {
            this.nextSubpage();
        } else if (button.field_146127_k == 4) {
            this.previousSubpage();
        }
        ((GuiButton)this.field_146292_n.get((int)2)).field_146125_m = this.currentPage != -1 && this.subpages.size() > 0;
        ((GuiButton)this.field_146292_n.get((int)3)).field_146125_m = this.currentPage != -1 && this.subpages.size() > 0;
    }

    public boolean mouseScrolled(double aDouble) {
        super.mouseScrolled(aDouble);
        switch ((int)Math.signum(aDouble)) {
            case -1: {
                this.nextPage();
                break;
            }
            case 1: {
                this.previousPage();
            }
        }
        ((GuiButton)this.field_146292_n.get((int)2)).field_146125_m = this.currentPage != -1 && this.subpages.size() > 1;
        ((GuiButton)this.field_146292_n.get((int)3)).field_146125_m = this.currentPage != -1 && this.subpages.size() > 1;
        return true;
    }

    private void nextPage() {
        ++this.currentPage;
        if (this.currentPage > SecurityCraft.instance.manualPages.size() - 1) {
            this.currentPage = -1;
        }
        this.updateRecipeAndIcons();
    }

    private void previousPage() {
        --this.currentPage;
        if (this.currentPage < -1) {
            this.currentPage = SecurityCraft.instance.manualPages.size() - 1;
        }
        this.updateRecipeAndIcons();
    }

    private void nextSubpage() {
        ++this.currentSubpage;
        if (this.currentSubpage == this.subpages.size()) {
            this.currentSubpage = 0;
        }
    }

    private void previousSubpage() {
        --this.currentSubpage;
        if (this.currentSubpage == -1) {
            this.currentSubpage = this.subpages.size() - 1;
        }
    }

    private void updateRecipeAndIcons() {
        Block itemBlock;
        Item item;
        block26: {
            this.currentSubpage = 0;
            if (this.currentPage < 0) {
                this.recipe = null;
                this.hoverCheckers.clear();
                ((GuiButton)this.field_146292_n.get((int)2)).field_146125_m = false;
                ((GuiButton)this.field_146292_n.get((int)3)).field_146125_m = false;
                return;
            }
            this.hoverCheckers.clear();
            if (SecurityCraft.instance.manualPages.get(this.currentPage).hasCustomRecipe()) {
                this.recipe = SecurityCraft.instance.manualPages.get(this.currentPage).getRecipe();
            } else {
                for (IRecipe object : Minecraft.func_71410_x().field_71441_e.func_199532_z().getRecipes(VanillaRecipeTypes.CRAFTING)) {
                    int i;
                    NonNullList recipeItems;
                    ShapedRecipe recipe;
                    if (object instanceof ShapedRecipe) {
                        recipe = (ShapedRecipe)object;
                        if (!recipe.func_77571_b().func_190926_b() && recipe.func_77571_b().func_77973_b() == SecurityCraft.instance.manualPages.get(this.currentPage).getItem()) {
                            recipeItems = NonNullList.func_191197_a((int)recipe.func_192400_c().size(), (Object)Ingredient.field_193370_a);
                            for (i = 0; i < recipeItems.size(); ++i) {
                                recipeItems.set(i, recipe.func_192400_c().get(i));
                            }
                            this.recipe = recipeItems;
                            break;
                        }
                    } else if (object instanceof ShapelessRecipe && !(recipe = (ShapelessRecipe)object).func_77571_b().func_190926_b() && recipe.func_77571_b().func_77973_b() == SecurityCraft.instance.manualPages.get(this.currentPage).getItem()) {
                        recipeItems = NonNullList.func_191197_a((int)recipe.func_192400_c().size(), (Object)Ingredient.field_193370_a);
                        for (i = 0; i < recipeItems.size(); ++i) {
                            recipeItems.set(i, recipe.func_192400_c().get(i));
                        }
                        this.recipe = recipeItems;
                        break;
                    }
                    this.recipe = null;
                }
            }
            boolean reinforcedPage = SecurityCraft.instance.manualPages.get(this.currentPage).getHelpInfo().equals("help.securitycraft:reinforced.info");
            if (this.recipe != null && !reinforcedPage) {
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        if (i * 3 + j != this.recipe.size()) {
                            if (((Ingredient)this.recipe.get(i * 3 + j)).func_193365_a().length <= 0 || ((Ingredient)this.recipe.get(i * 3 + j)).func_193365_a()[0].func_190926_b()) continue;
                            this.hoverCheckers.add(new StackHoverChecker(144 + i * 20, 144 + i * 20 + 16, this.startX + 100 + j * 20, this.startX + 100 + j * 20 + 16, 20, ((Ingredient)this.recipe.get(i * 3 + j)).func_193365_a()[0]));
                            continue;
                        }
                        break block26;
                    }
                }
            } else if (SecurityCraft.instance.manualPages.get(this.currentPage).isRecipeDisabled()) {
                this.hoverCheckers.add(new StringHoverChecker(144, 200, this.startX + 100, this.startX + 100 + 40 + 16, 20, ClientUtils.localize("gui.securitycraft:scManual.disabled", new Object[0])));
            } else if (reinforcedPage) {
                this.recipe = null;
                this.hoverCheckers.add(new StringHoverChecker(144, 200, this.startX + 100, this.startX + 100 + 40 + 16, 20, ClientUtils.localize("gui.securitycraft:scManual.recipe.reinforced", new Object[0])));
            } else {
                String name = SecurityCraft.instance.manualPages.get(this.currentPage).getItem().getRegistryName().func_110623_a();
                this.hoverCheckers.add(new StringHoverChecker(144, 200, this.startX + 100, this.startX + 100 + 40 + 16, 20, ClientUtils.localize("gui.securitycraft:scManual.recipe." + name, new Object[0])));
            }
        }
        TileEntity te = (item = SecurityCraft.instance.manualPages.get(this.currentPage).getItem()) instanceof ItemBlock && ((ItemBlock)item).func_179223_d() instanceof ITileEntityProvider ? ((ITileEntityProvider)((ItemBlock)item).func_179223_d()).func_196283_a_((IBlockReader)Minecraft.func_71410_x().field_71441_e) : null;
        Block block = itemBlock = item instanceof ItemBlock ? ((ItemBlock)item).func_179223_d() : null;
        if (te != null) {
            if (te instanceof IOwnable) {
                this.hoverCheckers.add(new StringHoverChecker(118, 134, this.startX + 29, this.startX + 29 + 16, 20, ClientUtils.localize("gui.securitycraft:scManual.ownableBlock", new Object[0])));
            }
            if (te instanceof IPasswordProtected) {
                this.hoverCheckers.add(new StringHoverChecker(118, 134, this.startX + 55, this.startX + 55 + 16, 20, ClientUtils.localize("gui.securitycraft:scManual.passwordProtectedBlock", new Object[0])));
            }
            if (te instanceof TileEntitySCTE && ((TileEntitySCTE)te).isActivatedByView()) {
                this.hoverCheckers.add(new StringHoverChecker(118, 134, this.startX + 81, this.startX + 81 + 16, 20, ClientUtils.localize("gui.securitycraft:scManual.viewActivatedBlock", new Object[0])));
            }
            if (itemBlock instanceof IExplosive) {
                this.hoverCheckers.add(new StringHoverChecker(118, 134, this.startX + 107, this.startX + 107 + 16, 20, ClientUtils.localize("gui.securitycraft:scManual.explosiveBlock", new Object[0])));
            }
            if (te instanceof CustomizableSCTE) {
                this.hoverCheckers.add(new StringHoverChecker(118, 134, this.startX + 213, this.startX + 213 + 16, 20, ClientUtils.localize("gui.securitycraft:scManual.customizableBlock", new Object[0])));
            }
        }
        String helpInfo = ClientUtils.localize(SecurityCraft.instance.manualPages.get(this.currentPage).getHelpInfo(), new Object[0]);
        this.subpages.clear();
        while (this.field_146289_q.func_78256_a(helpInfo) > 1285) {
            String trimmed = this.field_146289_q.func_78269_a(helpInfo, 1285);
            trimmed = trimmed.trim().substring(0, trimmed.lastIndexOf(32)).trim();
            this.subpages.add(trimmed);
            helpInfo = helpInfo.replace(trimmed, "").trim();
        }
        this.subpages.add(helpInfo);
    }

    static class ChangePageButton
    extends GuiButton {
        private final boolean isForward;
        private Consumer<GuiButton> onClick;

        public ChangePageButton(int index, int xPos, int yPos, boolean forward, Consumer<GuiButton> onClick) {
            super(index, xPos, yPos, 23, 13, "");
            this.isForward = forward;
            this.onClick = onClick;
        }

        public void func_194829_a(double mouseX, double mouseY) {
            this.onClick.accept(this);
        }

        public void func_194828_a(int mouseX, int mouseY, float partialTicks) {
            if (this.field_146125_m) {
                boolean isHovering = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(bookGuiTextures);
                int textureX = 0;
                int textureY = 192;
                if (isHovering) {
                    textureX += 23;
                }
                if (!this.isForward) {
                    textureY += 13;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i, textureX, textureY, 23, 13);
            }
        }
    }
}

