/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.gui;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.containers.ContainerGeneric;
import net.geforcemods.securitycraft.gui.GuiHandler;
import net.geforcemods.securitycraft.gui.components.GuiButtonClick;
import net.geforcemods.securitycraft.network.server.OpenGui;
import net.geforcemods.securitycraft.network.server.SetPassword;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiSetPassword
extends GuiContainer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/blank.png");
    private TileEntity tileEntity;
    private char[] allowedChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '\b', '\u001b'};
    private String blockName;
    private GuiTextField keycodeTextbox;
    private boolean isInvalid = false;
    private GuiButton saveAndContinueButton;

    public GuiSetPassword(TileEntity tileEntity, Block block) {
        super((Container)new ContainerGeneric());
        this.tileEntity = tileEntity;
        this.blockName = ClientUtils.localize(block.func_149739_a(), new Object[0]);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146297_k.field_195559_v.func_197967_a(true);
        this.saveAndContinueButton = new GuiButtonClick(0, this.field_146294_l / 2 - 48, this.field_146295_m / 2 + 30 + 10, 100, 20, !this.isInvalid ? ClientUtils.localize("gui.securitycraft:keycardSetup.save", new Object[0]) : ClientUtils.localize("gui.securitycraft:password.invalidCode", new Object[0]), this::actionPerformed);
        this.func_189646_b(this.saveAndContinueButton);
        this.keycodeTextbox = new GuiTextField(1, this.field_146289_q, this.field_146294_l / 2 - 37, this.field_146295_m / 2 - 47, 77, 12);
        this.keycodeTextbox.func_146193_g(-1);
        this.keycodeTextbox.func_146204_h(-1);
        this.keycodeTextbox.func_146185_a(true);
        this.keycodeTextbox.func_146203_f(11);
        this.updateButtonText();
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.isInvalid = false;
        this.field_146297_k.field_195559_v.func_197967_a(false);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179140_f();
        this.keycodeTextbox.func_195608_a(mouseX, mouseY, partialTicks);
        this.func_73731_b(this.field_146289_q, "CODE:", this.field_146294_l / 2 - 67, this.field_146295_m / 2 - 47 + 2, 0x404040);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78279_b(this.blockName + " " + ClientUtils.localize("gui.securitycraft:password.setup", new Object[0]), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.blockName + " " + ClientUtils.localize("gui.securitycraft:password.setup", new Object[0])) / 2, 6, this.field_146999_f, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        int startX = (this.field_146294_l - this.field_146999_f) / 2;
        int startY = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(startX, startY, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (this.keycodeTextbox.func_146206_l() && this.isValidChar(typedChar)) {
            this.keycodeTextbox.charTyped(typedChar, keyCode);
            return true;
        }
        return super.charTyped(typedChar, keyCode);
    }

    private boolean isValidChar(char c) {
        for (int x = 1; x <= this.allowedChars.length; ++x) {
            if (c != this.allowedChars[x - 1]) continue;
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.keycodeTextbox.mouseClicked(mouseX, mouseY, mouseButton);
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    private void updateButtonText() {
        this.saveAndContinueButton.field_146126_j = !this.isInvalid ? ClientUtils.localize("gui.securitycraft:keycardSetup.save", new Object[0]) : ClientUtils.localize("gui.securitycraft:password.invalidCode", new Object[0]);
    }

    protected void actionPerformed(GuiButton button) {
        switch (button.field_146127_k) {
            case 0: {
                if (this.keycodeTextbox.func_146179_b().isEmpty()) {
                    this.isInvalid = true;
                    this.updateButtonText();
                    return;
                }
                ((IPasswordProtected)this.tileEntity).setPassword(this.keycodeTextbox.func_146179_b());
                SecurityCraft.channel.sendToServer((Object)new SetPassword(this.tileEntity.func_174877_v().func_177958_n(), this.tileEntity.func_174877_v().func_177956_o(), this.tileEntity.func_174877_v().func_177952_p(), this.keycodeTextbox.func_146179_b()));
                ClientUtils.closePlayerScreen();
                SecurityCraft.channel.sendToServer((Object)new OpenGui(GuiHandler.INSERT_PASSWORD, Minecraft.func_71410_x().field_71439_g.func_180425_c()));
            }
        }
    }
}

