/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.gui.GuiHandler;
import net.geforcemods.securitycraft.misc.CameraView;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.network.client.UpdateNBTTagOnClient;
import net.geforcemods.securitycraft.network.server.OpenGui;
import net.geforcemods.securitycraft.tileentity.TileEntitySecurityCamera;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.PacketDistributor;

public class ItemCameraMonitor
extends Item {
    public ItemCameraMonitor() {
        super(new Item.Properties().func_200916_a(SecurityCraft.groupSCTechnical).func_200917_a(1));
    }

    public EnumActionResult func_195939_a(ItemUseContext ctx) {
        return this.onItemUse(ctx.func_195999_j(), ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_195996_i(), ctx.func_196000_l(), ctx.func_195997_m(), ctx.func_195993_n(), ctx.func_195994_o());
    }

    public EnumActionResult onItemUse(EntityPlayer player, World world, BlockPos pos, ItemStack stack, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (BlockUtils.getBlock(world, pos) == SCContent.securityCamera && !PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)player)) {
                if (!((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(player) && !((TileEntitySecurityCamera)world.func_175625_s(pos)).hasModule(EnumCustomModules.SMART)) {
                    PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize(SCContent.cameraMonitor.func_77658_a(), new Object[0]), ClientUtils.localize("messages.securitycraft:cameraMonitor.cannotView", new Object[0]), TextFormatting.RED);
                    return EnumActionResult.SUCCESS;
                }
                if (player.field_71071_by.func_70448_g().func_77978_p() == null) {
                    player.field_71071_by.func_70448_g().func_77982_d(new NBTTagCompound());
                }
                CameraView view = new CameraView(pos, player.field_71093_bK.func_186068_a());
                if (this.isCameraAdded(player.field_71071_by.func_70448_g().func_77978_p(), view)) {
                    player.field_71071_by.func_70448_g().func_77978_p().func_82580_o(ItemCameraMonitor.getTagNameFromPosition(player.field_71071_by.func_70448_g().func_77978_p(), view));
                    PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize(SCContent.cameraMonitor.func_77658_a(), new Object[0]), ClientUtils.localize("messages.securitycraft:cameraMonitor.unbound", new Object[0]).replace("#", Utils.getFormattedCoordinates(pos)), TextFormatting.RED);
                    return EnumActionResult.SUCCESS;
                }
                for (int i = 1; i <= 30; ++i) {
                    if (player.field_71071_by.func_70448_g().func_77978_p().func_74764_b("Camera" + i)) continue;
                    player.field_71071_by.func_70448_g().func_77978_p().func_74778_a("Camera" + i, view.toNBTString());
                    PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize(SCContent.cameraMonitor.func_77658_a(), new Object[0]), ClientUtils.localize("messages.securitycraft:cameraMonitor.bound", new Object[0]).replace("#", Utils.getFormattedCoordinates(pos)), TextFormatting.GREEN);
                    break;
                }
                SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (EntityPlayerMP)player), (Object)new UpdateNBTTagOnClient(stack));
                return EnumActionResult.SUCCESS;
            }
        } else if (world.field_72995_K && (BlockUtils.getBlock(world, pos) != SCContent.securityCamera || PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)player))) {
            if (stack.func_77978_p() == null || stack.func_77978_p().isEmpty()) {
                PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize(SCContent.cameraMonitor.func_77658_a(), new Object[0]), ClientUtils.localize("messages.securitycraft:cameraMonitor.rightclickToView", new Object[0]), TextFormatting.RED);
                return EnumActionResult.SUCCESS;
            }
            SecurityCraft.channel.sendToServer((Object)new OpenGui(GuiHandler.CAMERA_MONITOR, pos));
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            if (!stack.func_77942_o() || !this.hasCameraAdded(stack.func_77978_p())) {
                PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize(SCContent.cameraMonitor.func_77658_a(), new Object[0]), ClientUtils.localize("messages.securitycraft:cameraMonitor.rightclickToView", new Object[0]), TextFormatting.RED);
                return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
            }
            SecurityCraft.channel.sendToServer((Object)new OpenGui(GuiHandler.CAMERA_MONITOR, player.func_180425_c()));
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (stack.func_77978_p() == null) {
            return;
        }
        tooltip.add((ITextComponent)new TextComponentString(TextFormatting.GRAY + ClientUtils.localize("tooltip.securitycraft:cameraMonitor", new Object[0]) + " " + this.getNumberOfCamerasBound(stack.func_77978_p()) + "/30"));
    }

    public static String getTagNameFromPosition(NBTTagCompound tag, CameraView view) {
        for (int i = 1; i <= 30; ++i) {
            String[] coords;
            if (!tag.func_74764_b("Camera" + i) || !view.checkCoordinates(coords = tag.func_74779_i("Camera" + i).split(" "))) continue;
            return "Camera" + i;
        }
        return "";
    }

    public int getSlotFromPosition(NBTTagCompound tag, CameraView view) {
        for (int i = 1; i <= 30; ++i) {
            String[] coords;
            if (!tag.func_74764_b("Camera" + i) || !view.checkCoordinates(coords = tag.func_74779_i("Camera" + i).split(" "))) continue;
            return i;
        }
        return -1;
    }

    public boolean hasCameraAdded(NBTTagCompound tag) {
        if (tag == null) {
            return false;
        }
        for (int i = 1; i <= 30; ++i) {
            if (!tag.func_74764_b("Camera" + i)) continue;
            return true;
        }
        return false;
    }

    public boolean isCameraAdded(NBTTagCompound tag, CameraView view) {
        for (int i = 1; i <= 30; ++i) {
            String[] coords;
            if (!tag.func_74764_b("Camera" + i) || !view.checkCoordinates(coords = tag.func_74779_i("Camera" + i).split(" "))) continue;
            return true;
        }
        return false;
    }

    public ArrayList<CameraView> getCameraPositions(NBTTagCompound tag) {
        ArrayList<CameraView> list = new ArrayList<CameraView>();
        for (int i = 1; i <= 30; ++i) {
            if (tag != null && tag.func_74764_b("Camera" + i)) {
                String[] coords = tag.func_74779_i("Camera" + i).split(" ");
                list.add(new CameraView(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2]), coords.length == 4 ? Integer.parseInt(coords[3]) : 0));
                continue;
            }
            list.add(null);
        }
        return list;
    }

    public int getNumberOfCamerasBound(NBTTagCompound tag) {
        if (tag == null) {
            return 0;
        }
        for (int i = 1; i <= 31; ++i) {
            if (tag.func_74764_b("Camera" + i)) continue;
            return i - 1;
        }
        return 0;
    }
}

