/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IExplosive;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.gui.GuiHandler;
import net.geforcemods.securitycraft.misc.BaseInteractionObject;
import net.geforcemods.securitycraft.network.client.UpdateNBTTagOnClient;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.fml.network.PacketDistributor;

public class ItemMineRemoteAccessTool
extends Item {
    public int listIndex = 0;

    public ItemMineRemoteAccessTool() {
        super(new Item.Properties().func_200916_a(SecurityCraft.groupSCTechnical).func_200917_a(1));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K && player instanceof EntityPlayerMP) {
            NetworkHooks.openGui((EntityPlayerMP)((EntityPlayerMP)player), (IInteractionObject)new BaseInteractionObject(GuiHandler.MRAT));
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    public EnumActionResult func_195939_a(ItemUseContext ctx) {
        return this.onItemUse(ctx.func_195999_j(), ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_195996_i(), ctx.func_196000_l(), ctx.func_195997_m(), ctx.func_195993_n(), ctx.func_195994_o());
    }

    public EnumActionResult onItemUse(EntityPlayer player, World world, BlockPos pos, ItemStack stack, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (BlockUtils.getBlock(world, pos) instanceof IExplosive) {
                if (!this.isMineAdded(stack, world, pos)) {
                    int availSlot = this.getNextAvaliableSlot(stack);
                    if (availSlot == 0) {
                        PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize(SCContent.remoteAccessMine.func_77658_a(), new Object[0]), ClientUtils.localize("messages.securitycraft:mrat.noSlots", new Object[0]), TextFormatting.RED);
                        return EnumActionResult.FAIL;
                    }
                    if (world.func_175625_s(pos) instanceof IOwnable && !((IOwnable)world.func_175625_s(pos)).getOwner().isOwner(player)) {
                        PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize(SCContent.remoteAccessMine.func_77658_a(), new Object[0]), ClientUtils.localize("messages.securitycraft:mrat.cantBind", new Object[0]), TextFormatting.RED);
                        return EnumActionResult.FAIL;
                    }
                    if (stack.func_77978_p() == null) {
                        stack.func_77982_d(new NBTTagCompound());
                    }
                    stack.func_77978_p().func_74783_a("mine" + availSlot, new int[]{BlockUtils.fromPos(pos)[0], BlockUtils.fromPos(pos)[1], BlockUtils.fromPos(pos)[2]});
                    SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (EntityPlayerMP)player), (Object)new UpdateNBTTagOnClient(stack));
                    PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize(SCContent.remoteAccessMine.func_77658_a(), new Object[0]), ClientUtils.localize("messages.securitycraft:mrat.bound", new Object[0]).replace("#", Utils.getFormattedCoordinates(pos)), TextFormatting.GREEN);
                } else {
                    this.removeTagFromItemAndUpdate(stack, pos, player);
                    PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize(SCContent.remoteAccessMine.func_77658_a(), new Object[0]), ClientUtils.localize("messages.securitycraft:mrat.unbound", new Object[0]).replace("#", Utils.getFormattedCoordinates(pos)), TextFormatting.RED);
                }
            } else if (player instanceof EntityPlayerMP) {
                NetworkHooks.openGui((EntityPlayerMP)((EntityPlayerMP)player), (IInteractionObject)new BaseInteractionObject(GuiHandler.MRAT));
            }
        }
        return EnumActionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (par1ItemStack.func_77978_p() == null) {
            return;
        }
        for (int i = 1; i <= 6; ++i) {
            if (par1ItemStack.func_77978_p().func_74759_k("mine" + i).length > 0) {
                int[] coords = par1ItemStack.func_77978_p().func_74759_k("mine" + i);
                if (coords[0] == 0 && coords[1] == 0 && coords[2] == 0) {
                    list.add((ITextComponent)new TextComponentString("---"));
                    continue;
                }
                list.add((ITextComponent)new TextComponentString(ClientUtils.localize("tooltip.securitycraft:mine", new Object[0]) + " " + i + ": X:" + coords[0] + " Y:" + coords[1] + " Z:" + coords[2]));
                continue;
            }
            list.add((ITextComponent)new TextComponentString("---"));
        }
    }

    private void removeTagFromItemAndUpdate(ItemStack stack, BlockPos pos, EntityPlayer player) {
        if (stack.func_77978_p() == null) {
            return;
        }
        for (int i = 1; i <= 6; ++i) {
            int[] coords;
            if (stack.func_77978_p().func_74759_k("mine" + i).length <= 0 || (coords = stack.func_77978_p().func_74759_k("mine" + i))[0] != pos.func_177958_n() || coords[1] != pos.func_177956_o() || coords[2] != pos.func_177952_p()) continue;
            stack.func_77978_p().func_74783_a("mine" + i, new int[]{0, 0, 0});
            SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (EntityPlayerMP)player), (Object)new UpdateNBTTagOnClient(stack));
            return;
        }
    }

    private boolean isMineAdded(ItemStack stack, World world, BlockPos pos) {
        if (stack.func_77978_p() == null) {
            return false;
        }
        for (int i = 1; i <= 6; ++i) {
            int[] coords;
            if (stack.func_77978_p().func_74759_k("mine" + i).length <= 0 || (coords = stack.func_77978_p().func_74759_k("mine" + i))[0] != pos.func_177958_n() || coords[1] != pos.func_177956_o() || coords[2] != pos.func_177952_p()) continue;
            return true;
        }
        return false;
    }

    private int getNextAvaliableSlot(ItemStack stack) {
        for (int i = 1; i <= 6; ++i) {
            if (stack.func_77978_p() == null) {
                return 1;
            }
            if (stack.func_77978_p().func_74759_k("mine" + i).length != 0 && (stack.func_77978_p().func_74759_k("mine" + i)[0] != 0 || stack.func_77978_p().func_74759_k("mine" + i)[1] != 0 || stack.func_77978_p().func_74759_k("mine" + i)[2] != 0)) continue;
            return i;
        }
        return 0;
    }
}

