/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.misc.BaseInteractionObject;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class ItemModule
extends Item {
    private final EnumCustomModules module;
    private final boolean nbtCanBeModified;
    private boolean canBeCustomized;
    private ResourceLocation guiToOpen;
    private int numberOfItemAddons;
    private int numberOfBlockAddons;

    public ItemModule(EnumCustomModules module, boolean nbtCanBeModified) {
        this(module, nbtCanBeModified, false, null, 0, 0);
    }

    public ItemModule(EnumCustomModules module, boolean nbtCanBeModified, boolean canBeCustomized, ResourceLocation guiToOpen) {
        this(module, nbtCanBeModified, canBeCustomized, guiToOpen, 0, 0);
    }

    public ItemModule(EnumCustomModules module, boolean nbtCanBeModified, boolean canBeCustomized, ResourceLocation guiToOpen, int itemAddons, int blockAddons) {
        super(new Item.Properties().func_200916_a(SecurityCraft.groupSCTechnical).func_200917_a(1));
        this.module = module;
        this.nbtCanBeModified = nbtCanBeModified;
        this.canBeCustomized = canBeCustomized;
        this.guiToOpen = guiToOpen;
        this.numberOfItemAddons = itemAddons;
        this.numberOfBlockAddons = blockAddons;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        try {
            if (!world.field_72995_K && this.canBeCustomized() && player instanceof EntityPlayerMP) {
                NetworkHooks.openGui((EntityPlayerMP)((EntityPlayerMP)player), (IInteractionObject)new BaseInteractionObject(this.guiToOpen));
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        if (this.nbtCanBeModified || this.canBeCustomized()) {
            list.add((ITextComponent)new TextComponentString(TextFormatting.GRAY + new TextComponentTranslation("tooltip.securitycraft:module.modifiable", new Object[0]).func_150254_d()));
        } else {
            list.add((ITextComponent)new TextComponentString(TextFormatting.GRAY + new TextComponentTranslation("tooltip.securitycraft:module.notModifiable", new Object[0]).func_150254_d()));
        }
        if (this.nbtCanBeModified) {
            list.add((ITextComponent)new TextComponentString(TextFormatting.GRAY + new TextComponentTranslation("tooltip.securitycraft:module.playerCustomization.usage", new Object[0]).func_150254_d()));
            list.add((ITextComponent)new TextComponentString(" "));
            list.add((ITextComponent)new TextComponentString(TextFormatting.GRAY + new TextComponentTranslation("tooltip.securitycraft:module.playerCustomization.players", new Object[0]).func_150254_d() + ":"));
            if (stack.func_77978_p() != null) {
                for (int i = 1; i <= 10; ++i) {
                    if (stack.func_77978_p().func_74779_i("Player" + i).isEmpty()) continue;
                    list.add((ITextComponent)new TextComponentString(TextFormatting.GRAY + stack.func_77978_p().func_74779_i("Player" + i)));
                }
            }
        }
        if (this.canBeCustomized()) {
            if (this.numberOfItemAddons > 0 && this.numberOfBlockAddons > 0) {
                list.add((ITextComponent)new TextComponentString(TextFormatting.GRAY + ClientUtils.localize("tooltip.securitycraft:module.itemAddons.usage.blocksAndItems", new Object[0]).replace("#blocks", this.numberOfBlockAddons + "").replace("#items", this.numberOfItemAddons + "")));
            }
            if (this.numberOfItemAddons > 0 && this.numberOfBlockAddons == 0) {
                list.add((ITextComponent)new TextComponentString(TextFormatting.GRAY + ClientUtils.localize("tooltip.securitycraft:module.itemAddons.usage.items", new Object[0]).replace("#", this.numberOfItemAddons + "")));
            }
            if (this.numberOfItemAddons == 0 && this.numberOfBlockAddons > 0) {
                list.add((ITextComponent)new TextComponentString(TextFormatting.GRAY + ClientUtils.localize("tooltip.securitycraft:module.itemAddons.usage.blocks", new Object[0]).replace("#", this.numberOfBlockAddons + "")));
            }
            if (this.getNumberOfAddons() > 0) {
                list.add((ITextComponent)new TextComponentString(" "));
                list.add((ITextComponent)new TextComponentString(TextFormatting.GRAY + ClientUtils.localize("tooltip.securitycraft:module.itemAddons.added", new Object[0]) + ":"));
                for (ItemStack addon : this.getAddons(stack.func_77978_p())) {
                    list.add((ITextComponent)new TextComponentString(TextFormatting.GRAY + "- " + ClientUtils.localize(addon.func_77977_a(), new Object[0])));
                }
            }
        }
    }

    public EnumCustomModules getModule() {
        return this.module;
    }

    public boolean canNBTBeModified() {
        return this.nbtCanBeModified;
    }

    public int getNumberOfAddons() {
        return this.numberOfItemAddons + this.numberOfBlockAddons;
    }

    public int getNumberOfItemAddons() {
        return this.numberOfItemAddons;
    }

    public int getNumberOfBlockAddons() {
        return this.numberOfBlockAddons;
    }

    public ArrayList<Item> getItemAddons(NBTTagCompound tag) {
        ArrayList<Item> list = new ArrayList<Item>();
        if (tag == null) {
            return list;
        }
        NBTTagList items = tag.func_150295_c("ItemInventory", 10);
        for (int i = 0; i < items.size(); ++i) {
            ItemStack stack;
            NBTTagCompound item = items.func_150305_b(i);
            int slot = item.func_74762_e("Slot");
            if (slot >= this.numberOfItemAddons || (stack = ItemStack.func_199557_a((NBTTagCompound)item)).func_77973_b() instanceof ItemBlock) continue;
            list.add(stack.func_77973_b());
        }
        return list;
    }

    public ArrayList<Block> getBlockAddons(NBTTagCompound tag) {
        ArrayList<Block> list = new ArrayList<Block>();
        if (tag == null) {
            return list;
        }
        NBTTagList items = tag.func_150295_c("ItemInventory", 10);
        for (int i = 0; i < items.size(); ++i) {
            ItemStack stack;
            NBTTagCompound item = items.func_150305_b(i);
            int slot = item.func_74762_e("Slot");
            if (slot >= this.numberOfBlockAddons || !((stack = ItemStack.func_199557_a((NBTTagCompound)item)).func_77973_b() instanceof ItemBlock)) continue;
            list.add(Block.func_149634_a((Item)stack.func_77973_b()));
        }
        return list;
    }

    public ArrayList<ItemStack> getAddons(NBTTagCompound tag) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (tag == null) {
            return list;
        }
        NBTTagList items = tag.func_150295_c("ItemInventory", 10);
        for (int i = 0; i < items.size(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            int slot = item.func_74762_e("Slot");
            if (slot >= this.numberOfBlockAddons) continue;
            list.add(ItemStack.func_199557_a((NBTTagCompound)item));
        }
        return list;
    }

    public boolean canBeCustomized() {
        return this.canBeCustomized;
    }
}

