/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blocks.reinforced.BlockReinforcedDoor;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ItemReinforcedDoor
extends Item {
    public ItemReinforcedDoor() {
        super(new Item.Properties().func_200916_a(SecurityCraft.groupSCDecoration));
    }

    public EnumActionResult func_195939_a(ItemUseContext ctx) {
        return this.onItemUse(ctx.func_195999_j(), ctx.func_195991_k(), ctx.func_195995_a(), ctx.func_195996_i(), ctx.func_196000_l(), ctx.func_195997_m(), ctx.func_195993_n(), ctx.func_195994_o(), ctx);
    }

    public EnumActionResult onItemUse(EntityPlayer player, World world, BlockPos pos, ItemStack stack, EnumFacing facing, float hitX, float hitY, float hitZ, ItemUseContext ctx) {
        if (world.field_72995_K) {
            return EnumActionResult.FAIL;
        }
        if (facing != EnumFacing.UP) {
            return EnumActionResult.FAIL;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!block.func_196253_a(world.func_180495_p(pos), new BlockItemUseContext(ctx))) {
            pos = pos.func_177972_a(facing);
        }
        if (player.func_175151_a(pos, facing, stack) && world.func_180495_p(pos.func_177977_b()).func_185896_q()) {
            EnumFacing angleFacing = EnumFacing.func_176733_a((double)player.field_70177_z);
            int offsetX = angleFacing.func_82601_c();
            int offsetZ = angleFacing.func_82599_e();
            boolean flag = offsetX < 0 && hitZ < 0.5f || offsetX > 0 && hitZ > 0.5f || offsetZ < 0 && hitX > 0.5f || offsetZ > 0 && hitX < 0.5f;
            ItemReinforcedDoor.placeDoor(world, pos, angleFacing, SCContent.reinforcedDoor, flag);
            SoundType soundtype = world.func_180495_p(pos).func_177230_c().getSoundType(world.func_180495_p(pos), (IWorldReader)world, pos, (Entity)player);
            world.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
            if (world.func_175625_s(pos) != null) {
                ((TileEntityOwnable)world.func_175625_s(pos)).getOwner().set(player.func_146103_bH().getId().toString(), player.func_200200_C_());
                ((TileEntityOwnable)world.func_175625_s(pos.func_177984_a())).getOwner().set(player.func_146103_bH().getId().toString(), player.func_200200_C_());
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public static void placeDoor(World world, BlockPos pos, EnumFacing facing, Block door, boolean isRightHinge) {
        boolean isLeftDoor;
        BlockPos left = pos.func_177972_a(facing.func_176746_e());
        BlockPos right = pos.func_177972_a(facing.func_176735_f());
        int rightNormalCubeAmount = (world.func_180495_p(right).func_185915_l() ? 1 : 0) + (world.func_180495_p(right.func_177984_a()).func_185915_l() ? 1 : 0);
        int leftNormalCubeAmount = (world.func_180495_p(left).func_185915_l() ? 1 : 0) + (world.func_180495_p(left.func_177984_a()).func_185915_l() ? 1 : 0);
        boolean isRightDoor = world.func_180495_p(right).func_177230_c() == door || world.func_180495_p(right.func_177984_a()).func_177230_c() == door;
        boolean bl = isLeftDoor = world.func_180495_p(left).func_177230_c() == door || world.func_180495_p(left.func_177984_a()).func_177230_c() == door;
        if ((!isRightDoor || isLeftDoor) && leftNormalCubeAmount <= rightNormalCubeAmount) {
            if (isLeftDoor && !isRightDoor || leftNormalCubeAmount < rightNormalCubeAmount) {
                isRightHinge = false;
            }
        } else {
            isRightHinge = true;
        }
        BlockPos blockAbove = pos.func_177984_a();
        boolean isAnyPowered = world.func_175640_z(pos) || world.func_175640_z(blockAbove);
        IBlockState state = (IBlockState)((IBlockState)((IBlockState)door.func_176223_P().func_206870_a((IProperty)BlockReinforcedDoor.FACING, (Comparable)facing)).func_206870_a(BlockReinforcedDoor.HINGE, (Comparable)(isRightHinge ? DoorHingeSide.RIGHT : DoorHingeSide.LEFT))).func_206870_a((IProperty)BlockReinforcedDoor.OPEN, (Comparable)Boolean.valueOf(isAnyPowered));
        world.func_180501_a(pos, (IBlockState)state.func_206870_a(BlockReinforcedDoor.HALF, (Comparable)DoubleBlockHalf.LOWER), 2);
        world.func_180501_a(blockAbove, (IBlockState)state.func_206870_a(BlockReinforcedDoor.HALF, (Comparable)DoubleBlockHalf.UPPER), 2);
        world.func_195593_d(pos, door);
        world.func_195593_d(blockAbove, door);
    }
}

