/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.models;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.blocks.BlockKeypad;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypad;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.registries.ForgeRegistries;

public class ModelDynamicBakedKeypad
implements IDynamicBakedModel {
    public static final ModelProperty<ResourceLocation> DISGUISED_BLOCK_RL = new ModelProperty();
    public static final ResourceLocation DEFAULT_STATE_RL = SCContent.keypad.getRegistryName();
    private IBakedModel oldModel;
    private TextureAtlasSprite particleTexture;

    public ModelDynamicBakedKeypad(IBakedModel oldModel) {
        this.oldModel = oldModel;
        this.particleTexture = oldModel.func_177554_e();
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public boolean func_177555_b() {
        return true;
    }

    public List<BakedQuad> getQuads(@Nullable IBlockState state, @Nullable EnumFacing side, Random rand, IModelData modelData) {
        IBakedModel model;
        Block block;
        ResourceLocation rl = (ResourceLocation)modelData.getData(DISGUISED_BLOCK_RL);
        if (rl != DEFAULT_STATE_RL && (block = (Block)ForgeRegistries.BLOCKS.getValue(rl)) != null && (model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(block.func_176223_P())) != null) {
            this.particleTexture = model.func_177554_e();
            return model.getQuads(state, side, rand, modelData);
        }
        this.particleTexture = this.oldModel.func_177554_e();
        return this.oldModel.getQuads(state, side, rand, modelData);
    }

    public TextureAtlasSprite func_177554_e() {
        return this.particleTexture;
    }

    public ItemOverrideList func_188617_f() {
        return null;
    }

    @Nonnull
    public IModelData getModelData(@Nonnull IWorldReader world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull IModelData tileData) {
        IBlockState disguisedState;
        Block block;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityKeypad && (block = ((TileEntityKeypad)te).func_195044_w().func_177230_c()) instanceof BlockKeypad && (disguisedState = ((BlockKeypad)block).getDisguisedBlockState((IBlockReader)world, pos)) != null) {
            tileData.setData(DISGUISED_BLOCK_RL, (Object)disguisedState.func_177230_c().getRegistryName());
            return tileData;
        }
        tileData.setData(DISGUISED_BLOCK_RL, (Object)DEFAULT_STATE_RL);
        return tileData;
    }
}

