/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.entity.EntityBouncingBetty;
import net.geforcemods.securitycraft.entity.EntityBullet;
import net.geforcemods.securitycraft.entity.EntityIMSBomb;
import net.geforcemods.securitycraft.entity.EntitySentry;
import net.geforcemods.securitycraft.misc.KeyBindings;
import net.geforcemods.securitycraft.network.IProxy;
import net.geforcemods.securitycraft.renderers.ItemKeypadChestRenderer;
import net.geforcemods.securitycraft.renderers.RenderBouncingBetty;
import net.geforcemods.securitycraft.renderers.RenderBullet;
import net.geforcemods.securitycraft.renderers.RenderIMSBomb;
import net.geforcemods.securitycraft.renderers.RenderSentry;
import net.geforcemods.securitycraft.renderers.TileEntityKeypadChestRenderer;
import net.geforcemods.securitycraft.renderers.TileEntitySecretSignRenderer;
import net.geforcemods.securitycraft.renderers.TileEntitySecurityCameraRenderer;
import net.geforcemods.securitycraft.renderers.TileEntityTrophySystemRenderer;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypadChest;
import net.geforcemods.securitycraft.tileentity.TileEntitySecretSign;
import net.geforcemods.securitycraft.tileentity.TileEntitySecurityCamera;
import net.geforcemods.securitycraft.tileentity.TileEntityTrophySystem;
import net.geforcemods.securitycraft.util.Reinforced;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="securitycraft", value={Dist.CLIENT})
public class ClientProxy
implements IProxy {
    private Map<Block, Integer> toTint = new HashMap<Block, Integer>();

    @Override
    public void clientSetup() {
        RenderingRegistry.registerEntityRenderingHandler(EntityBouncingBetty.class, manager -> new RenderBouncingBetty(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityIMSBomb.class, manager -> new RenderIMSBomb(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntitySentry.class, manager -> new RenderSentry(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityBullet.class, manager -> new RenderBullet(manager));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityKeypadChest.class, (TileEntityRenderer)new TileEntityKeypadChestRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySecurityCamera.class, (TileEntityRenderer)new TileEntitySecurityCameraRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySecretSign.class, (TileEntityRenderer)new TileEntitySecretSignRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTrophySystem.class, (TileEntityRenderer)new TileEntityTrophySystemRenderer());
        KeyBindings.init();
    }

    @Override
    public void registerKeypadChestItem(RegistryEvent.Register<Item> event) {
        event.getRegistry().register(new ItemBlock(SCContent.keypadChest, new Item.Properties().func_200916_a(SecurityCraft.groupSCTechnical).setTEISR(() -> () -> new ItemKeypadChestRenderer())).setRegistryName(SCContent.keypadChest.getRegistryName()));
    }

    @Override
    public Map<Block, Integer> getOrPopulateToTint() {
        if (this.toTint.isEmpty()) {
            for (Field field : SCContent.class.getFields()) {
                if (!field.isAnnotationPresent(Reinforced.class) || !field.getAnnotation(Reinforced.class).hasTint()) continue;
                try {
                    this.toTint.put((Block)field.get(null), field.getAnnotation(Reinforced.class).tint());
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
            this.toTint.put(SCContent.blockPocketManager, 946275);
            this.toTint.put(SCContent.blockPocketWall, 946275);
            this.toTint.put(SCContent.chiseledCrystalQuartz, 1422242);
            this.toTint.put(SCContent.crystalQuartz, 1422242);
            this.toTint.put(SCContent.crystalQuartzPillar, 1422242);
            this.toTint.put(SCContent.crystalQuartzSlab, 1422242);
            this.toTint.put(SCContent.stairsCrystalQuartz, 1422242);
        }
        return this.toTint;
    }

    @Override
    public void cleanup() {
        this.toTint = null;
    }
}

