/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.client;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class PlaySoundAtPos {
    private int x;
    private int y;
    private int z;
    private String sound;
    private double volume;
    private String category;

    public PlaySoundAtPos() {
    }

    public PlaySoundAtPos(int x, int y, int z, String sound, double volume, String cat) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.sound = sound;
        this.volume = volume;
        this.category = cat;
    }

    public PlaySoundAtPos(double x, double y, double z, String sound, double volume, String cat) {
        this((int)x, (int)y, (int)z, sound, volume, cat);
    }

    public PlaySoundAtPos(int x, int y, int z, ResourceLocation resourceLocation, double volume, String cat) {
        this(x, y, z, resourceLocation.func_110623_a(), volume, cat);
    }

    public PlaySoundAtPos(double x, double y, double z, ResourceLocation resourceLocation, double volume, String cat) {
        this((int)x, (int)y, (int)z, resourceLocation.func_110623_a(), volume, cat);
    }

    public void fromBytes(PacketBuffer buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.sound = buf.func_150789_c(0x1FFFFFFF);
        this.volume = buf.readDouble();
        this.category = buf.func_150789_c(0x1FFFFFFF);
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.func_180714_a(this.sound);
        buf.writeDouble(this.volume);
        buf.func_180714_a(this.category);
    }

    public static void encode(PlaySoundAtPos message, PacketBuffer packet) {
        message.toBytes(packet);
    }

    public static PlaySoundAtPos decode(PacketBuffer packet) {
        PlaySoundAtPos message = new PlaySoundAtPos();
        message.fromBytes(packet);
        return message;
    }

    public static void onMessage(PlaySoundAtPos message, Supplier<NetworkEvent.Context> ctx) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> PlaySoundAtPos.lambda$null$0(message, (Supplier)ctx));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleMessage(PlaySoundAtPos message, Supplier<NetworkEvent.Context> ctx) {
        Minecraft.func_71410_x().field_71441_e.func_184133_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, new BlockPos(message.x, message.y, message.z), new SoundEvent(new ResourceLocation(message.sound)), SoundCategory.valueOf((String)message.category.toUpperCase()), (float)message.volume, 1.0f);
        ctx.get().setPacketHandled(true);
    }

    private static /* synthetic */ void lambda$null$0(PlaySoundAtPos message, Supplier ctx) {
        PlaySoundAtPos.handleMessage(message, ctx);
    }
}

