/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.misc.BaseInteractionObject;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IInteractionObject;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkHooks;

public class OpenGui {
    private ResourceLocation id;
    private int x;
    private int y;
    private int z;

    public OpenGui() {
    }

    public OpenGui(ResourceLocation id, BlockPos pos) {
        this(id, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public OpenGui(ResourceLocation id, int x, int y, int z) {
        this.id = id;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_180714_a(this.id.toString());
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
    }

    public void fromBytes(PacketBuffer buf) {
        this.id = new ResourceLocation(buf.func_150789_c(0x1FFFFFFF));
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
    }

    public static void encode(OpenGui message, PacketBuffer packet) {
        message.toBytes(packet);
    }

    public static OpenGui decode(PacketBuffer packet) {
        OpenGui message = new OpenGui();
        message.fromBytes(packet);
        return message;
    }

    public static void onMessage(OpenGui message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ResourceLocation id = message.id;
            int x = message.x;
            int y = message.y;
            int z = message.z;
            EntityPlayerMP player = ((NetworkEvent.Context)ctx.get()).getSender();
            NetworkHooks.openGui((EntityPlayerMP)player, (IInteractionObject)new BaseInteractionObject(id), (BlockPos)new BlockPos(x, y, z));
        });
        ctx.get().setPacketHandled(true);
    }
}

