/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.server;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.tileentity.TileEntityInventoryScanner;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class SetScanType {
    private int x;
    private int y;
    private int z;
    private String type;

    public SetScanType() {
    }

    public SetScanType(int x, int y, int z, String type) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.type = type;
    }

    public void fromBytes(PacketBuffer buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.type = buf.func_150789_c(0x1FFFFFFF);
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.func_180714_a(this.type);
    }

    public static void encode(SetScanType message, PacketBuffer packet) {
        message.toBytes(packet);
    }

    public static SetScanType decode(PacketBuffer packet) {
        SetScanType message = new SetScanType();
        message.fromBytes(packet);
        return message;
    }

    public static void onMessage(SetScanType message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            BlockPos pos = BlockUtils.toPos(message.x, message.y, message.z);
            EntityPlayerMP player = ((NetworkEvent.Context)ctx.get()).getSender();
            World world = player.field_70170_p;
            ((TileEntityInventoryScanner)world.func_175625_s(pos)).setScanType(message.type);
            SecurityCraft.log("Setting type to " + message.type);
            world.func_205220_G_().func_205360_a(pos, (Object)BlockUtils.getBlock(world, pos), 1);
            Utils.setISinTEAppropriately(world, pos, ((TileEntityInventoryScanner)world.func_175625_s(pos)).getContents(), ((TileEntityInventoryScanner)world.func_175625_s(pos)).getScanType());
        });
        ctx.get().setPacketHandled(true);
    }
}

