/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import java.util.Calendar;
import net.geforcemods.securitycraft.tileentity.TileEntityKeypadChest;
import net.minecraft.block.BlockChest;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.model.ModelChest;
import net.minecraft.client.renderer.entity.model.ModelLargeChest;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.ChestType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TileEntityKeypadChestRenderer
extends TileEntityRenderer<TileEntityKeypadChest> {
    private static final ResourceLocation CHRISTMAS_DOUBLE = new ResourceLocation("securitycraft:textures/entity/chest/christmas_double.png");
    private static final ResourceLocation NORMAL_DOUBLE_INACTIVE = new ResourceLocation("securitycraft:textures/entity/chest/double_chest_unactive.png");
    private static final ResourceLocation NORMAL_DOUBLE_ACTIVE = new ResourceLocation("securitycraft:textures/entity/chest/double_chest_active.png");
    private static final ResourceLocation CHRISTMAS_SINGLE = new ResourceLocation("securitycraft:textures/entity/chest/christmas.png");
    private static final ResourceLocation NORMAL_SINGLE_INACTIVE = new ResourceLocation("securitycraft:textures/entity/chest/chest_unactive.png");
    private static final ResourceLocation NORMAL_SINGLE_ACTIVE = new ResourceLocation("securitycraft:textures/entity/chest/chest_active.png");
    private static final ModelChest SMALL_MODEL = new ModelChest();
    private static final ModelChest LARGE_MODEL = new ModelLargeChest();
    private boolean isChristmas;

    public TileEntityKeypadChestRenderer() {
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            this.isChristmas = true;
        }
    }

    public void render(TileEntityKeypadChest tileEntityIn, double x, double y, double z, float partialTicks, int destroyStage) {
        ChestType chesttype;
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        IBlockState iblockstate = tileEntityIn.func_145830_o() ? tileEntityIn.func_195044_w() : (IBlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.SOUTH);
        ChestType chestType = chesttype = iblockstate.func_196959_b((IProperty)BlockChest.field_196314_b) ? (ChestType)iblockstate.func_177229_b((IProperty)BlockChest.field_196314_b) : ChestType.SINGLE;
        if (chesttype != ChestType.LEFT) {
            boolean flag = chesttype != ChestType.SINGLE;
            ModelChest modelchest = this.getChestModel(tileEntityIn, destroyStage, flag);
            if (destroyStage >= 0) {
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)(flag ? 8.0f : 4.0f), (float)4.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)0.0625f, (float)0.0625f, (float)0.0625f);
                GlStateManager.func_179128_n((int)5888);
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179091_B();
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
            GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
            float f = ((EnumFacing)iblockstate.func_177229_b((IProperty)BlockChest.field_176459_a)).func_185119_l();
            if ((double)Math.abs(f) > 1.0E-5) {
                GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.5f);
                GlStateManager.func_179114_b((float)f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
            }
            this.rotateLid(tileEntityIn, partialTicks, modelchest);
            modelchest.func_78231_a();
            GlStateManager.func_179101_C();
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (destroyStage >= 0) {
                GlStateManager.func_179128_n((int)5890);
                GlStateManager.func_179121_F();
                GlStateManager.func_179128_n((int)5888);
            }
        }
    }

    private ModelChest getChestModel(TileEntityKeypadChest te, int partialTicks, boolean flag) {
        ResourceLocation resourcelocation = partialTicks >= 0 ? field_178460_a[partialTicks] : (this.isChristmas ? (flag ? CHRISTMAS_DOUBLE : CHRISTMAS_SINGLE) : (te.func_195480_a(partialTicks) >= 0.9f ? (flag ? NORMAL_DOUBLE_ACTIVE : NORMAL_SINGLE_ACTIVE) : (flag ? NORMAL_DOUBLE_INACTIVE : NORMAL_SINGLE_INACTIVE)));
        this.func_147499_a(resourcelocation);
        return flag ? LARGE_MODEL : SMALL_MODEL;
    }

    private void rotateLid(TileEntityKeypadChest te, float partialTicks, ModelChest chestModel) {
        float f = te.func_195480_a(partialTicks);
        f = 1.0f - f;
        f = 1.0f - f * f * f;
        chestModel.func_205058_b().field_78795_f = -(f * 1.5707964f);
    }
}

