/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.ArrayList;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.BlockBlockPocketManager;
import net.geforcemods.securitycraft.blocks.BlockBlockPocketWall;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.network.server.ToggleBlockPocketManager;
import net.geforcemods.securitycraft.tileentity.TileEntityBlockPocket;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.geforcemods.securitycraft.util.IBlockPocket;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class TileEntityBlockPocketManager
extends CustomizableSCTE {
    public boolean enabled = false;
    public int size = 5;
    private List<BlockPos> blocks = new ArrayList<BlockPos>();
    private List<BlockPos> walls = new ArrayList<BlockPos>();

    public TileEntityBlockPocketManager() {
        super(SCContent.teTypeBlockPocketManager);
    }

    public TextComponentTranslation enableMultiblock() {
        if (!this.enabled) {
            TileEntity te;
            if (this.field_145850_b.field_72995_K) {
                SecurityCraft.channel.sendToServer((Object)new ToggleBlockPocketManager(this, true, this.size));
            }
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            ArrayList<BlockPos> sides = new ArrayList<BlockPos>();
            EnumFacing managerFacing = (EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockBlockPocketManager.FACING);
            EnumFacing left = managerFacing.func_176746_e();
            EnumFacing right = left.func_176734_d();
            EnumFacing back = left.func_176746_e();
            boolean lowest = false;
            int highest = this.size - 1;
            BlockPos pos = this.func_174877_v().func_185334_h();
            int xi = 0;
            int yi = 0;
            int zi = 0;
            while (this.field_145850_b.func_180495_p(pos = pos.func_177972_a(left)).func_177230_c() instanceof IBlockPocket) {
            }
            pos = pos.func_177972_a(right);
            BlockPos startingPos = pos.func_185334_h();
            while (yi < this.size) {
                while (zi < this.size) {
                    while (xi < this.size) {
                        if (xi > 0 && yi > 0 && zi > 0 && xi < highest && yi < highest && zi < highest) {
                            ++xi;
                            continue;
                        }
                        BlockPos currentPos = pos.func_177967_a(right, xi);
                        IBlockState currentState = this.field_145850_b.func_180495_p(currentPos);
                        if (currentState.func_177230_c() instanceof BlockBlockPocketManager && !currentPos.equals((Object)this.func_174877_v())) {
                            return new TextComponentTranslation("messages.securitycraft:blockpocket.multipleManagers", new Object[0]);
                        }
                        if (yi == 0 && !currentPos.equals((Object)this.func_174877_v()) || yi == highest) {
                            EnumFacing.Axis typeToCheckFor;
                            if (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest) {
                                if (currentState.func_177230_c() != SCContent.reinforcedChiseledCrystalQuartz) {
                                    return new TextComponentTranslation("messages.securitycraft:blockpocket.invalidBlock", new Object[]{currentPos, new TextComponentTranslation(currentState.func_177230_c().func_199767_j().func_77658_a(), new Object[0])});
                                }
                            } else if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                                EnumFacing.Axis axis = typeToCheckFor = managerFacing == EnumFacing.NORTH || managerFacing == EnumFacing.SOUTH ? EnumFacing.Axis.X : EnumFacing.Axis.Z;
                                if (currentState.func_177230_c() != SCContent.reinforcedCrystalQuartzPillar || currentState.func_177229_b((IProperty)BlockStateProperties.field_208148_A) != typeToCheckFor) {
                                    return new TextComponentTranslation("messages.securitycraft:blockpocket.invalidBlock.pillar", new Object[]{currentPos, new TextComponentTranslation(currentState.func_177230_c().func_199767_j().func_77658_a(), new Object[0])});
                                }
                            } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                                EnumFacing.Axis axis = typeToCheckFor = managerFacing == EnumFacing.NORTH || managerFacing == EnumFacing.SOUTH ? EnumFacing.Axis.Z : EnumFacing.Axis.X;
                                if (currentState.func_177230_c() != SCContent.reinforcedCrystalQuartzPillar || currentState.func_177229_b((IProperty)BlockStateProperties.field_208148_A) != typeToCheckFor) {
                                    return new TextComponentTranslation("messages.securitycraft:blockpocket.invalidBlock.pillar", new Object[]{currentPos, new TextComponentTranslation(currentState.func_177230_c().func_199767_j().func_77658_a(), new Object[0])});
                                }
                            } else if (xi > 0 && zi > 0 && xi < highest && zi < highest) {
                                if (!(currentState.func_177230_c() instanceof BlockBlockPocketWall)) {
                                    return new TextComponentTranslation("messages.securitycraft:blockpocket.invalidBlock", new Object[]{currentPos, new TextComponentTranslation(currentState.func_177230_c().func_199767_j().func_77658_a(), new Object[0])});
                                }
                                sides.add(currentPos);
                            }
                        } else if (yi != 0 && yi != highest && (xi == 0 && zi == 0 || xi == 0 && zi == highest || xi == highest && zi == 0 || xi == highest && zi == highest)) {
                            if (currentState.func_177230_c() != SCContent.reinforcedCrystalQuartzPillar || currentState.func_177229_b((IProperty)BlockStateProperties.field_208148_A) != EnumFacing.Axis.Y) {
                                return new TextComponentTranslation("messages.securitycraft:blockpocket.invalidBlock.pillar", new Object[]{currentPos, new TextComponentTranslation(currentState.func_177230_c().func_199767_j().func_77658_a(), new Object[0])});
                            }
                        } else if (yi > 0 && yi < highest) {
                            if ((zi == 0 || zi == highest) && xi > 0 && xi < highest) {
                                if (!(currentState.func_177230_c() instanceof BlockBlockPocketWall)) {
                                    return new TextComponentTranslation("messages.securitycraft:blockpocket.invalidBlock", new Object[]{currentPos, new TextComponentTranslation(currentState.func_177230_c().func_199767_j().func_77658_a(), new Object[0])});
                                }
                                sides.add(currentPos);
                            } else if ((xi == 0 || xi == highest) && zi > 0 && zi < highest) {
                                if (!(currentState.func_177230_c() instanceof BlockBlockPocketWall)) {
                                    return new TextComponentTranslation("messages.securitycraft:blockpocket.invalidBlock", new Object[]{currentPos, new TextComponentTranslation(currentState.func_177230_c().func_199767_j().func_77658_a(), new Object[0])});
                                }
                                sides.add(currentPos);
                            }
                        }
                        te = (TileEntityOwnable)this.field_145850_b.func_175625_s(currentPos);
                        if (!this.getOwner().owns(new IOwnable[]{te})) {
                            return new TextComponentTranslation("messages.securitycraft:blockpocket.unowned", new Object[]{currentPos, new TextComponentTranslation(currentState.func_177230_c().func_199767_j().func_77658_a(), new Object[0])});
                        }
                        blocks.add(currentPos);
                        ++xi;
                    }
                    xi = 0;
                    pos = startingPos.func_177981_b(yi).func_177967_a(back, ++zi);
                }
                zi = 0;
                pos = startingPos.func_177981_b(++yi);
            }
            this.blocks = blocks;
            this.walls = sides;
            this.enabled = true;
            for (BlockPos blockPos : blocks) {
                te = this.field_145850_b.func_175625_s(blockPos);
                if (!(te instanceof TileEntityBlockPocket)) continue;
                ((TileEntityBlockPocket)te).setManager(this);
            }
            this.setWalls(!this.hasModule(EnumCustomModules.DISGUISE));
        }
        return null;
    }

    public void disableMultiblock() {
        if (this.enabled) {
            if (this.field_145850_b.field_72995_K) {
                SecurityCraft.channel.sendToServer((Object)new ToggleBlockPocketManager(this, false, this.size));
            }
            this.enabled = false;
            for (BlockPos pos : this.blocks) {
                TileEntity te = this.field_145850_b.func_175625_s(pos);
                if (!(te instanceof TileEntityBlockPocket)) continue;
                ((TileEntityBlockPocket)te).removeManager();
            }
            if (this.hasModule(EnumCustomModules.DISGUISE)) {
                this.setWalls(true);
            }
            this.blocks.clear();
            this.walls.clear();
        }
    }

    public void setWalls(boolean seeThrough) {
        for (BlockPos pos : this.walls) {
            IBlockState state = this.field_145850_b.func_180495_p(pos);
            if (!(state.func_177230_c() instanceof BlockBlockPocketWall)) continue;
            this.field_145850_b.func_175656_a(pos, (IBlockState)state.func_206870_a((IProperty)BlockBlockPocketWall.SEE_THROUGH, (Comparable)Boolean.valueOf(seeThrough)));
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.disableMultiblock();
    }

    @Override
    public void onTileEntityDestroyed() {
        super.onTileEntityDestroyed();
        this.disableMultiblock();
    }

    @Override
    public void onModuleInserted(ItemStack stack, EnumCustomModules module) {
        if (this.enabled && module == EnumCustomModules.DISGUISE) {
            this.setWalls(false);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, EnumCustomModules module) {
        if (this.enabled && module == EnumCustomModules.DISGUISE) {
            this.setWalls(true);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        int i;
        tag.func_74757_a("BlockPocketEnabled", this.enabled);
        for (i = 0; i < this.blocks.size(); ++i) {
            tag.func_74772_a("BlocksList" + i, this.blocks.get(i).func_177986_g());
        }
        for (i = 0; i < this.walls.size(); ++i) {
            tag.func_74772_a("WallsList" + i, this.walls.get(i).func_177986_g());
        }
        return super.func_189515_b(tag);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        int i = 0;
        super.func_145839_a(tag);
        this.enabled = tag.func_74767_n("BlockPocketEnabled");
        while (tag.func_74764_b("BlocksList" + i)) {
            this.blocks.add(BlockPos.func_177969_a((long)tag.func_74763_f("BlocksList" + i)));
            ++i;
        }
        i = 0;
        while (tag.func_74764_b("WallsList" + i)) {
            this.walls.add(BlockPos.func_177969_a((long)tag.func_74763_f("WallsList" + i)));
            ++i;
        }
    }

    @Override
    public EnumCustomModules[] acceptedModules() {
        return new EnumCustomModules[]{EnumCustomModules.DISGUISE, EnumCustomModules.WHITELIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_200201_e() {
        return null;
    }
}

