/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.Iterator;
import java.util.List;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.mines.BlockIMS;
import net.geforcemods.securitycraft.entity.EntityIMSBomb;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.network.client.PlaySoundAtPos;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.WorldUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fml.network.PacketDistributor;

public class TileEntityIMS
extends CustomizableSCTE {
    private int bombsRemaining = 4;
    private EnumIMSTargetingMode targetingOption = EnumIMSTargetingMode.PLAYERS_AND_MOBS;
    private boolean updateBombCount = false;

    public TileEntityIMS() {
        super(SCContent.teTypeIms);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K && this.updateBombCount) {
            int mineCount = BlockUtils.getBlockPropertyAsInteger(this.field_145850_b, this.field_174879_c, BlockIMS.MINES);
            if (mineCount - 1 >= 0 && mineCount <= 4) {
                BlockUtils.setBlockProperty(this.field_145850_b, this.field_174879_c, BlockIMS.MINES, BlockUtils.getBlockPropertyAsInteger(this.field_145850_b, this.field_174879_c, BlockIMS.MINES) - 1);
            }
            this.updateBombCount = false;
        }
        if (this.field_145850_b.func_82737_E() % 80L == 0L) {
            this.launchMine();
        }
    }

    private void launchMine() {
        boolean launchedMine = false;
        if (this.bombsRemaining > 0) {
            double targetZ;
            double targetY;
            double targetX;
            int launchHeight;
            EntityLivingBase entity;
            double range = ((Integer)ConfigHandler.CommonConfig.CONFIG.imsRange.get()).intValue();
            AxisAlignedBB area = BlockUtils.fromBounds(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.field_174879_c.func_177958_n() + 1, this.field_174879_c.func_177956_o() + 1, this.field_174879_c.func_177952_p() + 1).func_72314_b(range, range, range);
            List players = this.field_145850_b.func_72872_a(EntityPlayer.class, area);
            List mobs = this.field_145850_b.func_72872_a(EntityMob.class, area);
            Iterator playerIterator = players.iterator();
            Iterator mobIterator = mobs.iterator();
            while (this.targetingOption == EnumIMSTargetingMode.PLAYERS_AND_MOBS && mobIterator.hasNext()) {
                entity = (EntityLivingBase)mobIterator.next();
                launchHeight = this.getLaunchHeight();
                if (PlayerUtils.isPlayerMountedOnCamera(entity) || WorldUtils.isPathObstructed(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + ((double)((launchHeight - 1) / 3) + 0.5), (double)this.field_174879_c.func_177952_p() + 0.5, entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v) || this.hasModule(EnumCustomModules.WHITELIST) && ModuleUtils.getPlayersFromModule(this.field_145850_b, this.field_174879_c, EnumCustomModules.WHITELIST).contains(entity.func_200200_C_().func_150254_d().toLowerCase())) continue;
                targetX = entity.field_70165_t - ((double)this.field_174879_c.func_177958_n() + 0.5);
                targetY = entity.func_174813_aQ().field_72338_b + (double)(entity.field_70131_O / 2.0f) - ((double)this.field_174879_c.func_177956_o() + 1.25);
                targetZ = entity.field_70161_v - ((double)this.field_174879_c.func_177952_p() + 0.5);
                this.spawnMine(entity, targetX, targetY, targetZ, launchHeight);
                if (!this.field_145850_b.field_72995_K) {
                    SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new PlaySoundAtPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), "random.bow", 1.0, "blocks"));
                }
                --this.bombsRemaining;
                launchedMine = true;
                this.updateBombCount = true;
                break;
            }
            while (!launchedMine && playerIterator.hasNext()) {
                entity = (EntityPlayer)playerIterator.next();
                launchHeight = this.getLaunchHeight();
                if (entity != null && this.getOwner().isOwner((EntityPlayer)entity) || PlayerUtils.isPlayerMountedOnCamera(entity) || WorldUtils.isPathObstructed(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + ((double)((launchHeight - 1) / 3) + 0.5), (double)this.field_174879_c.func_177952_p() + 0.5, entity.field_70165_t, entity.field_70163_u + (double)entity.func_70047_e(), entity.field_70161_v) || this.hasModule(EnumCustomModules.WHITELIST) && ModuleUtils.getPlayersFromModule(this.field_145850_b, this.field_174879_c, EnumCustomModules.WHITELIST).contains(entity.func_200200_C_().func_150254_d())) continue;
                targetX = entity.field_70165_t - ((double)this.field_174879_c.func_177958_n() + 0.5);
                targetY = entity.func_174813_aQ().field_72338_b + (double)(entity.field_70131_O / 2.0f) - ((double)this.field_174879_c.func_177956_o() + 1.25);
                targetZ = entity.field_70161_v - ((double)this.field_174879_c.func_177952_p() + 0.5);
                this.spawnMine((EntityPlayer)entity, targetX, targetY, targetZ, launchHeight);
                if (!this.field_145850_b.field_72995_K) {
                    SecurityCraft.channel.send(PacketDistributor.ALL.noArg(), (Object)new PlaySoundAtPos(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), "random.bow", 1.0, "block"));
                }
                --this.bombsRemaining;
                this.updateBombCount = true;
                break;
            }
        }
    }

    private void spawnMine(EntityPlayer target, double x, double y, double z, int launchHeight) {
        double addToX = this.bombsRemaining == 4 || this.bombsRemaining == 3 ? 1.2 : 0.55;
        double addToZ = this.bombsRemaining == 4 || this.bombsRemaining == 2 ? 1.2 : 0.6;
        this.field_145850_b.func_72838_d((Entity)new EntityIMSBomb(this.field_145850_b, target, (double)this.field_174879_c.func_177958_n() + addToX, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + addToZ, x, y, z, launchHeight));
    }

    private void spawnMine(EntityLivingBase target, double x, double y, double z, int launchHeight) {
        double addToX = this.bombsRemaining == 4 || this.bombsRemaining == 3 ? 1.2 : 0.55;
        double addToZ = this.bombsRemaining == 4 || this.bombsRemaining == 2 ? 1.2 : 0.6;
        this.field_145850_b.func_72838_d((Entity)new EntityIMSBomb(this.field_145850_b, target, (double)this.field_174879_c.func_177958_n() + addToX, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + addToZ, x, y, z, launchHeight));
    }

    private int getLaunchHeight() {
        IBlockState state;
        int height;
        for (height = 1; height <= 9 && ((state = this.func_145831_w().func_180495_p(this.func_174877_v().func_177981_b(height))) == null || state.isAir((IBlockReader)this.func_145831_w(), this.func_174877_v())); ++height) {
        }
        return height * 3;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("bombsRemaining", this.bombsRemaining);
        tag.func_74768_a("targetingOption", this.targetingOption.modeIndex);
        tag.func_74757_a("updateBombCount", this.updateBombCount);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("bombsRemaining")) {
            this.bombsRemaining = tag.func_74762_e("bombsRemaining");
        }
        if (tag.func_74764_b("targetingOption")) {
            this.targetingOption = EnumIMSTargetingMode.values()[tag.func_74762_e("targetingOption")];
        }
        if (tag.func_74764_b("updateBombCount")) {
            this.updateBombCount = tag.func_74767_n("updateBombCount");
        }
    }

    public int getBombsRemaining() {
        return this.bombsRemaining;
    }

    public void setBombsRemaining(int bombsRemaining) {
        this.bombsRemaining = bombsRemaining;
    }

    public EnumIMSTargetingMode getTargetingOption() {
        return this.targetingOption;
    }

    public void setTargetingOption(EnumIMSTargetingMode targetingOption) {
        this.targetingOption = targetingOption;
    }

    @Override
    public EnumCustomModules[] acceptedModules() {
        return new EnumCustomModules[]{EnumCustomModules.WHITELIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return null;
    }

    public ITextComponent func_200201_e() {
        return this.getCustomSCName();
    }

    public boolean func_145818_k_() {
        return this.hasCustomSCName();
    }

    public static enum EnumIMSTargetingMode {
        PLAYERS(0),
        PLAYERS_AND_MOBS(1);

        public final int modeIndex;

        private EnumIMSTargetingMode(int index) {
            this.modeIndex = index;
        }
    }
}

