/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.BlockKeypad;
import net.geforcemods.securitycraft.gui.GuiHandler;
import net.geforcemods.securitycraft.misc.BaseInteractionObject;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.models.ModelDynamicBakedKeypad;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IInteractionObject;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.fml.network.NetworkHooks;

public class TileEntityKeypad
extends CustomizableSCTE
implements IPasswordProtected {
    private String passcode;
    private Option.OptionBoolean isAlwaysActive = new Option.OptionBoolean("isAlwaysActive", false){

        @Override
        public void toggle() {
            super.toggle();
            if (this.getValue().booleanValue()) {
                BlockUtils.setBlockProperty(TileEntityKeypad.this.field_145850_b, TileEntityKeypad.this.field_174879_c, BlockKeypad.POWERED, true);
                TileEntityKeypad.this.field_145850_b.func_195593_d(TileEntityKeypad.this.field_174879_c, SCContent.keypad);
            } else {
                BlockUtils.setBlockProperty(TileEntityKeypad.this.field_145850_b, TileEntityKeypad.this.field_174879_c, BlockKeypad.POWERED, false);
                TileEntityKeypad.this.field_145850_b.func_195593_d(TileEntityKeypad.this.field_174879_c, SCContent.keypad);
            }
        }
    };

    public TileEntityKeypad() {
        super(SCContent.teTypeKeypad);
    }

    @Override
    public void onModuleInserted(ItemStack stack, EnumCustomModules module) {
        if (this.field_145850_b.field_72995_K && module == EnumCustomModules.DISGUISE) {
            ModelDataManager.requestModelDataRefresh((TileEntity)this);
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }

    @Override
    public void onModuleRemoved(ItemStack stack, EnumCustomModules module) {
        if (this.field_145850_b.field_72995_K && module == EnumCustomModules.DISGUISE) {
            ModelDataManager.requestModelDataRefresh((TileEntity)this);
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.passcode != null && !this.passcode.isEmpty()) {
            tag.func_74778_a("passcode", this.passcode);
        }
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("passcode")) {
            this.passcode = tag.func_74762_e("passcode") != 0 ? String.valueOf(tag.func_74762_e("passcode")) : tag.func_74779_i("passcode");
        }
    }

    @Override
    public void activate(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K && BlockUtils.getBlock(this.func_145831_w(), this.func_174877_v()) instanceof BlockKeypad) {
            BlockKeypad.activate(this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    public void openPasswordGUI(EntityPlayer player) {
        if (this.getPassword() != null) {
            if (player instanceof EntityPlayerMP) {
                NetworkHooks.openGui((EntityPlayerMP)((EntityPlayerMP)player), (IInteractionObject)new BaseInteractionObject(GuiHandler.INSERT_PASSWORD), (BlockPos)this.field_174879_c);
            }
        } else if (this.getOwner().isOwner(player)) {
            if (player instanceof EntityPlayerMP) {
                NetworkHooks.openGui((EntityPlayerMP)((EntityPlayerMP)player), (IInteractionObject)new BaseInteractionObject(GuiHandler.SETUP_PASSWORD), (BlockPos)this.field_174879_c);
            }
        } else {
            PlayerUtils.sendMessageToPlayer(player, "SecurityCraft", ClientUtils.localize("messages.securitycraft:passwordProtected.notSetUp", new Object[0]), TextFormatting.DARK_RED);
        }
    }

    @Override
    public boolean onCodebreakerUsed(IBlockState blockState, EntityPlayer player, boolean isCodebreakerDisabled) {
        if (isCodebreakerDisabled) {
            PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize(SCContent.keypad.func_149739_a(), new Object[0]), ClientUtils.localize("messages.securitycraft:codebreakerDisabled", new Object[0]), TextFormatting.RED);
        } else if (!BlockUtils.getBlockPropertyAsBoolean(this.field_145850_b, this.field_174879_c, BlockKeypad.POWERED)) {
            this.activate(player);
            return true;
        }
        return false;
    }

    @Override
    public String getPassword() {
        return this.passcode != null && !this.passcode.isEmpty() ? this.passcode : null;
    }

    @Override
    public void setPassword(String password) {
        this.passcode = password;
    }

    @Override
    public EnumCustomModules[] acceptedModules() {
        return new EnumCustomModules[]{EnumCustomModules.WHITELIST, EnumCustomModules.BLACKLIST, EnumCustomModules.DISGUISE};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.isAlwaysActive};
    }

    public ITextComponent func_200201_e() {
        return this.getCustomSCName();
    }

    public boolean func_145818_k_() {
        return this.hasCustomSCName();
    }

    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(ModelDynamicBakedKeypad.DISGUISED_BLOCK_RL, (Object)ModelDynamicBakedKeypad.DEFAULT_STATE_RL).build();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            ModelDataManager.requestModelDataRefresh((TileEntity)this);
            this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        }
    }
}

