/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blocks.BlockKeypadChest;
import net.geforcemods.securitycraft.gui.GuiHandler;
import net.geforcemods.securitycraft.misc.BaseInteractionObject;
import net.geforcemods.securitycraft.network.server.RequestTEOwnableUpdate;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IInteractionObject;
import net.minecraftforge.fml.network.NetworkHooks;

public class TileEntityKeypadChest
extends TileEntityChest
implements IPasswordProtected,
IOwnable {
    private String passcode;
    private Owner owner = new Owner();

    public TileEntityKeypadChest() {
        super(SCContent.teTypeKeypadChest);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.passcode != null && !this.passcode.isEmpty()) {
            tag.func_74778_a("passcode", this.passcode);
        }
        if (this.owner != null) {
            tag.func_74778_a("owner", this.owner.getName());
            tag.func_74778_a("ownerUUID", this.owner.getUUID());
        }
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("passcode")) {
            this.passcode = tag.func_74762_e("passcode") != 0 ? String.valueOf(tag.func_74762_e("passcode")) : tag.func_74779_i("passcode");
        }
        if (tag.func_74764_b("owner")) {
            this.owner.setOwnerName(tag.func_74779_i("owner"));
        }
        if (tag.func_74764_b("ownerUUID")) {
            this.owner.setOwnerUUID(tag.func_74779_i("ownerUUID"));
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_189515_b(tag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public ITextComponent func_200200_C_() {
        return new TextComponentString("Protected chest");
    }

    @Override
    public void activate(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K && BlockUtils.getBlock(this.func_145831_w(), this.func_174877_v()) instanceof BlockKeypadChest && !this.isBlocked()) {
            BlockKeypadChest.activate(this.field_145850_b, this.field_174879_c, player);
        }
    }

    @Override
    public void openPasswordGUI(EntityPlayer player) {
        if (this.isBlocked()) {
            return;
        }
        if (this.getPassword() != null) {
            if (player instanceof EntityPlayerMP) {
                NetworkHooks.openGui((EntityPlayerMP)((EntityPlayerMP)player), (IInteractionObject)new BaseInteractionObject(GuiHandler.INSERT_PASSWORD), (BlockPos)this.field_174879_c);
            }
        } else if (this.getOwner().isOwner(player)) {
            if (player instanceof EntityPlayerMP) {
                NetworkHooks.openGui((EntityPlayerMP)((EntityPlayerMP)player), (IInteractionObject)new BaseInteractionObject(GuiHandler.SETUP_PASSWORD), (BlockPos)this.field_174879_c);
            }
        } else {
            PlayerUtils.sendMessageToPlayer(player, "SecurityCraft", ClientUtils.localize("messages.securitycraft:passwordProtected.notSetUp", new Object[0]), TextFormatting.DARK_RED);
        }
    }

    @Override
    public boolean onCodebreakerUsed(IBlockState blockState, EntityPlayer player, boolean isCodebreakerDisabled) {
        if (!isCodebreakerDisabled) {
            this.activate(player);
            return true;
        }
        PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize(SCContent.keypadChest.func_149739_a(), new Object[0]), ClientUtils.localize("messages.securitycraft:codebreakerDisabled", new Object[0]), TextFormatting.RED);
        return false;
    }

    @Override
    public String getPassword() {
        return this.passcode != null && !this.passcode.isEmpty() ? this.passcode : null;
    }

    @Override
    public void setPassword(String password) {
        this.passcode = password;
    }

    @Override
    public Owner getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(String uuid, String name) {
        this.owner.set(uuid, name);
    }

    public boolean isBlocked() {
        Block east = BlockUtils.getBlock(this.func_145831_w(), this.func_174877_v().func_177974_f());
        Block south = BlockUtils.getBlock(this.func_145831_w(), this.func_174877_v().func_177968_d());
        Block west = BlockUtils.getBlock(this.func_145831_w(), this.func_174877_v().func_177976_e());
        Block north = BlockUtils.getBlock(this.func_145831_w(), this.func_174877_v().func_177978_c());
        if (east instanceof BlockKeypadChest && BlockKeypadChest.isBlocked(this.func_145831_w(), this.func_174877_v().func_177974_f())) {
            return true;
        }
        if (south instanceof BlockKeypadChest && BlockKeypadChest.isBlocked(this.func_145831_w(), this.func_174877_v().func_177968_d())) {
            return true;
        }
        if (west instanceof BlockKeypadChest && BlockKeypadChest.isBlocked(this.func_145831_w(), this.func_174877_v().func_177976_e())) {
            return true;
        }
        if (north instanceof BlockKeypadChest && BlockKeypadChest.isBlocked(this.func_145831_w(), this.func_174877_v().func_177978_c())) {
            return true;
        }
        return this.isSingleBlocked();
    }

    public boolean isSingleBlocked() {
        return BlockKeypadChest.isBlocked(this.func_145831_w(), this.func_174877_v());
    }

    public void onLoad() {
        if (this.field_145850_b.field_72995_K) {
            SecurityCraft.channel.sendToServer((Object)new RequestTEOwnableUpdate(this.field_174879_c, this.field_145850_b.func_201675_m().func_186058_p().func_186068_a()));
        }
    }
}

