/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.blocks.BlockKeypadFurnace;
import net.geforcemods.securitycraft.gui.GuiHandler;
import net.geforcemods.securitycraft.misc.BaseInteractionObject;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerFurnace;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IInteractionObject;
import net.minecraftforge.common.crafting.VanillaRecipeTypes;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;

public class TileEntityKeypadFurnace
extends TileEntityOwnable
implements ISidedInventory,
IPasswordProtected {
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{2, 1};
    private static final int[] slotsSides = new int[]{1};
    public NonNullList<ItemStack> furnaceItemStacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    public int cookTime;
    public int totalCookTime;
    private String furnaceCustomName;
    private String passcode;

    public TileEntityKeypadFurnace() {
        super(SCContent.teTypeKeypadFurnace);
    }

    public int func_70302_i_() {
        return this.furnaceItemStacks.size();
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.furnaceItemStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        if (!((ItemStack)this.furnaceItemStacks.get(index)).func_190926_b()) {
            if (((ItemStack)this.furnaceItemStacks.get(index)).func_190916_E() <= count) {
                ItemStack stack = (ItemStack)this.furnaceItemStacks.get(index);
                this.furnaceItemStacks.set(index, (Object)ItemStack.field_190927_a);
                return stack;
            }
            ItemStack stack = ((ItemStack)this.furnaceItemStacks.get(index)).func_77979_a(count);
            if (((ItemStack)this.furnaceItemStacks.get(index)).func_190916_E() == 0) {
                this.furnaceItemStacks.set(index, (Object)ItemStack.field_190927_a);
            }
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        if (!((ItemStack)this.furnaceItemStacks.get(index)).func_190926_b()) {
            ItemStack stack = (ItemStack)this.furnaceItemStacks.get(index);
            this.furnaceItemStacks.set(index, (Object)ItemStack.field_190927_a);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        boolean areStacksEqual = !stack.func_190926_b() && stack.func_77969_a((ItemStack)this.furnaceItemStacks.get(index)) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)((ItemStack)this.furnaceItemStacks.get(index)));
        this.furnaceItemStacks.set(index, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !areStacksEqual) {
            this.totalCookTime = this.getTotalCookTime(stack);
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public ITextComponent func_200200_C_() {
        return new TextComponentString(this.hasCustomSCName() ? this.furnaceCustomName : "container.furnace");
    }

    @Override
    public boolean hasCustomSCName() {
        return this.furnaceCustomName != null && this.furnaceCustomName.length() > 0;
    }

    public void setCustomInventoryName(String name) {
        this.furnaceCustomName = name;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList list = tag.func_150295_c("Items", 10);
        this.furnaceItemStacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < list.size(); ++i) {
            NBTTagCompound stackTag = list.func_150305_b(i);
            byte slot = stackTag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.furnaceItemStacks.size()) continue;
            this.furnaceItemStacks.set((int)slot, (Object)ItemStack.func_199557_a((NBTTagCompound)stackTag));
        }
        this.furnaceBurnTime = tag.func_74765_d("BurnTime");
        this.cookTime = tag.func_74765_d("CookTime");
        this.totalCookTime = tag.func_74765_d("CookTimeTotal");
        this.currentItemBurnTime = TileEntityKeypadFurnace.getItemBurnTime((ItemStack)this.furnaceItemStacks.get(1));
        this.passcode = tag.func_74779_i("passcode");
        if (tag.func_150297_b("CustomName", 8)) {
            this.furnaceCustomName = tag.func_74779_i("CustomName");
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        tag.func_74777_a("CookTime", (short)this.cookTime);
        tag.func_74777_a("CookTimeTotal", (short)this.totalCookTime);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.furnaceItemStacks.size(); ++i) {
            if (((ItemStack)this.furnaceItemStacks.get(i)).func_190926_b()) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.furnaceItemStacks.get(i)).func_77955_b(stackTag);
            list.add((INBTBase)stackTag);
        }
        tag.func_74782_a("Items", (INBTBase)list);
        if (this.passcode != null && !this.passcode.isEmpty()) {
            tag.func_74778_a("passcode", this.passcode);
        }
        if (this.hasCustomSCName()) {
            tag.func_74778_a("CustomName", this.furnaceCustomName);
        }
        return tag;
    }

    public int func_70297_j_() {
        return 64;
    }

    public int getCookProgressScaled(int scaleFactor) {
        return this.cookTime * scaleFactor / 200;
    }

    public int getBurnTimeRemainingScaled(int scaleFactor) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.furnaceBurnTime * scaleFactor / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public static boolean isBurning(IInventory inventory) {
        return inventory.func_174887_a_(0) > 0;
    }

    @Override
    public void func_73660_a() {
        boolean isBurning = this.isBurning();
        boolean shouldMarkDirty = false;
        if (this.isBurning()) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (!this.isBurning() && (((ItemStack)this.furnaceItemStacks.get(1)).func_190926_b() || ((ItemStack)this.furnaceItemStacks.get(0)).func_190926_b())) {
                if (!this.isBurning() && this.cookTime > 0) {
                    this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
                }
            } else {
                if (!this.isBurning() && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEntityKeypadFurnace.getItemBurnTime((ItemStack)this.furnaceItemStacks.get(1));
                    if (this.isBurning()) {
                        shouldMarkDirty = true;
                        if (!((ItemStack)this.furnaceItemStacks.get(1)).func_190926_b()) {
                            ((ItemStack)this.furnaceItemStacks.get(1)).func_190918_g(1);
                            if (((ItemStack)this.furnaceItemStacks.get(1)).func_190916_E() == 0) {
                                this.furnaceItemStacks.set(1, (Object)((ItemStack)this.furnaceItemStacks.get(1)).func_77973_b().getContainerItem((ItemStack)this.furnaceItemStacks.get(1)));
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime == this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = this.getTotalCookTime((ItemStack)this.furnaceItemStacks.get(0));
                        this.smeltItem();
                        shouldMarkDirty = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            }
            if (isBurning != this.isBurning()) {
                shouldMarkDirty = true;
            }
        }
        if (shouldMarkDirty) {
            this.func_70296_d();
        }
    }

    public int getTotalCookTime(ItemStack stack) {
        return 200;
    }

    private boolean canSmelt() {
        if (((ItemStack)this.furnaceItemStacks.get(0)).func_190926_b()) {
            return false;
        }
        ItemStack smeltResult = this.field_145850_b.func_199532_z().getResult((IInventory)this, this.field_145850_b, VanillaRecipeTypes.SMELTING);
        if (smeltResult.func_190926_b()) {
            return false;
        }
        if (((ItemStack)this.furnaceItemStacks.get(2)).func_190926_b()) {
            return true;
        }
        if (!((ItemStack)this.furnaceItemStacks.get(2)).func_77969_a(smeltResult)) {
            return false;
        }
        int result = ((ItemStack)this.furnaceItemStacks.get(2)).func_190916_E() + smeltResult.func_190916_E();
        return result <= this.func_70297_j_() && result <= ((ItemStack)this.furnaceItemStacks.get(2)).func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack smeltResult = this.field_145850_b.func_199532_z().getResult((IInventory)this, this.field_145850_b, VanillaRecipeTypes.SMELTING);
            if (((ItemStack)this.furnaceItemStacks.get(2)).func_190926_b()) {
                this.furnaceItemStacks.set(2, (Object)smeltResult.func_77946_l());
            } else if (((ItemStack)this.furnaceItemStacks.get(2)).func_77973_b() == smeltResult.func_77973_b()) {
                ((ItemStack)this.furnaceItemStacks.get(2)).func_190917_f(smeltResult.func_190916_E());
            }
            if (((ItemStack)this.furnaceItemStacks.get(0)).func_77973_b() == Blocks.field_196577_ad.func_199767_j() && !((ItemStack)this.furnaceItemStacks.get(1)).func_190926_b() && ((ItemStack)this.furnaceItemStacks.get(1)).func_77973_b() == Items.field_151133_ar) {
                this.furnaceItemStacks.set(1, (Object)new ItemStack((IItemProvider)Items.field_151131_as));
            }
            ((ItemStack)this.furnaceItemStacks.get(0)).func_190918_g(1);
            if (((ItemStack)this.furnaceItemStacks.get(0)).func_190916_E() <= 0) {
                this.furnaceItemStacks.set(0, (Object)ItemStack.field_190927_a);
            }
        }
    }

    public static int getItemBurnTime(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        int ret = stack.getBurnTime();
        return ForgeEventFactory.getItemBurnTime((ItemStack)stack, (int)(ret == -1 ? TileEntityFurnace.func_201564_p().getOrDefault(item, 0) : ret));
    }

    public static boolean isItemFuel(ItemStack stack) {
        return TileEntityKeypadFurnace.getItemBurnTime(stack) > 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.furnaceItemStacks) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 2 ? false : (index != 1 ? true : TileEntityKeypadFurnace.isItemFuel(stack) || SlotFurnaceFuel.func_178173_c_((ItemStack)stack));
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? slotsBottom : (side == EnumFacing.UP ? slotsTop : slotsSides);
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing direction) {
        return this.func_94041_b(index, stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        Item item;
        return direction != EnumFacing.DOWN || index != 1 || (item = stack.func_77973_b()) == Items.field_151131_as || item == Items.field_151133_ar;
    }

    public String getGuiID() {
        return "minecraft:furnace";
    }

    public Container createContainer(InventoryPlayer playerInventory, EntityPlayer player) {
        return new ContainerFurnace(playerInventory, (IInventory)this);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.furnaceBurnTime;
            }
            case 1: {
                return this.currentItemBurnTime;
            }
            case 2: {
                return this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.furnaceBurnTime = value;
                break;
            }
            case 1: {
                this.currentItemBurnTime = value;
                break;
            }
            case 2: {
                this.cookTime = value;
                break;
            }
            case 3: {
                this.totalCookTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.furnaceItemStacks.size(); ++i) {
            this.furnaceItemStacks.set(i, (Object)ItemStack.field_190927_a);
        }
    }

    public ITextComponent func_145748_c_() {
        return this.hasCustomSCName() ? this.func_200200_C_() : new TextComponentTranslation(this.func_200200_C_().func_150254_d(), new Object[0]);
    }

    @Override
    public void activate(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K && BlockUtils.getBlock(this.func_145831_w(), this.func_174877_v()) instanceof BlockKeypadFurnace) {
            BlockKeypadFurnace.activate(this.field_145850_b, this.field_174879_c, player);
        }
    }

    @Override
    public void openPasswordGUI(EntityPlayer player) {
        if (this.getPassword() != null) {
            if (player instanceof EntityPlayerMP) {
                NetworkHooks.openGui((EntityPlayerMP)((EntityPlayerMP)player), (IInteractionObject)new BaseInteractionObject(GuiHandler.INSERT_PASSWORD), (BlockPos)this.field_174879_c);
            }
        } else if (this.getOwner().isOwner(player)) {
            if (player instanceof EntityPlayerMP) {
                NetworkHooks.openGui((EntityPlayerMP)((EntityPlayerMP)player), (IInteractionObject)new BaseInteractionObject(GuiHandler.SETUP_PASSWORD), (BlockPos)this.field_174879_c);
            }
        } else {
            PlayerUtils.sendMessageToPlayer(player, "SecurityCraft", ClientUtils.localize("messages.securitycraft:passwordProtected.notSetUp", new Object[0]), TextFormatting.DARK_RED);
        }
    }

    @Override
    public boolean onCodebreakerUsed(IBlockState blockState, EntityPlayer player, boolean isCodebreakerDisabled) {
        if (!isCodebreakerDisabled) {
            this.activate(player);
            return true;
        }
        PlayerUtils.sendMessageToPlayer(player, ClientUtils.localize(SCContent.keypadFurnace.func_149739_a(), new Object[0]), ClientUtils.localize("messages.securitycraft:codebreakerDisabled", new Object[0]), TextFormatting.RED);
        return false;
    }

    @Override
    public String getPassword() {
        return this.passcode != null && !this.passcode.isEmpty() ? this.passcode : null;
    }

    @Override
    public void setPassword(String password) {
        this.passcode = password;
    }

    public ITextComponent func_200201_e() {
        return this.getCustomSCName();
    }

    public boolean func_145818_k_() {
        return this.hasCustomSCName();
    }
}

