/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.ArrayList;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.EnumLinkedAction;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.BlockLaserBlock;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;

public class TileEntityLaserBlock
extends CustomizableSCTE {
    private Option.OptionBoolean enabledOption = new Option.OptionBoolean("enabled", true){

        @Override
        public void toggle() {
            this.setValue(this.getValue() == false);
            TileEntityLaserBlock.this.toggleLaser(this);
        }
    };

    public TileEntityLaserBlock() {
        super(SCContent.teTypeLaserBlock);
    }

    private void toggleLaser(Option.OptionBoolean option) {
        if (BlockUtils.getBlock(this.field_145850_b, this.field_174879_c) != SCContent.laserBlock) {
            return;
        }
        if (option.getValue().booleanValue()) {
            ((BlockLaserBlock)BlockUtils.getBlock(this.field_145850_b, this.field_174879_c)).setLaser(this.field_145850_b, this.field_174879_c);
        } else {
            BlockLaserBlock.destroyAdjacentLasers((IWorld)this.field_145850_b, this.field_174879_c);
        }
    }

    @Override
    protected void onLinkedBlockAction(EnumLinkedAction action, Object[] parameters, ArrayList<CustomizableSCTE> excludedTEs) {
        if (action == EnumLinkedAction.OPTION_CHANGED) {
            Option option = (Option)parameters[0];
            this.enabledOption.copy(option);
            this.toggleLaser((Option.OptionBoolean)option);
            excludedTEs.add(this);
            this.createLinkedBlockAction(EnumLinkedAction.OPTION_CHANGED, (Object[])new Option[]{option}, excludedTEs);
        } else if (action == EnumLinkedAction.MODULE_INSERTED) {
            ItemStack module = (ItemStack)parameters[0];
            this.insertModule(module);
            excludedTEs.add(this);
            this.createLinkedBlockAction(EnumLinkedAction.MODULE_INSERTED, parameters, excludedTEs);
        } else if (action == EnumLinkedAction.MODULE_REMOVED) {
            EnumCustomModules module = (EnumCustomModules)((Object)parameters[1]);
            this.removeModule(module);
            excludedTEs.add(this);
            this.createLinkedBlockAction(EnumLinkedAction.MODULE_REMOVED, parameters, excludedTEs);
        }
    }

    @Override
    public EnumCustomModules[] acceptedModules() {
        return new EnumCustomModules[]{EnumCustomModules.HARMING, EnumCustomModules.WHITELIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.enabledOption};
    }

    public ITextComponent func_200201_e() {
        return this.getCustomSCName();
    }

    public boolean func_145818_k_() {
        return this.hasCustomSCName();
    }
}

