/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.BlockMotionActivatedLight;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.util.BlockUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class TileEntityMotionLight
extends CustomizableSCTE {
    private Option.OptionDouble searchRadiusOption;

    public TileEntityMotionLight() {
        super(SCContent.teTypeMotionLight);
        this.searchRadiusOption = new Option.OptionDouble("searchRadius", (Double)ConfigHandler.CommonConfig.CONFIG.motionActivatedLightSearchRadius.get(), 5.0, 20.0, 5.0);
    }

    @Override
    public boolean attackEntity(Entity entity) {
        if (entity instanceof EntityPlayer && PlayerUtils.isPlayerMountedOnCamera((EntityLivingBase)((EntityPlayer)entity))) {
            BlockMotionActivatedLight.toggleLight(this.field_145850_b, this.field_174879_c, this.searchRadiusOption.asDouble(), this.getOwner(), false);
        }
        if (entity instanceof EntityLivingBase && BlockUtils.getBlock(this.func_145831_w(), this.field_174879_c) == SCContent.motionActivatedLight && !BlockUtils.getBlockPropertyAsBoolean(this.func_145831_w(), this.func_174877_v(), BlockMotionActivatedLight.LIT)) {
            BlockMotionActivatedLight.toggleLight(this.field_145850_b, this.field_174879_c, this.searchRadiusOption.asDouble(), this.getOwner(), true);
        }
        return false;
    }

    @Override
    public void attackFailed() {
        if (BlockUtils.getBlock(this.func_145831_w(), this.field_174879_c) == SCContent.motionActivatedLight && BlockUtils.getBlockPropertyAsBoolean(this.func_145831_w(), this.func_174877_v(), BlockMotionActivatedLight.LIT)) {
            BlockMotionActivatedLight.toggleLight(this.field_145850_b, this.field_174879_c, this.searchRadiusOption.asDouble(), this.getOwner(), false);
        }
    }

    @Override
    public boolean canAttack() {
        return true;
    }

    @Override
    public boolean shouldSyncToClient() {
        return false;
    }

    @Override
    public double getAttackRange() {
        return this.searchRadiusOption.asDouble();
    }

    @Override
    public EnumCustomModules[] acceptedModules() {
        return new EnumCustomModules[0];
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.searchRadiusOption};
    }

    @Override
    public ITextComponent func_200200_C_() {
        return new TextComponentString("Motion-Activated Light");
    }

    public ITextComponent func_200201_e() {
        return this.getCustomSCName();
    }

    public boolean func_145818_k_() {
        return this.hasCustomSCName();
    }
}

