/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.List;
import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableSCTE;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.blocks.BlockPortableRadar;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.state.IProperty;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class TileEntityPortableRadar
extends CustomizableSCTE {
    private Option.OptionDouble searchRadiusOption;
    private Option.OptionInt searchDelayOption;
    private Option.OptionBoolean repeatMessageOption;
    private Option.OptionBoolean enabledOption;
    private boolean shouldSendNewMessage;
    private String lastPlayerName;

    public TileEntityPortableRadar() {
        super(SCContent.teTypePortableRadar);
        this.searchRadiusOption = new Option.OptionDouble("searchRadius", (Double)ConfigHandler.CommonConfig.CONFIG.portableRadarSearchRadius.get(), 5.0, 50.0, 5.0);
        this.searchDelayOption = new Option.OptionInt("searchDelay", (Integer)ConfigHandler.CommonConfig.CONFIG.portableRadarDelay.get(), 4, 10, 1);
        this.repeatMessageOption = new Option.OptionBoolean("repeatMessage", true);
        this.enabledOption = new Option.OptionBoolean("enabled", true);
        this.shouldSendNewMessage = true;
        this.lastPlayerName = "";
    }

    @Override
    public boolean attackEntity(Entity attacked) {
        if (attacked instanceof EntityPlayer) {
            boolean redstoneModule;
            AxisAlignedBB area = new AxisAlignedBB(this.field_174879_c).func_72314_b(this.getAttackRange(), this.getAttackRange(), this.getAttackRange());
            List entities = this.field_145850_b.func_72872_a(this.entityTypeToAttack(), area);
            if (entities.isEmpty() && (!(redstoneModule = this.hasModule(EnumCustomModules.REDSTONE)) || redstoneModule && ((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockPortableRadar.POWERED)).booleanValue())) {
                BlockPortableRadar.togglePowerOutput(this.field_145850_b, this.field_174879_c, false);
                return false;
            }
            EntityPlayerMP owner = this.field_145850_b.func_73046_m().func_184103_al().func_152612_a(this.getOwner().getName());
            if (owner != null && this.hasModule(EnumCustomModules.WHITELIST) && ModuleUtils.getPlayersFromModule(this.field_145850_b, this.field_174879_c, EnumCustomModules.WHITELIST).contains(attacked.func_200200_C_().func_150254_d().toLowerCase())) {
                return false;
            }
            if (PlayerUtils.isPlayerOnline(this.getOwner().getName()) && this.shouldSendMessage((EntityPlayer)attacked)) {
                PlayerUtils.sendMessageToPlayer((EntityPlayer)owner, ClientUtils.localize(SCContent.portableRadar.func_149739_a(), new Object[0]), this.hasCustomSCName() ? ClientUtils.localize("messages.securitycraft:portableRadar.withName", new Object[0]).replace("#p", TextFormatting.ITALIC + attacked.func_200200_C_().func_150254_d() + TextFormatting.RESET).replace("#n", TextFormatting.ITALIC + this.getCustomSCName().func_150254_d() + TextFormatting.RESET) : ClientUtils.localize("messages.securitycraft:portableRadar.withoutName", new Object[0]).replace("#p", TextFormatting.ITALIC + attacked.func_200200_C_().func_150254_d() + TextFormatting.RESET).replace("#l", Utils.getFormattedCoordinates(this.field_174879_c)), TextFormatting.BLUE);
                this.setSentMessage();
            }
            if (this.hasModule(EnumCustomModules.REDSTONE)) {
                BlockPortableRadar.togglePowerOutput(this.field_145850_b, this.field_174879_c, true);
            }
            return true;
        }
        return false;
    }

    @Override
    public void attackFailed() {
        if (this.hasModule(EnumCustomModules.REDSTONE)) {
            BlockPortableRadar.togglePowerOutput(this.field_145850_b, this.field_174879_c, false);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("shouldSendNewMessage", this.shouldSendNewMessage);
        tag.func_74778_a("lastPlayerName", this.lastPlayerName);
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("shouldSendNewMessage")) {
            this.shouldSendNewMessage = tag.func_74767_n("shouldSendNewMessage");
        }
        if (tag.func_74764_b("lastPlayerName")) {
            this.lastPlayerName = tag.func_74779_i("lastPlayerName");
        }
    }

    public boolean shouldSendMessage(EntityPlayer player) {
        if (!player.func_200200_C_().func_150254_d().equals(this.lastPlayerName)) {
            this.shouldSendNewMessage = true;
            this.lastPlayerName = player.func_200200_C_().func_150254_d();
        }
        return (this.shouldSendNewMessage || this.repeatMessageOption.asBoolean()) && this.enabledOption.asBoolean() && !player.func_200200_C_().func_150254_d().equals(this.getOwner().getName());
    }

    public void setSentMessage() {
        this.shouldSendNewMessage = false;
    }

    @Override
    public boolean canAttack() {
        return true;
    }

    @Override
    public boolean shouldSyncToClient() {
        return false;
    }

    @Override
    public double getAttackRange() {
        return this.searchRadiusOption.asDouble();
    }

    @Override
    public int getTicksBetweenAttacks() {
        return this.searchDelayOption.asInteger() * 20;
    }

    @Override
    public EnumCustomModules[] acceptedModules() {
        return new EnumCustomModules[]{EnumCustomModules.REDSTONE, EnumCustomModules.WHITELIST};
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.searchRadiusOption, this.searchDelayOption, this.repeatMessageOption, this.enabledOption};
    }

    public ITextComponent func_200201_e() {
        return this.getCustomSCName();
    }

    public boolean func_145818_k_() {
        return this.hasCustomSCName();
    }
}

