/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.tileentity;

import java.util.ArrayList;
import java.util.Random;
import java.util.UUID;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.util.math.AxisAlignedBB;

public class TileEntityTrophySystem
extends TileEntityOwnable {
    public static final int range = 10;
    public static final int cooldownTime = 8;
    public Entity entityBeingTargeted = null;
    public int cooldown = 8;

    public TileEntityTrophySystem() {
        super(SCContent.teTypeTrophySystem);
    }

    @Override
    public void func_73660_a() {
        if (this.entityBeingTargeted == null) {
            Entity target = this.getTarget();
            UUID shooterUUID = this.getShooterUUID(target);
            if (target != null && shooterUUID != null && !shooterUUID.toString().equals(this.getOwner().getUUID())) {
                this.entityBeingTargeted = target;
            }
        }
        if (this.entityBeingTargeted == null) {
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        this.destroyTarget();
    }

    private void destroyTarget() {
        this.entityBeingTargeted.func_70106_y();
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_72876_a(null, this.entityBeingTargeted.field_70165_t, this.entityBeingTargeted.field_70163_u, this.entityBeingTargeted.field_70161_v, 1.0f, false);
        }
        this.resetTarget();
    }

    private void resetTarget() {
        this.cooldown = 8;
        this.entityBeingTargeted = null;
    }

    private Entity getTarget() {
        ArrayList potentialTargets = new ArrayList();
        AxisAlignedBB area = new AxisAlignedBB(this.field_174879_c).func_72314_b(10.0, 10.0, 10.0);
        potentialTargets.addAll(this.field_145850_b.func_72872_a(EntityArrow.class, area));
        potentialTargets.addAll(this.field_145850_b.func_72872_a(EntityFireball.class, area));
        if (potentialTargets.size() <= 0) {
            return null;
        }
        Random random = new Random();
        int target = random.nextInt(potentialTargets.size());
        return (Entity)potentialTargets.get(target);
    }

    public UUID getShooterUUID(Entity entity) {
        if (entity instanceof EntityArrow) {
            return ((EntityArrow)entity).field_70250_c;
        }
        if (entity instanceof EntityFireball) {
            return ((EntityFireball)entity).field_70235_a.func_110124_au();
        }
        return null;
    }
}

