/*
 * Decompiled with CFR 0.152.
 */
package mod.torchbowmod;

import javax.annotation.Nullable;
import mod.torchbowmod.TorchBowMod;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockTorchWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityTorch
extends EntityArrow {
    private int xTile;
    private int yTile;
    private int zTile;
    @Nullable
    private IBlockState inBlockState;
    private double damage;

    public EntityTorch(EntityType<?> type, World worldIn) {
        super(type, worldIn);
        this.xTile = -1;
        this.yTile = -1;
        this.zTile = -1;
        this.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
        this.damage = 2.0;
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityTorch(World world) {
        super(TorchBowMod.EMERALD_ARROW, world);
    }

    public EntityTorch(EntityType<?> type, double x, double y, double z, World worldIn) {
        this(type, worldIn);
        this.func_70107_b(x, y, z);
    }

    public EntityTorch(EntityType<?> type, EntityLivingBase shooter, World worldIn) {
        this(type, shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e() - (double)0.1f, shooter.field_70161_v, worldIn);
        this.func_212361_a((Entity)shooter);
        if (shooter instanceof EntityPlayer) {
            this.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
        }
    }

    protected void func_203046_b(RayTraceResult p_203046_1_) {
        super.func_203046_b(p_203046_1_);
        Entity entity = p_203046_1_.field_72308_g;
        entity.func_70015_d(100);
    }

    protected void func_184549_a(RayTraceResult raytraceResultIn) {
        super.func_184549_a(raytraceResultIn);
        if (raytraceResultIn.field_72308_g == null) {
            IBlockState iblockstate;
            BlockPos blockpos = raytraceResultIn.func_178782_a();
            this.xTile = blockpos.func_177958_n();
            this.yTile = blockpos.func_177956_o();
            this.zTile = blockpos.func_177952_p();
            this.inBlockState = iblockstate = this.field_70170_p.func_180495_p(blockpos);
            this.field_70159_w = (float)(raytraceResultIn.field_72307_f.field_72450_a - this.field_70165_t);
            this.field_70181_x = (float)(raytraceResultIn.field_72307_f.field_72448_b - this.field_70163_u);
            this.field_70179_y = (float)(raytraceResultIn.field_72307_f.field_72449_c - this.field_70161_v);
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y)) * 20.0f;
            this.field_70165_t -= this.field_70159_w / (double)f;
            this.field_70163_u -= this.field_70181_x / (double)f;
            this.field_70161_v -= this.field_70179_y / (double)f;
            this.func_184185_a(this.func_203050_i(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            this.field_70254_i = true;
            this.field_70249_b = 7;
            this.func_70243_d(false);
            if (iblockstate.func_185904_a() != Material.field_151579_a) {
                this.inBlockState.func_196950_a(this.field_70170_p, blockpos, (Entity)this);
                if (!this.field_70170_p.field_72995_K) {
                    int x = this.xTile;
                    int y = this.yTile;
                    int z = this.zTile;
                    World world = this.field_70170_p;
                    IBlockState torch_state = Blocks.field_150478_aa.func_176223_P();
                    BlockPos up_pos = new BlockPos(x, y + 1, z);
                    if (this.isBlockAIR(up_pos)) {
                        world.func_175656_a(up_pos, torch_state);
                        this.setDead();
                    } else {
                        torch_state = Blocks.field_196591_bQ.func_176223_P();
                        switch (this.func_174811_aO()) {
                            case EAST: {
                                BlockPos east_pos = new BlockPos(x + 1, y, z);
                                if (this.isBlockAIR(east_pos)) {
                                    world.func_175656_a(east_pos, (IBlockState)torch_state.func_206870_a((IProperty)BlockTorchWall.field_196532_a, (Comparable)EnumFacing.EAST));
                                    this.setDead();
                                    break;
                                }
                            }
                            case WEST: {
                                BlockPos west_pos = new BlockPos(x - 1, y, z);
                                if (this.isBlockAIR(west_pos)) {
                                    world.func_175656_a(west_pos, (IBlockState)torch_state.func_206870_a((IProperty)BlockTorchWall.field_196532_a, (Comparable)EnumFacing.WEST));
                                    this.setDead();
                                    break;
                                }
                            }
                            case NORTH: {
                                BlockPos north_pos = new BlockPos(x, y, z + 1);
                                if (this.isBlockAIR(north_pos)) {
                                    world.func_175656_a(north_pos, (IBlockState)torch_state.func_206870_a((IProperty)BlockTorchWall.field_196532_a, (Comparable)EnumFacing.SOUTH));
                                    this.setDead();
                                    break;
                                }
                            }
                            case SOUTH: {
                                BlockPos south_pos = new BlockPos(x, y, z - 1);
                                if (!this.isBlockAIR(south_pos)) break;
                                world.func_175656_a(south_pos, (IBlockState)torch_state.func_206870_a((IProperty)BlockTorchWall.field_196532_a, (Comparable)EnumFacing.NORTH));
                                this.setDead();
                            }
                        }
                    }
                }
            }
        }
    }

    private void setDead() {
        this.func_70106_y();
    }

    protected ItemStack func_184550_j() {
        return new ItemStack((IItemProvider)Blocks.field_150478_aa);
    }

    private boolean isBlockAIR(BlockPos pos) {
        Block[] a;
        Block getBlock = this.field_70170_p.func_180495_p(pos).func_177230_c();
        if (getBlock instanceof BlockBush) {
            return true;
        }
        for (Block traget : a = new Block[]{Blocks.field_201941_jj, Blocks.field_150350_a, Blocks.field_150433_aE}) {
            if (getBlock != traget) continue;
            return true;
        }
        return false;
    }
}

