/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.api;

import java.util.ArrayList;
import net.geforcemods.securitycraft.api.EnumLinkedAction;
import net.geforcemods.securitycraft.api.LinkedBlock;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.items.ItemModule;
import net.geforcemods.securitycraft.misc.EnumCustomModules;
import net.geforcemods.securitycraft.tileentity.TileEntityOwnable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;

public abstract class CustomizableSCTE
extends TileEntityOwnable
implements IInventory {
    private boolean linkable = false;
    public ArrayList<LinkedBlock> linkedBlocks = new ArrayList();
    private NBTTagList nbtTagStorage = null;
    public ItemStack[] itemStacks = new ItemStack[this.getNumberOfCustomizableOptions()];

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.func_145830_o() && this.nbtTagStorage != null) {
            this.readLinkedBlocks(this.nbtTagStorage);
            this.sync();
            this.nbtTagStorage = null;
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList nbttaglist = tag.func_150295_c("Modules", 10);
        this.itemStacks = new ItemStack[this.getNumberOfCustomizableOptions()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound moduleTag = nbttaglist.func_150305_b(i);
            byte b0 = moduleTag.func_74771_c("ModuleSlot");
            if (b0 < 0 || b0 >= this.itemStacks.length) continue;
            this.itemStacks[b0] = ItemStack.func_77949_a((NBTTagCompound)moduleTag);
        }
        if (this.customOptions() != null) {
            for (Option<?> option : this.customOptions()) {
                option.readFromNBT(tag);
            }
        }
        if (tag.func_74764_b("linkable")) {
            this.linkable = tag.func_74767_n("linkable");
        }
        if (this.linkable && tag.func_74764_b("linkedBlocks")) {
            if (!this.func_145830_o()) {
                this.nbtTagStorage = tag.func_150295_c("linkedBlocks", 10);
                return;
            }
            this.readLinkedBlocks(tag.func_150295_c("linkedBlocks", 10));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.itemStacks.length; ++i) {
            if (this.itemStacks[i] == null) continue;
            NBTTagCompound moduleTag = new NBTTagCompound();
            moduleTag.func_74774_a("ModuleSlot", (byte)i);
            this.itemStacks[i].func_77955_b(moduleTag);
            nbttaglist.func_74742_a((NBTBase)moduleTag);
        }
        tag.func_74782_a("Modules", (NBTBase)nbttaglist);
        if (this.customOptions() != null) {
            for (Option<?> option : this.customOptions()) {
                option.writeToNBT(tag);
            }
        }
        tag.func_74757_a("linkable", this.linkable);
        if (this.linkable && this.func_145830_o() && this.linkedBlocks.size() > 0) {
            NBTTagList tagList = new NBTTagList();
            for (LinkedBlock block : this.linkedBlocks) {
                NBTTagCompound toAppend = new NBTTagCompound();
                if (block != null) {
                    if (!block.validate(this.field_145850_b)) {
                        this.linkedBlocks.remove(block);
                        continue;
                    }
                    toAppend.func_74778_a("blockName", block.blockName);
                    toAppend.func_74768_a("blockX", block.blockX);
                    toAppend.func_74768_a("blockY", block.blockY);
                    toAppend.func_74768_a("blockZ", block.blockZ);
                }
                tagList.func_74742_a((NBTBase)toAppend);
            }
            tag.func_74782_a("linkedBlocks", (NBTBase)tagList);
        }
    }

    private void readLinkedBlocks(NBTTagList list) {
        if (!this.linkable) {
            return;
        }
        for (int i = 0; i < list.func_74745_c(); ++i) {
            String name = list.func_150305_b(i).func_74779_i("blockName");
            int x = list.func_150305_b(i).func_74762_e("blockX");
            int y = list.func_150305_b(i).func_74762_e("blockY");
            int z = list.func_150305_b(i).func_74762_e("blockZ");
            LinkedBlock block = new LinkedBlock(name, x, y, z);
            if (this.func_145830_o() && !block.validate(this.field_145850_b)) {
                list.func_74744_a(i);
                continue;
            }
            if (this.linkedBlocks.contains(block)) continue;
            CustomizableSCTE.link(this, block.asTileEntity(this.field_145850_b));
        }
    }

    @Override
    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tag);
    }

    @Override
    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public int func_70302_i_() {
        return this.getNumberOfCustomizableOptions();
    }

    public ItemStack func_70301_a(int index) {
        return this.itemStacks[index];
    }

    public ItemStack func_70298_a(int index, int amount) {
        if (this.itemStacks[index] != null) {
            if (this.itemStacks[index].field_77994_a <= amount) {
                ItemStack itemstack = this.itemStacks[index];
                this.itemStacks[index] = null;
                this.onModuleRemoved(itemstack, ((ItemModule)itemstack.func_77973_b()).getModule());
                this.createLinkedBlockAction(EnumLinkedAction.MODULE_REMOVED, new Object[]{itemstack, ((ItemModule)itemstack.func_77973_b()).getModule()}, this);
                return itemstack;
            }
            ItemStack itemstack = this.itemStacks[index].func_77979_a(amount);
            if (this.itemStacks[index].field_77994_a == 0) {
                this.itemStacks[index] = null;
            }
            this.onModuleRemoved(itemstack, ((ItemModule)itemstack.func_77973_b()).getModule());
            this.createLinkedBlockAction(EnumLinkedAction.MODULE_REMOVED, new Object[]{itemstack, ((ItemModule)itemstack.func_77973_b()).getModule()}, this);
            return itemstack;
        }
        return null;
    }

    public ItemStack safeDecrStackSize(int index, int amount) {
        if (this.itemStacks[index] != null) {
            if (this.itemStacks[index].field_77994_a <= amount) {
                ItemStack itemstack = this.itemStacks[index];
                this.itemStacks[index] = null;
                this.onModuleRemoved(itemstack, ((ItemModule)itemstack.func_77973_b()).getModule());
                this.createLinkedBlockAction(EnumLinkedAction.MODULE_REMOVED, new Object[]{itemstack, ((ItemModule)itemstack.func_77973_b()).getModule()}, this);
                return itemstack;
            }
            ItemStack itemstack = this.itemStacks[index].func_77979_a(amount);
            if (this.itemStacks[index].field_77994_a == 0) {
                this.itemStacks[index] = null;
            }
            this.onModuleRemoved(itemstack, ((ItemModule)itemstack.func_77973_b()).getModule());
            this.createLinkedBlockAction(EnumLinkedAction.MODULE_REMOVED, new Object[]{itemstack, ((ItemModule)itemstack.func_77973_b()).getModule()}, this);
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int index) {
        if (this.itemStacks[index] != null) {
            ItemStack itemstack = this.itemStacks[index];
            this.itemStacks[index] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.itemStacks[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        if (stack != null) {
            this.onModuleInserted(stack, ((ItemModule)stack.func_77973_b()).getModule());
        }
    }

    public void safeSetInventorySlotContents(int index, ItemStack stack) {
        this.itemStacks[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        if (stack != null && stack.func_77973_b() != null && stack.func_77973_b() instanceof ItemModule) {
            this.onModuleInserted(stack, ((ItemModule)stack.func_77973_b()).getModule());
            this.createLinkedBlockAction(EnumLinkedAction.MODULE_INSERTED, new Object[]{stack, ((ItemModule)stack.func_77973_b()).getModule()}, this);
        }
    }

    public String func_145825_b() {
        return "Customize";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() instanceof ItemModule;
    }

    @Override
    public void onTileEntityDestroyed() {
        if (this.linkable) {
            for (LinkedBlock block : this.linkedBlocks) {
                CustomizableSCTE.unlink(block.asTileEntity(this.field_145850_b), this);
            }
        }
        for (ItemStack module : this.itemStacks) {
            if (this.field_145850_b.field_72995_K || module == null || !this.field_145850_b.func_82736_K().func_82766_b("doTileDrops") || this.field_145850_b.restoringBlockSnapshots) continue;
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_145851_c + ((double)(this.field_145850_b.field_73012_v.nextFloat() * 0.5f) + 0.25), (double)this.field_145848_d + ((double)(this.field_145850_b.field_73012_v.nextFloat() * 0.5f) + 0.25), (double)this.field_145849_e + ((double)(this.field_145850_b.field_73012_v.nextFloat() * 0.5f) + 0.25), module));
        }
    }

    public void onModuleInserted(ItemStack stack, EnumCustomModules module) {
    }

    public void onModuleRemoved(ItemStack stack, EnumCustomModules module) {
    }

    public ArrayList<EnumCustomModules> getModules() {
        ArrayList<EnumCustomModules> modules = new ArrayList<EnumCustomModules>();
        for (ItemStack stack : this.itemStacks) {
            if (stack == null || !(stack.func_77973_b() instanceof ItemModule)) continue;
            modules.add(((ItemModule)stack.func_77973_b()).getModule());
        }
        return modules;
    }

    public ItemStack getModule(EnumCustomModules module) {
        for (int i = 0; i < this.itemStacks.length; ++i) {
            if (this.itemStacks[i] == null || !(this.itemStacks[i].func_77973_b() instanceof ItemModule) || ((ItemModule)this.itemStacks[i].func_77973_b()).getModule() != module) continue;
            return this.itemStacks[i];
        }
        return null;
    }

    public void insertModule(EnumCustomModules module) {
        int i;
        for (i = 0; i < this.itemStacks.length; ++i) {
            if (this.itemStacks[i] == null || this.itemStacks[i].func_77973_b() != module.getItem()) continue;
            return;
        }
        for (i = 0; i < this.itemStacks.length; ++i) {
            if (this.itemStacks[i] == null && module != null) {
                this.itemStacks[i] = new ItemStack((Item)module.getItem());
                break;
            }
            if (this.itemStacks[i] == null || module != null) continue;
            this.itemStacks[i] = null;
        }
    }

    public void insertModule(ItemStack module) {
        int i;
        if (module == null || !(module.func_77973_b() instanceof ItemModule)) {
            return;
        }
        for (i = 0; i < this.itemStacks.length; ++i) {
            if (this.itemStacks[i] == null || this.itemStacks[i].func_77973_b() != module.func_77973_b()) continue;
            return;
        }
        for (i = 0; i < this.itemStacks.length; ++i) {
            if (this.itemStacks[i] != null) continue;
            this.itemStacks[i] = module.func_77946_l();
            break;
        }
    }

    public void removeModule(EnumCustomModules module) {
        for (int i = 0; i < this.itemStacks.length; ++i) {
            if (this.itemStacks[i] == null || !(this.itemStacks[i].func_77973_b() instanceof ItemModule) || ((ItemModule)this.itemStacks[i].func_77973_b()).getModule() != module) continue;
            this.itemStacks[i] = null;
        }
    }

    public boolean hasModule(EnumCustomModules module) {
        if (module == null) {
            for (int i = 0; i < this.itemStacks.length; ++i) {
                if (this.itemStacks[i] != null) continue;
                return true;
            }
        } else {
            for (int i = 0; i < this.itemStacks.length; ++i) {
                if (this.itemStacks[i] == null || !(this.itemStacks[i].func_77973_b() instanceof ItemModule) || ((ItemModule)this.itemStacks[i].func_77973_b()).getModule() != module) continue;
                return true;
            }
        }
        return false;
    }

    public ArrayList<Item> getItemAddonsFromModule(EnumCustomModules module) {
        for (int i = 0; i < this.itemStacks.length; ++i) {
            if (this.itemStacks[i] == null || !(this.itemStacks[i].func_77973_b() instanceof ItemModule) || ((ItemModule)this.itemStacks[i].func_77973_b()).getModule() != module) continue;
            return ((ItemModule)this.itemStacks[i].func_77973_b()).getItemAddons(this.itemStacks[i].func_77978_p());
        }
        return null;
    }

    public ArrayList<Block> getBlockAddonsFromModule(EnumCustomModules module) {
        for (int i = 0; i < this.itemStacks.length; ++i) {
            if (this.itemStacks[i] == null || !(this.itemStacks[i].func_77973_b() instanceof ItemModule) || ((ItemModule)this.itemStacks[i].func_77973_b()).getModule() != module) continue;
            return ((ItemModule)this.itemStacks[i].func_77973_b()).getBlockAddons(this.itemStacks[i].func_77978_p());
        }
        return null;
    }

    public ArrayList<ItemStack> getAddonsFromModule(EnumCustomModules module) {
        for (int i = 0; i < this.itemStacks.length; ++i) {
            if (this.itemStacks[i] == null || !(this.itemStacks[i].func_77973_b() instanceof ItemModule) || ((ItemModule)this.itemStacks[i].func_77973_b()).getModule() != module) continue;
            return ((ItemModule)this.itemStacks[i].func_77973_b()).getAddons(this.itemStacks[i].func_77978_p());
        }
        return null;
    }

    public int getNumberOfCustomizableOptions() {
        return this.acceptedModules().length;
    }

    public ArrayList<EnumCustomModules> getAcceptedModules() {
        ArrayList<EnumCustomModules> list = new ArrayList<EnumCustomModules>();
        for (EnumCustomModules module : this.acceptedModules()) {
            list.add(module);
        }
        return list;
    }

    public Option<?> getOptionByName(String name) {
        for (Option<?> option : this.customOptions()) {
            if (!option.getName().equals(name)) continue;
            return option;
        }
        return null;
    }

    public CustomizableSCTE linkable() {
        this.linkable = true;
        return this;
    }

    public boolean canBeLinkedWith() {
        return this.linkable;
    }

    public static void link(CustomizableSCTE tileEntity1, CustomizableSCTE tileEntity2) {
        if (!tileEntity1.linkable || !tileEntity2.linkable) {
            return;
        }
        if (CustomizableSCTE.isLinkedWith(tileEntity1, tileEntity2)) {
            return;
        }
        LinkedBlock block1 = new LinkedBlock(tileEntity1);
        LinkedBlock block2 = new LinkedBlock(tileEntity2);
        if (!tileEntity1.linkedBlocks.contains(block2)) {
            tileEntity1.linkedBlocks.add(block2);
        }
        if (!tileEntity2.linkedBlocks.contains(block1)) {
            tileEntity2.linkedBlocks.add(block1);
        }
    }

    public static void unlink(CustomizableSCTE tileEntity1, CustomizableSCTE tileEntity2) {
        if (tileEntity1 == null || tileEntity2 == null) {
            return;
        }
        if (!tileEntity1.linkable || !tileEntity2.linkable) {
            return;
        }
        LinkedBlock block = new LinkedBlock(tileEntity2);
        if (tileEntity1.linkedBlocks.contains(block)) {
            tileEntity1.linkedBlocks.remove(block);
        }
    }

    public static boolean isLinkedWith(CustomizableSCTE tileEntity1, CustomizableSCTE tileEntity2) {
        if (!tileEntity1.linkable || !tileEntity2.linkable) {
            return false;
        }
        return tileEntity1.linkedBlocks.contains(new LinkedBlock(tileEntity2)) && tileEntity2.linkedBlocks.contains(new LinkedBlock(tileEntity1));
    }

    public void onOptionChanged(Option<?> option) {
        this.createLinkedBlockAction(EnumLinkedAction.OPTION_CHANGED, (Object[])new Option[]{option}, this);
    }

    public void createLinkedBlockAction(EnumLinkedAction action, Object[] parameters, CustomizableSCTE excludedTE) {
        ArrayList<CustomizableSCTE> list = new ArrayList<CustomizableSCTE>();
        list.add(excludedTE);
        this.createLinkedBlockAction(action, parameters, list);
    }

    public void createLinkedBlockAction(EnumLinkedAction action, Object[] parameters, ArrayList<CustomizableSCTE> excludedTEs) {
        if (!this.linkable) {
            return;
        }
        for (LinkedBlock block : this.linkedBlocks) {
            if (excludedTEs.contains(block.asTileEntity(this.field_145850_b))) continue;
            block.asTileEntity(this.field_145850_b).onLinkedBlockAction(action, parameters, excludedTEs);
            block.asTileEntity(this.field_145850_b).sync();
        }
    }

    protected void onLinkedBlockAction(EnumLinkedAction action, Object[] parameters, ArrayList<CustomizableSCTE> excludedTEs) {
    }

    public abstract EnumCustomModules[] acceptedModules();

    public abstract Option<?>[] customOptions();
}

